/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Processor;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.FileSystem.fsConnectionInt;
import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.FileSystem.fsProcessStatus;
import au.com.aemo.Common.Files.FileNameTokenResolver;
import au.com.aemo.Common.Files.FileUtilities;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.XML.XmlUtilities;
import au.com.nemmco.Pdr.Batcher.Processor.aseXML.aseXMLDocumentInfo;
import au.com.nemmco.Pdr.Batcher.Processor.pdrBatcherHandlerAseXMLSendBase;
import au.com.nemmco.Pdr.Batcher.Processor.pdrBatcherHandlerConfig;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class pdrBatcherHandlerAseXMLSendAPI
extends pdrBatcherHandlerAseXMLSendBase {
    private static Logger logger = LoggerFactory.getLogger(pdrBatcherHandlerAseXMLSendAPI.class);

    public pdrBatcherHandlerAseXMLSendAPI(pdrBatcherHandlerConfig pdrBatcherHandlerConfig2) throws ApplicationException {
        super(pdrBatcherHandlerConfig2);
    }

    @Override
    protected boolean checkReceivingParticipantIsStopped(fsFileInfo fsFileInfo2, aseXMLDocumentInfo aseXMLDocumentInfo2) throws Exception {
        return false;
    }

    @Override
    protected boolean requiresDestinationDirectoryListing() {
        return false;
    }

    private int addParticipantActual(MSATSLimitReportItem mSATSLimitReportItem) {
        return mSATSLimitReportItem != null ? mSATSLimitReportItem.ParticipantActual : 0;
    }

    @Override
    protected boolean removeSourceFileAfterProcessing() {
        return true;
    }

    @Override
    protected void completePollCycle(String string) {
    }

    @Override
    protected Map<String, fsFileInfo> getAEMOInboxDirList(String string) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int getActiveTransactionCount(String string) throws ApplicationException {
        int n2 = 0;
        fsConnectionInt fsConnectionInt2 = null;
        try {
            fsConnectionInt2 = this.getDestinationConnection();
            fsFileInfo fsFileInfo2 = new fsFileInfo();
            fsFileInfo2.addEventParameter("ParticipantId", string);
            fsFileInfo2.setDirectory(FileNameTokenResolver.process(this.getHubManagementAPIURL(), fsFileInfo2));
            fsFileInfo2.addAPIHeaderValues(this.getHubManagementAPIHeaderValues());
            fsFileInfo fsFileInfo3 = fsConnectionInt2.getFile(fsFileInfo2, this.getHoldingDir());
            Document document = XmlUtilities.fileToDocument(fsFileInfo3.getPath());
            NodeList nodeList = document.getElementsByTagName("MsatsLimits");
            String string2 = XmlUtilities.xmlNodeToString(nodeList.item(0));
            XStream xStream = XmlUtilities.getConverter();
            xStream.processAnnotations(MSATSLimitReportItem.class);
            xStream.processAnnotations(MSATSLimitReport.class);
            MSATSLimitReport mSATSLimitReport = (MSATSLimitReport)xStream.fromXML(string2);
            if (mSATSLimitReport != null) {
                n2 += this.addParticipantActual(mSATSLimitReport.Cr);
                n2 += this.addParticipantActual(mSATSLimitReport.CrNotification);
                n2 += this.addParticipantActual(mSATSLimitReport.NsrdNotification);
                n2 += this.addParticipantActual(mSATSLimitReport.NsrdResponse);
                n2 += this.addParticipantActual(mSATSLimitReport.OutboxFile);
                n2 += this.addParticipantActual(mSATSLimitReport.Report);
            }
            FileUtilities.deleteFile(fsFileInfo3);
        }
        catch (Exception exception) {
            try {
                if (fsConnectionInt2 != null) {
                    fsConnectionInt2.disconnect();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            Util_Logger.error(logger, "Detected exception calling HubManagement API: " + exception.getMessage(), exception);
        }
        finally {
            this.freeDestinationConnection(fsConnectionInt2);
        }
        return n2;
    }

    @Override
    protected fsProcessStatus processSingleFileAction(fsConnectionInt fsConnectionInt2, fsFileInfo fsFileInfo2, fsFileInfo fsFileInfo3, String string, fsConnectionInt fsConnectionInt3, String string2, Map<String, fsFileInfo> map, boolean bl, boolean bl2) {
        fsProcessStatus fsProcessStatus2 = new fsProcessStatus();
        try {
            if (!this.checkReceivingParticipantIsStopped(fsFileInfo2, fsFileInfo3)) {
                boolean bl3;
                if (fsConnectionInt3.logOperations()) {
                    Util_Logger.info(logger, "Now sending " + fsFileInfo3.getFilename() + " to " + string2 + " in thread " + this.getId());
                }
                Date date = new Date();
                fsProcessStatus2 = fsConnectionInt3.putFile(fsFileInfo3, string2, bl2, this.getHoldingDir());
                fsFileInfo fsFileInfo4 = fsProcessStatus2.getAcknowledgementResponse();
                boolean bl4 = bl3 = fsProcessStatus2.getAcknowledgementResponseCode() == 200;
                if (bl3) {
                    fsProcessStatus2.setProcessSuccess();
                }
                this.processAcknowledgementPerformanceData(fsFileInfo4, date);
            }
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Detected error sending aseXML transaction [" + fsFileInfo3.getFilename() + "]: " + exception.getMessage() + " in thread " + this.getId(), exception);
        }
        return fsProcessStatus2;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Only used by trusted code")
    private class MSATSLimitReportItem {
        public int DefaultLimit;
        public int UpperLimit;
        public int ParticipantActual;
        public String StopFlag;

        private MSATSLimitReportItem() {
        }
    }

    @XStreamAlias(value="MsatsLimits")
    @SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC"}, justification="Class cannot be static")
    private class MSATSLimitReport {
        public MSATSLimitReportItem Cr;
        public MSATSLimitReportItem CrNotification;
        public MSATSLimitReportItem NsrdNotification;
        public MSATSLimitReportItem NsrdResponse;
        public MSATSLimitReportItem OutboxFile;
        public MSATSLimitReportItem Report;

        private MSATSLimitReport() {
        }
    }
}

