/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Processor;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.FileSystem.fsConnectionInt;
import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.Files.FileNameTokenResolver;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Jobs.LockManager;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.nemmco.Pdr.Batcher.Processor.Util.pdrBatcherHandlerDownloadFile;
import au.com.nemmco.Pdr.Batcher.Processor.aseXML.aseXMLDocumentInfo;
import au.com.nemmco.Pdr.Batcher.Processor.pdrBatcherHandlerAseXMLSendBase;
import au.com.nemmco.Pdr.Batcher.Processor.pdrBatcherHandlerConfig;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrBatcherHandlerAseXMLSendFTP
extends pdrBatcherHandlerAseXMLSendBase {
    private static Logger logger = LoggerFactory.getLogger(pdrBatcherHandlerAseXMLSendFTP.class);
    private Map<String, DirList> itsAemoDirInboxListing = new HashMap<String, DirList>();
    private Map<String, DirList> itsAemoDirOutboxListing = new HashMap<String, DirList>();
    private Map<String, DirList> itsAemoDirStopboxListing = new HashMap<String, DirList>();

    public pdrBatcherHandlerAseXMLSendFTP(pdrBatcherHandlerConfig pdrBatcherHandlerConfig2) throws ApplicationException {
        super(pdrBatcherHandlerConfig2);
    }

    @Override
    protected boolean requiresDestinationDirectoryListing() {
        return false;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="Retain Participant ID so that directpory listing has context")
    private void getDirectoryListings(String string) throws ApplicationException {
        String string2 = string.toUpperCase();
        DirList dirList = new DirList();
        dirList.ParticipantId = string2;
        dirList.Files = this.getDestinationListing(string2, "INBOX", "INBOX");
        this.itsAemoDirInboxListing.put(string2, dirList);
        dirList = new DirList();
        dirList.ParticipantId = string2;
        dirList.Files = this.getDestinationListing(string2, "INBOX", "OUTBOX");
        this.itsAemoDirOutboxListing.put(string2, dirList);
        dirList = new DirList();
        dirList.ParticipantId = string2;
        dirList.Files = this.getDestinationListing(string2, "INBOX", "STOPBOX");
        this.itsAemoDirStopboxListing.put(string2, dirList);
    }

    @Override
    protected Map<String, fsFileInfo> getAEMOInboxDirList(String string) throws ApplicationException {
        DirList dirList = this.itsAemoDirInboxListing.get(string.toUpperCase());
        if (dirList == null) {
            this.getDirectoryListings(string.toUpperCase());
            dirList = this.itsAemoDirInboxListing.get(string.toUpperCase());
        }
        return dirList.Files;
    }

    @Override
    protected int getActiveTransactionCount(String string) throws ApplicationException {
        Map<String, fsFileInfo> map = this.getDestinationListing(string, "INBOX", "INBOX");
        int n2 = 0;
        for (fsFileInfo fsFileInfo2 : map.values()) {
            if (!fsFileInfo2.getExtension().equalsIgnoreCase("ZIP")) continue;
            ++n2;
        }
        return n2;
    }

    @Override
    protected boolean checkReceivingParticipantIsStopped(fsFileInfo fsFileInfo2, aseXMLDocumentInfo aseXMLDocumentInfo2) throws Exception {
        boolean bl = false;
        if (this.isB2BFileType(fsFileInfo2)) {
            try {
                String string;
                fsFileInfo fsFileInfo3;
                DirList dirList = this.itsAemoDirStopboxListing.get(aseXMLDocumentInfo2.getFromName().toUpperCase());
                if (dirList == null) {
                    this.getDirectoryListings(aseXMLDocumentInfo2.getFromName());
                    dirList = this.itsAemoDirStopboxListing.get(aseXMLDocumentInfo2.getFromName().toUpperCase());
                }
                if (dirList.Files.size() > 0 && (fsFileInfo3 = dirList.Files.get((string = aseXMLDocumentInfo2.getToName() + "_B2Bholdinp.stp").toLowerCase())) != null) {
                    Util_Logger.warning(logger, "Not sending B2B file " + fsFileInfo2.getFilename() + " as participant " + aseXMLDocumentInfo2.getToName() + " was stopped as of " + Util.dateToStr(fsFileInfo3.getModifiedDate(), "dd/MM/yyyy HH:mm:ss"));
                    bl = true;
                }
            }
            catch (Exception exception) {
                Util_Logger.warning(logger, "Error checking B2B stopbox status for delivery of file " + fsFileInfo2.getFilename() + ": " + exception.getMessage());
                bl = true;
            }
        }
        return bl;
    }

    protected void processAck(String string, fsFileInfo fsFileInfo2, boolean bl, fsConnectionInt fsConnectionInt2, String string2, fsConnectionInt fsConnectionInt3) throws Exception {
        Date date = new Date();
        pdrBatcherHandlerDownloadFile pdrBatcherHandlerDownloadFile2 = new pdrBatcherHandlerDownloadFile(this.getHoldingDir(), this.getCheckFileIntegrity());
        fsFileInfo fsFileInfo3 = pdrBatcherHandlerDownloadFile2.getSourceFile(fsConnectionInt3, fsFileInfo2, this.getId(), "ack", null);
        this.processAcknowledgementPerformanceData(fsFileInfo3, date);
        String string3 = FileNameTokenResolver.process(this.getSourceAckDir(), fsFileInfo2);
        Util_Logger.info(logger, "Archiving acknowledgement file [" + fsFileInfo2.getFilename() + "] to " + string3);
        fsConnectionInt2.putFile(fsFileInfo3, string3, true, null);
        if (fsConnectionInt2.exists(string2, string)) {
            Util_Logger.info(logger, "Archiving acknowledged Inbox file [" + string + "] to " + string3);
            fsConnectionInt2.renameFile(string2, string, string3, string);
        }
        Util_Logger.info(logger, "Removing acknowledged Inbox file [" + string + "] from AEMO Inbox");
        String string4 = this.getParticipantId(fsFileInfo2);
        fsConnectionInt3.deleteFile(this.resolveDestinationDir(string4), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void completePollCycle(String string) {
        LockManager lockManager = LockManager.getInstance();
        fsConnectionInt fsConnectionInt2 = null;
        fsConnectionInt fsConnectionInt3 = null;
        try {
            fsConnectionInt2 = this.getSourceConnection();
            fsConnectionInt3 = this.getDestinationConnection();
            for (String string2 : this.getParticipantIdList()) {
                DirList dirList = this.itsAemoDirOutboxListing.get(string2);
                if (dirList == null) {
                    this.getDirectoryListings(string2);
                    dirList = this.itsAemoDirOutboxListing.get(string2);
                }
                for (fsFileInfo fsFileInfo2 : dirList.Files.values()) {
                    if (fsFileInfo2.getExtension().equalsIgnoreCase("ZIP")) continue;
                    String string3 = this.calcFilename(fsFileInfo2, "ZIP");
                    DirList dirList2 = this.itsAemoDirInboxListing.get(string2);
                    if (!dirList2.Files.containsKey(string3.toLowerCase()) || !lockManager.addTask(fsFileInfo2.getName())) continue;
                    try {
                        boolean bl = fsFileInfo2.getExtension().equalsIgnoreCase("ack");
                        fsFileInfo2.processFilenameMask(this.getSourceFilenameMask());
                        fsFileInfo2.addEventParameter("process_status", Boolean.toString(bl));
                        this.processAck(string3, fsFileInfo2, bl, fsConnectionInt2, string, fsConnectionInt3);
                    }
                    finally {
                        lockManager.deleteTask(fsFileInfo2.getName());
                    }
                }
            }
        }
        catch (Exception exception) {
            try {
                if (fsConnectionInt2 != null) {
                    fsConnectionInt2.disconnect();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            try {
                if (fsConnectionInt3 != null) {
                    fsConnectionInt3.disconnect();
                }
            }
            catch (Exception exception3) {
                // empty catch block
            }
            Util_Logger.errorNoRaise(logger, "Detected exception processing aseXML files: " + exception.getMessage(), exception);
        }
        finally {
            this.freeSourceConnection(fsConnectionInt2);
            this.freeDestinationConnection(fsConnectionInt3);
        }
        this.itsAemoDirInboxListing.clear();
        this.itsAemoDirOutboxListing.clear();
        this.itsAemoDirStopboxListing.clear();
    }

    @SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC"}, justification="Class cannot be static")
    private class DirList {
        public String ParticipantId;
        public Map<String, fsFileInfo> Files = new HashMap<String, fsFileInfo>();

        private DirList() {
        }
    }
}

