/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Processor;

import au.com.aemo.Common.Application.ConfigurationManager;
import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.FileSystem.fsFileLockInt;
import au.com.aemo.Common.JSON.JsonUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.nemmco.Pdr.Batcher.IO.pdrBatcherDataIOInt;
import au.com.nemmco.Pdr.Batcher.IO.pdrBatcherDataIOManager;
import com.google.gson.reflect.TypeToken;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class pdrFileWebManager {
    private static Logger logger = LoggerFactory.getLogger(pdrFileWebManager.class);
    private volatile Map<String, fileDetailWeb> itsDirCache;
    private String itsCacheStateFile;
    private volatile Date itsLastPersisted;
    private int itsCacheStateFileWriteMins;
    private volatile boolean itsHasUpdates;
    private static boolean hasInstance = false;

    private pdrFileWebManager() {
        ConfigurationManager configurationManager = ConfigurationManager.getInstance();
        this.itsCacheStateFile = configurationManager.getProperty("batcher_web_manager_cache", "web_manager_cache_state.txt");
        this.itsCacheStateFileWriteMins = Integer.parseInt(configurationManager.getProperty("batcher_web_manager_cache_write_mins", "5"));
        this.itsDirCache = this.loadCacheFromFile();
        this.itsLastPersisted = new Date();
        this.itsHasUpdates = false;
        hasInstance = true;
    }

    public static pdrFileWebManager getInstance() {
        return SingletonHolder.instance;
    }

    public static void stop() {
        if (hasInstance) {
            pdrFileWebManager.getInstance().saveCacheToFile();
        }
    }

    private String getKey(String string, String string2, String string3) {
        return string + ":" + string2 + ":" + string3;
    }

    private boolean isLater(String string, Date date, fileDetailWeb fileDetailWeb2) {
        if (fileDetailWeb2 == null) {
            return true;
        }
        return fileDetailWeb2.isLater(string, date);
    }

    public boolean processFile(String string, String string2, String string3, String string4, Date date) {
        boolean bl = false;
        try {
            String string5 = this.getKey(string, string2, string3);
            fileDetailWeb fileDetailWeb2 = this.itsDirCache.get(string5);
            bl = this.isLater(string4, date, fileDetailWeb2);
        }
        catch (Exception exception) {
            Util_Logger.warning(logger, "Error checking currency for processing file " + string4 + ": " + exception.getMessage(), exception);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setDefaultCachePosition(String string, String string2, String string3, String string4, Date date) {
        String string5 = this.getKey(string, string2, string3);
        fileDetailWeb fileDetailWeb2 = this.itsDirCache.get(string5);
        if (fileDetailWeb2 == null) {
            fileDetailWeb fileDetailWeb3 = new fileDetailWeb();
            fileDetailWeb3.filenames.add(string4);
            fileDetailWeb3.modifiedDate = date;
            Map<String, fileDetailWeb> map = this.itsDirCache;
            synchronized (map) {
                this.itsDirCache.put(string5, fileDetailWeb3);
                Util_Logger.info(logger, "Setting default cache position for " + string5 + " to " + string4 + ", timestamp " + Util.dateToStr(date, "dd/MM/yyyy HH:mm:ss"));
            }
            this.itsHasUpdates = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateCache(String string, String string2, String string3, String string4, Date date) {
        if (!Util.isBlank(string4)) {
            Map<String, fileDetailWeb> map = this.itsDirCache;
            synchronized (map) {
                String string5 = this.getKey(string, string2, string3);
                fileDetailWeb fileDetailWeb2 = this.itsDirCache.get(string5);
                if (fileDetailWeb2 != null) {
                    fileDetailWeb2.updateCache(string4, date);
                } else {
                    this.setDefaultCachePosition(string, string2, string3, string4, date);
                }
                this.itsHasUpdates = true;
                Date date2 = Util.dateOffset(new Date(), -this.itsCacheStateFileWriteMins, 12);
                if (this.itsLastPersisted.before(date2)) {
                    this.saveCacheToFile();
                }
            }
        }
    }

    @SuppressFBWarnings(value={"DM_EXIT"}, justification="Fatal configuration error requires exit from application")
    private Map<String, fileDetailWeb> loadCacheFromFile() {
        Map<String, fileDetailWeb> map = new ConcurrentHashMap<String, fileDetailWeb>();
        try {
            pdrBatcherDataIOInt pdrBatcherDataIOInt2 = pdrBatcherDataIOManager.getInstance().getProvider();
            fsFileInfo fsFileInfo2 = pdrBatcherDataIOInt2.resolveCacheFilename(this.itsCacheStateFile);
            fsFileLockInt fsFileLockInt2 = pdrBatcherDataIOInt2.lockCacheFile(fsFileInfo2);
            if (fsFileLockInt2.isValid()) {
                fsFileInfo2.setLockData(fsFileLockInt2);
                String string = pdrBatcherDataIOInt2.loadCacheFile(fsFileInfo2);
                map = (Map)JsonUtilities.fromJson(string, new TypeToken<Map<String, fileDetailWeb>>(){}.getType());
                Util_Logger.info(logger, "Loaded web cache state from " + this.itsCacheStateFile);
            } else {
                Util_Logger.errorNoRaise(logger, "Error opening " + this.itsCacheStateFile + " as it is being used by another batcher instance. Configure property batcher_web_manager_cache to a unique filename");
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error loading cache state from file " + this.itsCacheStateFile + ": " + exception.getMessage(), exception);
            Util_Logger.warning(logger, "Detected invalid or missing cache file " + this.itsCacheStateFile + ", resetting state");
        }
        if (map == null) {
            map = new ConcurrentHashMap();
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveCacheToFile() {
        if (this.itsDirCache.size() > 0 && this.itsHasUpdates) {
            try {
                String string = null;
                Object object = this.itsDirCache;
                synchronized (object) {
                    string = JsonUtilities.toJson(this.itsDirCache);
                }
                object = pdrBatcherDataIOManager.getInstance().getProvider();
                fsFileInfo fsFileInfo2 = object.resolveCacheFilename(this.itsCacheStateFile);
                object.saveCacheFile(fsFileInfo2, string);
                this.itsLastPersisted = new Date();
                this.itsHasUpdates = false;
                Util_Logger.info(logger, "Persisted state to cache state file " + this.itsCacheStateFile);
            }
            catch (Exception exception) {
                Util_Logger.errorNoRaise(logger, "File cache manager save failed: " + exception.getMessage(), exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clearCache() {
        Map<String, fileDetailWeb> map = this.itsDirCache;
        synchronized (map) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : this.itsDirCache.keySet()) {
                if (string.indexOf(":BACKUP:") <= 0) continue;
                arrayList.add(string);
            }
            for (String string : arrayList) {
                Util_Logger.info(logger, "Clearing cache position for " + string);
                this.itsDirCache.remove(string);
            }
        }
    }

    private static class SingletonHolder {
        private static pdrFileWebManager instance = new pdrFileWebManager();

        private SingletonHolder() {
        }
    }

    @SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC"}, justification="Class cannot be static")
    private class fileDetailWeb {
        private List<String> filenames = new ArrayList<String>();
        private Date modifiedDate;

        private fileDetailWeb() {
        }

        public boolean isLater(String string, Date date) {
            if (date != null) {
                if (date.before(this.modifiedDate)) {
                    return false;
                }
                if (date.equals(this.modifiedDate)) {
                    return !this.filenames.contains(string);
                }
                return true;
            }
            boolean bl = true;
            for (String string2 : this.filenames) {
                bl = bl && string.compareTo(string2) > 0;
            }
            return bl;
        }

        public void updateCache(String string, Date date) {
            if (this.isLater(string, date)) {
                if (date != null) {
                    if (date.after(this.modifiedDate)) {
                        this.modifiedDate = date;
                        this.filenames.clear();
                    }
                } else {
                    this.filenames.clear();
                }
                this.filenames.add(string);
            }
        }
    }
}

