/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Translation;

import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.Files.FileNameTokenResolver;
import au.com.aemo.Common.Files.FileUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationBase;
import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationInt;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrFileTranslationFileRename
extends pdrFileTranslationBase
implements pdrFileTranslationInt {
    private static Logger logger = LoggerFactory.getLogger(pdrFileTranslationFileRename.class);
    private static final String PARAM_NAME = "name";
    private static final String PARAM_REPLACE = "replace";

    public pdrFileTranslationFileRename() {
        super("RENAME");
        super.registerParam("n", PARAM_NAME, true, "The new filename specification");
        super.registerParamList("r", PARAM_REPLACE, false, "The regex expression to search for and to replace with as a pair of parameters. Multiple criteria as additional pairs of parameters");
    }

    @Override
    public boolean acceptFile(fsFileInfo fsFileInfo2) {
        return true;
    }

    @Override
    public List<fsFileInfo> translateFile(fsFileInfo fsFileInfo2, String string, int n2) throws Exception {
        ArrayList<fsFileInfo> arrayList = new ArrayList<fsFileInfo>();
        String string2 = this.getParam(PARAM_NAME);
        String[] stringArray = this.getParamList(PARAM_REPLACE);
        if (Util.isBlank(string2)) {
            Util_Logger.warning(logger, "Missing parameter name in " + this.getId() + " translator, ignoring action");
            arrayList.add(fsFileInfo2);
        } else {
            fsFileInfo fsFileInfo3 = new fsFileInfo(fsFileInfo2);
            fsFileInfo3.setDirectory(string);
            String string3 = FileNameTokenResolver.process(string2, fsFileInfo2);
            if (stringArray != null) {
                for (int i2 = 0; i2 < stringArray.length; i2 += 2) {
                    string3 = string3.replaceAll(stringArray[i2], stringArray[i2 + 1]);
                }
            }
            FileUtilities.renameFile(fsFileInfo3.getDirectory() + "/" + fsFileInfo3.getFilename(), fsFileInfo3.getDirectory() + "/" + string3);
            fsFileInfo3.setFilename(string3);
            arrayList.add(fsFileInfo3);
        }
        return arrayList;
    }
}

