/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Translation;

import au.com.aemo.Common.FileSystem.fsEventData;
import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.Files.FileUtilities;
import au.com.aemo.Common.JSON.JsonOptions;
import au.com.aemo.Common.JSON.JsonUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationBase;
import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationInt;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrFileTranslationJSONSplit
extends pdrFileTranslationBase
implements pdrFileTranslationInt {
    private static Logger logger = LoggerFactory.getLogger(pdrFileTranslationJSONSplit.class);
    private static final String PARAM_PATH = "path";
    private static final String PARAM_VARIABLE = "variable";
    private Map<Integer, JsonObject> documentTree;
    private JsonObject splitRootObject;
    private String SplitJsonPath;
    private String SplitJsonAttribute;
    private int docLevel;
    private String VariableJsonPath;
    private String VariableValue;

    public pdrFileTranslationJSONSplit() {
        super("JSON_SPLIT");
        super.registerParam("p", PARAM_PATH, true, "The JSON path by which to split the input file");
        super.registerParam("v", PARAM_VARIABLE, false, "The JSON path for a variable to be made available to file rename");
    }

    @Override
    public boolean acceptFile(fsFileInfo fsFileInfo2) {
        return fsFileInfo2.getFilename().toUpperCase().endsWith(".JSON");
    }

    @Override
    public List<fsFileInfo> translateFile(fsFileInfo fsFileInfo2, String string, int n2) throws Exception {
        JsonReader jsonReader;
        ArrayList<fsFileInfo> arrayList = new ArrayList<fsFileInfo>();
        String string2 = this.getParam(PARAM_PATH);
        if (!string2.startsWith("$.")) {
            throw new Exception("Invalid JSON path specification for JSON_SPLIT transform");
        }
        this.SplitJsonAttribute = string2.substring(string2.lastIndexOf(".") + 1);
        this.SplitJsonPath = string2.substring(0, string2.lastIndexOf("."));
        this.VariableJsonPath = this.getParam(PARAM_VARIABLE);
        String string3 = string + "/" + fsFileInfo2.getFilename();
        this.docLevel = 0;
        this.documentTree = new HashMap<Integer, JsonObject>();
        this.documentTree.put(0, new JsonObject());
        Util_Logger.debug(logger, "JSON split performing first pass scan of  [" + fsFileInfo2.getFilename() + "] to build root object");
        try (InputStreamReader inputStreamReader = new InputStreamReader(new FileInputStream(string3));){
            jsonReader = new JsonReader((Reader)inputStreamReader);
            try {
                this.handleJsonObject("$", this.docLevel, jsonReader, fsFileInfo2, null);
            }
            finally {
                jsonReader.close();
            }
        }
        this.docLevel = 0;
        Util_Logger.debug(logger, "JSON split performing second pass scan of [" + fsFileInfo2.getFilename() + "] to perform split");
        inputStreamReader = new InputStreamReader(new FileInputStream(string3));
        try {
            jsonReader = new JsonReader((Reader)inputStreamReader);
            try {
                this.handleJsonObject("$", this.docLevel, jsonReader, fsFileInfo2, arrayList);
            }
            finally {
                jsonReader.close();
            }
        }
        finally {
            inputStreamReader.close();
        }
        if (arrayList.size() == 0) {
            throw new Exception("Unable to find JSON array split path [" + this.SplitJsonPath + "]");
        }
        FileUtilities.deleteFile(fsFileInfo2);
        return arrayList;
    }

    private void handleJsonObject(String string, int n2, JsonReader jsonReader, fsFileInfo fsFileInfo2, List<fsFileInfo> list) throws Exception {
        JsonObject jsonObject = this.documentTree.get(this.docLevel);
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            Object object;
            JsonToken jsonToken = jsonReader.peek();
            if (!jsonToken.equals((Object)JsonToken.NAME)) continue;
            String string2 = jsonReader.nextName();
            String string3 = string + "." + string2;
            jsonToken = jsonReader.peek();
            if (jsonToken.equals((Object)JsonToken.BEGIN_OBJECT)) {
                ++this.docLevel;
                if (list == null) {
                    object = new JsonObject();
                    this.documentTree.put(this.docLevel, (JsonObject)object);
                    jsonObject.add(string2, (JsonElement)object);
                }
                this.handleJsonObject(string3, 1, jsonReader, fsFileInfo2, list);
                continue;
            }
            if (jsonToken.equals((Object)JsonToken.BEGIN_ARRAY)) {
                this.handleJsonArray(string3, jsonReader, fsFileInfo2, list);
                continue;
            }
            if (!jsonToken.equals((Object)JsonToken.STRING) && !jsonToken.equals((Object)JsonToken.NUMBER) && !jsonToken.equals((Object)JsonToken.BOOLEAN) && !jsonToken.equals((Object)JsonToken.NULL)) continue;
            if (list == null) {
                object = null;
                switch (jsonToken) {
                    case STRING: {
                        object = jsonReader.nextString();
                        jsonObject.addProperty(string2, (String)object);
                        break;
                    }
                    case NUMBER: {
                        object = jsonReader.nextString();
                        jsonObject.addProperty(string2, (String)object);
                        break;
                    }
                    case BOOLEAN: {
                        boolean bl = jsonReader.nextBoolean();
                        object = Boolean.toString(bl);
                        jsonObject.addProperty(string2, Boolean.valueOf(bl));
                        break;
                    }
                    case NULL: {
                        jsonReader.nextNull();
                        break;
                    }
                    default: {
                        throw new Exception("Unhandled token[" + String.valueOf(jsonToken) + "] in JSON parser");
                    }
                }
                if (this.VariableJsonPath == null || !this.VariableJsonPath.equalsIgnoreCase(string3)) continue;
                try {
                    Date date = JsonUtilities.strToDate((String)object);
                    this.VariableValue = Util.dateToStr(date, "yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
                }
                catch (Exception exception) {
                    this.VariableValue = object;
                }
                continue;
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        --this.docLevel;
    }

    @SuppressFBWarnings(value={"DM_GC"}, justification="Garbage collection is called here to release very large amounts of memory caused by JSON parsing")
    private void handleJsonArray(String string, JsonReader jsonReader, fsFileInfo fsFileInfo2, List<fsFileInfo> list) throws Exception {
        jsonReader.beginArray();
        String string2 = string.substring(string.lastIndexOf(".") + 1);
        if (list == null && string.equalsIgnoreCase(this.SplitJsonPath)) {
            this.splitRootObject = this.documentTree.get(this.docLevel);
        }
        int n2 = 0;
        while (true) {
            JsonToken jsonToken;
            if (this.splitRootObject != null && list != null) {
                jsonToken = jsonReader.peek();
                if (jsonToken.equals((Object)JsonToken.END_ARRAY)) {
                    jsonReader.endArray();
                    break;
                }
                if (jsonToken.equals((Object)JsonToken.BEGIN_OBJECT)) {
                    JsonObject jsonObject = JsonUtilities.getJsonObjectFromStream(jsonReader);
                    JsonArray jsonArray = new JsonArray();
                    jsonArray.add((JsonElement)jsonObject);
                    this.splitRootObject.add(string2, (JsonElement)jsonArray);
                    String string3 = String.format("%05d", n2);
                    String string4 = fsFileInfo2.getDirectory() + "/" + fsFileInfo2.getName() + "_" + string3 + "." + fsFileInfo2.getExtension();
                    JsonUtilities.writeJsonObjectToFile(this.documentTree.get(0), string4, new JsonOptions());
                    File file = new File(string4);
                    fsFileInfo fsFileInfo3 = new fsFileInfo(file);
                    fsEventData fsEventData2 = fsFileInfo3.getEventData();
                    if (fsEventData2 == null) {
                        fsEventData2 = new fsEventData();
                        fsFileInfo3.setEventData(fsEventData2);
                    }
                    fsEventData2.addEventParameter("idx", string3);
                    fsFileInfo3.setEventData(fsEventData2);
                    list.add(fsFileInfo3);
                    JsonElement jsonElement = jsonObject.get(this.SplitJsonAttribute);
                    if (jsonElement != null && jsonElement.isJsonPrimitive()) {
                        String string5 = jsonElement.getAsString();
                        try {
                            Date date = JsonUtilities.strToDate(string5);
                            fsEventData2.addEventParameter(this.SplitJsonAttribute, Util.dateToStr(date, "yyyy-MM-dd'T'HH:mm:ss.SSSXXX"));
                        }
                        catch (Exception exception) {
                            fsEventData2.addEventParameter(this.SplitJsonAttribute, string5);
                        }
                    }
                    if (this.VariableValue != null) {
                        fsEventData2.addEventParameter(this.VariableJsonPath.substring(this.VariableJsonPath.lastIndexOf(".") + 1), this.VariableValue);
                    }
                    this.splitRootObject.remove(string2);
                    jsonObject = null;
                    jsonArray = null;
                    System.gc();
                } else {
                    jsonReader.skipValue();
                }
            } else {
                jsonToken = jsonReader.peek();
                if (jsonToken.equals((Object)JsonToken.END_ARRAY)) {
                    jsonReader.endArray();
                    break;
                }
                jsonReader.skipValue();
            }
            ++n2;
        }
    }
}

