/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Translation;

import au.com.aemo.Common.FileSystem.fsEventData;
import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.Files.FileUtilities;
import au.com.aemo.Common.JSON.JsonOptions;
import au.com.aemo.Common.JSON.JsonTransformManager;
import au.com.aemo.Common.JSON.JsonUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationBase;
import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationInt;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrFileTranslationJSONTransform
extends pdrFileTranslationBase
implements pdrFileTranslationInt {
    private static Logger logger = LoggerFactory.getLogger(pdrFileTranslationJSONTransform.class);
    private static final String PARAM_ID = "identifier";
    private static final String PARAM_PRETTY = "pretty";
    private static final String PARAM_VARIABLE = "variable";

    public pdrFileTranslationJSONTransform() {
        super("JSON_TRANSFORM");
        super.registerParam("id", PARAM_ID, true, "The transform Id from the JSON transform XML file");
        super.registerOption("p", PARAM_PRETTY, "Set this flag to enable pretty print");
        super.registerParam("v", PARAM_VARIABLE, false, "The JSON path for a variable to be made available to file rename");
    }

    @Override
    public boolean acceptFile(fsFileInfo fsFileInfo2) {
        return fsFileInfo2.getFilename().toUpperCase().endsWith(".JSON");
    }

    @Override
    public List<fsFileInfo> translateFile(fsFileInfo fsFileInfo2, String string, int n2) throws Exception {
        Object object;
        JsonObject jsonObject;
        ArrayList<fsFileInfo> arrayList = new ArrayList<fsFileInfo>();
        String string2 = this.getParam(PARAM_ID);
        boolean bl = this.hasParam(PARAM_PRETTY);
        String string3 = this.getParam(PARAM_VARIABLE);
        if (!Util.isBlank(string3) && !string3.startsWith("$.")) {
            throw new Exception("Invalid JSON path specification [" + string3 + "] in JSON_TRANSFORM transform");
        }
        JsonOptions jsonOptions = new JsonOptions();
        jsonOptions.setPrettyPrint(bl);
        String string4 = string + "/" + fsFileInfo2.getFilename();
        String string5 = string + "/" + fsFileInfo2.getFilename() + ".tmp";
        JsonObject jsonObject2 = null;
        try {
            jsonObject2 = JsonUtilities.getJsonObjectFromFile(string4);
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error parsing JSON file [" + fsFileInfo2.getFilename() + "]: " + exception.getMessage(), exception);
        }
        JsonObject jsonObject3 = null;
        JsonTransformManager jsonTransformManager = JsonTransformManager.getInstance();
        try {
            jsonObject3 = jsonTransformManager.getTransform(this.getDataSourceId(), string2);
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error loading JSON transform specification from config [" + jsonTransformManager.getConfigFile() + "]: " + exception.getMessage(), exception);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("filename", fsFileInfo2.getFilename());
        hashMap.put("name", fsFileInfo2.getName());
        String string6 = null;
        Object object2 = null;
        if (string3 != null) {
            string6 = string3.substring(string3.lastIndexOf(".") + 1);
            jsonObject = null;
            try {
                jsonObject = (JsonElement)JsonPath.read((Object)jsonObject2, (String)string3, (Predicate[])new Predicate[0]);
            }
            catch (Exception exception) {
                Util_Logger.error(logger, "Unable to find JSON path [" + string3 + "] in source file [" + fsFileInfo2.getFilename() + "]");
            }
            object = jsonObject.getAsString();
            try {
                Date date = JsonUtilities.strToDate((String)object);
                object2 = Util.dateToStr(date, "yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
            }
            catch (Exception exception) {
                object2 = object;
            }
        }
        jsonObject = null;
        try {
            object = new JsonUtilities();
            jsonObject = ((JsonUtilities)object).transformJson(jsonObject2, jsonObject3, hashMap);
            jsonObject2 = null;
            object = null;
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error transforming JSON file [" + fsFileInfo2.getFilename() + "]: " + exception.getMessage(), exception);
        }
        try {
            JsonUtilities.writeJsonObjectToFile(jsonObject, string5, new JsonOptions());
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error writing JSON file [" + fsFileInfo2.getFilename() + "]: " + exception.getMessage(), exception);
        }
        FileUtilities.deleteFile(fsFileInfo2);
        FileUtilities.renameFile(string5, string4);
        fsFileInfo2.setSize(new File(string4).length());
        if (object2 != null) {
            object = fsFileInfo2.getEventData();
            if (object == null) {
                object = new fsEventData();
                fsFileInfo2.setEventData((fsEventData)object);
            }
            ((fsEventData)object).addEventParameter(string6, (String)object2);
        }
        arrayList.add(fsFileInfo2);
        return arrayList;
    }
}

