/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Translation;

import au.com.aemo.Common.CSV.Csv;
import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.Files.FileUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationBase;
import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationInt;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrFileTranslationNEMCSVtoXML
extends pdrFileTranslationBase
implements pdrFileTranslationInt {
    private static Logger logger = LoggerFactory.getLogger(pdrFileTranslationNEMCSVtoXML.class);
    private static final String XML_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSX";
    private static final String NEMREPORTS_DATE_FORMAT = "yyyy/MM/dd HH:mm:ss.SSS";
    private final Csv csvParser = new Csv();

    public pdrFileTranslationNEMCSVtoXML() {
        super("NEMCSV_TO_XML");
    }

    @Override
    public boolean acceptFile(fsFileInfo fsFileInfo2) {
        return fsFileInfo2.getFilename().toUpperCase().endsWith(".CSV");
    }

    @Override
    public List<fsFileInfo> translateFile(fsFileInfo fsFileInfo2, String string, int n2) throws Exception {
        ArrayList<fsFileInfo> arrayList = new ArrayList<fsFileInfo>();
        String string2 = string + "/" + fsFileInfo2.getFilename();
        String string3 = string + "/" + fsFileInfo2.getFilename() + ".tmp";
        String string4 = fsFileInfo2.getName() + ".xml";
        String string5 = string + "/" + string4;
        long l2 = 0L;
        String string6 = "";
        String[] stringArray = null;
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(Paths.get(string3, new String[0]), new OpenOption[0]);){
            Object object;
            try {
                object = new BufferedReader(new FileReader(string2));
                try {
                    while ((string6 = ((BufferedReader)object).readLine()) != null) {
                        Object object2;
                        String string7;
                        String[] stringArray2 = this.csvParser.parse(string6);
                        if (++l2 == 1L) {
                            String string8 = stringArray2[1];
                            string7 = stringArray2[2];
                            object2 = stringArray2[3];
                            String string9 = stringArray2[4];
                            String string10 = stringArray2[5];
                            String string11 = stringArray2[6];
                            String string12 = stringArray2[7];
                            String string13 = stringArray2[8];
                            String string14 = stringArray2[9];
                            String string15 = string12 + "-" + string7 + "-" + string9;
                            Date date = Util.strToDate(string10 + " " + string11, NEMREPORTS_DATE_FORMAT);
                            String string16 = Util.dateToStr(date, XML_DATE_FORMAT);
                            bufferedWriter.write("<XmlReport");
                            bufferedWriter.write(" transactionId=\"" + string15 + "\"");
                            bufferedWriter.write(" source=\"" + string8 + "\"");
                            bufferedWriter.write(" file_id=\"" + string7 + "\"");
                            bufferedWriter.write(" from=\"" + (String)object2 + "\"");
                            bufferedWriter.write(" to=\"" + string9 + "\"");
                            bufferedWriter.write(" creation_date=\"" + string16 + "\"");
                            bufferedWriter.write(" event_queue_id=\"" + string12 + "\"");
                            bufferedWriter.write(" data_model_file_id=\"" + Util.noNull(string13) + "\"");
                            bufferedWriter.write(" event_group_id=\"" + string14 + "\"");
                            bufferedWriter.write(">");
                            bufferedWriter.write("<Reports>");
                            continue;
                        }
                        if (stringArray2[0].equalsIgnoreCase("I")) {
                            if (stringArray != null) {
                                bufferedWriter.write("</Rows>");
                                bufferedWriter.write("</Report>");
                            }
                            stringArray = stringArray2;
                            bufferedWriter.write("<Report ");
                            bufferedWriter.write(" id=\"" + stringArray[1] + "_" + stringArray[2] + "\"");
                            bufferedWriter.write(" version=\"" + stringArray[3] + "\"");
                            bufferedWriter.write(">");
                            bufferedWriter.write("<Rows>");
                            continue;
                        }
                        if (!stringArray2[0].equalsIgnoreCase("D")) continue;
                        bufferedWriter.write("<Row ");
                        for (int i2 = 4; i2 < stringArray.length; ++i2) {
                            string7 = null;
                            if (stringArray2.length >= i2 + 1 && !Util.isBlank(stringArray2[i2]) && (string7 = stringArray2[i2]).indexOf("/") > 0) {
                                object2 = null;
                                try {
                                    object2 = Util.strToDate(string7, NEMREPORTS_DATE_FORMAT);
                                    string7 = Util.dateToStr((Date)object2, XML_DATE_FORMAT);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (Util.isBlank(string7)) continue;
                            bufferedWriter.write(" ");
                            bufferedWriter.write(stringArray[i2]);
                            bufferedWriter.write("=\"");
                            bufferedWriter.write(string7);
                            bufferedWriter.write("\"");
                        }
                        bufferedWriter.write(" />");
                    }
                    ((BufferedReader)object).close();
                    if (stringArray != null) {
                        bufferedWriter.write("</Rows>");
                        bufferedWriter.write("</Report>");
                    }
                    bufferedWriter.write("</Reports>");
                    bufferedWriter.write("</XmlReport>");
                    bufferedWriter.flush();
                    bufferedWriter.close();
                }
                finally {
                    ((BufferedReader)object).close();
                }
            }
            catch (Exception exception) {
                Util_Logger.error(logger, "Error processing NEMCSV to XML translation: " + exception.getMessage(), exception);
            }
            FileUtilities.renameFile(string3, string5);
            FileUtilities.deleteFile(fsFileInfo2);
            object = new fsFileInfo(fsFileInfo2);
            ((fsFileInfo)object).setDirectory(string);
            ((fsFileInfo)object).setFilename(string4);
            ((fsFileInfo)object).setSize(new File(string5).length());
            arrayList.add((fsFileInfo)object);
        }
        return arrayList;
    }
}

