/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Translation;

import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.Files.FileUtilities;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationBase;
import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationInt;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrFileTranslationOSCommand
extends pdrFileTranslationBase
implements pdrFileTranslationInt {
    private static Logger logger = LoggerFactory.getLogger(pdrFileTranslationOSCommand.class);
    private static final String PARAM_COMMAND = "command";

    public pdrFileTranslationOSCommand() {
        super("OS");
        super.registerParam("l", PARAM_COMMAND, true, "Operating system command to execute");
    }

    @Override
    public boolean acceptFile(fsFileInfo fsFileInfo2) {
        return true;
    }

    @Override
    public List<fsFileInfo> translateFile(fsFileInfo fsFileInfo2, String string, int n2) throws Exception {
        ArrayList<fsFileInfo> arrayList = new ArrayList<fsFileInfo>();
        String string2 = this.getParam(PARAM_COMMAND);
        if (string2 == null) {
            Util_Logger.warning(logger, "Missing parameter command in " + this.getId() + " translator, ignoring action");
            arrayList.add(fsFileInfo2);
        } else {
            Object object;
            boolean bl = System.getProperty("os.name").toLowerCase().startsWith("windows");
            if (logger.isDebugEnabled()) {
                Util_Logger.debug(logger, "Command: " + string2.toString());
            }
            ArrayList<String> arrayList2 = new ArrayList<String>();
            if (bl) {
                arrayList2.add("cmd");
                arrayList2.add("/c");
            } else {
                arrayList2.add("/bin/bash");
                arrayList2.add("-c");
            }
            arrayList2.add(string2);
            String string3 = string + "/" + fsFileInfo2.getFilename();
            String string4 = string + "/" + fsFileInfo2.getFilename() + ".tmp";
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            processBuilder.redirectInput(new File(string3));
            processBuilder.redirectOutput(new File(string4));
            processBuilder.command(arrayList2);
            Process process = processBuilder.start();
            process.waitFor();
            if (process.exitValue() != 0) {
                try {
                    FileUtilities.deleteFile(string4);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                object = new StringBuilder();
                Scanner scanner = new Scanner(process.getErrorStream());
                while (scanner.hasNextLine()) {
                    String string5 = scanner.nextLine();
                    if (((StringBuilder)object).length() > 0) {
                        ((StringBuilder)object).append("\r\n");
                    }
                    ((StringBuilder)object).append(string5);
                }
                Util_Logger.error(logger, "Error processing OS command translation: " + ((StringBuilder)object).toString());
            }
            FileUtilities.renameFile(string4, string3);
            object = new fsFileInfo(fsFileInfo2);
            ((fsFileInfo)object).setDirectory(string);
            ((fsFileInfo)object).setSize(new File(string3).length());
            arrayList.add((fsFileInfo)object);
        }
        return arrayList;
    }
}

