/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Translation;

import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.Files.FileUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationBase;
import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationInt;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrFileTranslationStringReplace
extends pdrFileTranslationBase
implements pdrFileTranslationInt {
    private static Logger logger = LoggerFactory.getLogger(pdrFileTranslationStringReplace.class);
    private static final String PARAM_FIND = "find";
    private static final String PARAM_REPLACE = "replace";
    private static final String PARAM_FROM_LINE = "from_line";
    private static final String PARAM_TO_LINE = "to_line";
    private static final String PARAM_CASE_SENSITIVE = "case_sensitive";

    public pdrFileTranslationStringReplace() {
        super("REPLACE");
        super.registerParam("f", PARAM_FIND, true, "The text to find, can be a regular expression");
        super.registerParam("r", PARAM_REPLACE, true, "The text to substitute");
        super.registerParam("fl", PARAM_FROM_LINE, false, "Only replace text occuring on or after this line in the file. If omitted assumes start of file");
        super.registerParam("t", PARAM_TO_LINE, false, "Only replace text occuring on or before this line in the file. If omitted assumes end of file");
        super.registerParam("cs", PARAM_CASE_SENSITIVE, false, "Whether the text search should be case sensitive. Default is N");
    }

    @Override
    public boolean acceptFile(fsFileInfo fsFileInfo2) {
        return this.isTextFile(fsFileInfo2);
    }

    @Override
    public List<fsFileInfo> translateFile(fsFileInfo fsFileInfo2, String string, int n2) throws Exception {
        Long l2;
        ArrayList<fsFileInfo> arrayList = new ArrayList<fsFileInfo>();
        boolean bl = Util.isBlank(this.getParam(PARAM_CASE_SENSITIVE), "N").equalsIgnoreCase("N");
        String string2 = (bl ? "(?i)" : "") + this.getParam(PARAM_FIND);
        String string3 = this.getParam(PARAM_REPLACE);
        String string4 = this.getParam(PARAM_FROM_LINE);
        Long l3 = Util.isBlank(string4) ? null : Long.valueOf(string4);
        String string5 = this.getParam(PARAM_TO_LINE);
        Long l4 = l2 = Util.isBlank(string5) ? null : Long.valueOf(string5);
        if (Util.isBlank(string2) || Util.isBlank(string3)) {
            Util_Logger.warning(logger, "Missing parameters find and replace in " + this.getId() + " translator, ignoring action");
            arrayList.add(fsFileInfo2);
        } else {
            String string6 = string + "/" + fsFileInfo2.getFilename();
            String string7 = string + "/" + fsFileInfo2.getFilename() + ".tmp";
            long l5 = 0L;
            String string8 = "";
            try (Object object = Files.newBufferedWriter(Paths.get(string7, new String[0]), new OpenOption[0]);){
                try (BufferedReader bufferedReader = new BufferedReader(new FileReader(string6));){
                    while ((string8 = bufferedReader.readLine()) != null) {
                        boolean bl2 = true;
                        if (l3 != null && ++l5 < l3) {
                            bl2 = false;
                        }
                        if (l2 != null && l5 > l2) {
                            bl2 = false;
                        }
                        String string9 = string8;
                        if (bl2) {
                            string9 = string8.replaceAll(string2, string3);
                        }
                        if (l5 > 1L) {
                            ((BufferedWriter)object).newLine();
                        }
                        ((Writer)object).write(string9);
                    }
                    bufferedReader.close();
                    ((BufferedWriter)object).flush();
                    ((BufferedWriter)object).close();
                }
                catch (Exception exception) {
                    Util_Logger.error(logger, "Error processing string replace translation: " + exception.getMessage(), exception);
                }
            }
            if (fsFileInfo2.getModifiedDate() != null) {
                object = new File(string7);
                ((File)object).setLastModified(fsFileInfo2.getModifiedDate().getTime());
            }
            FileUtilities.renameFile(string7, string6);
            object = new fsFileInfo(fsFileInfo2);
            ((fsFileInfo)object).setDirectory(string);
            ((fsFileInfo)object).setSize(new File(string6).length());
            arrayList.add((fsFileInfo)object);
        }
        return arrayList;
    }
}

