/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Translation;

import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.Files.FileUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationBase;
import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationInt;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrFileTranslationTail
extends pdrFileTranslationBase
implements pdrFileTranslationInt {
    private static Logger logger = LoggerFactory.getLogger(pdrFileTranslationTail.class);
    private static final String PARAM_LINE = "line";

    public pdrFileTranslationTail() {
        super("TAIL");
        super.registerParam("l", PARAM_LINE, true, "Line number of the source file");
    }

    @Override
    public boolean acceptFile(fsFileInfo fsFileInfo2) {
        return this.isTextFile(fsFileInfo2);
    }

    @Override
    public List<fsFileInfo> translateFile(fsFileInfo fsFileInfo2, String string, int n2) throws Exception {
        ArrayList<fsFileInfo> arrayList = new ArrayList<fsFileInfo>();
        Long l2 = null;
        String string2 = this.getParam(PARAM_LINE);
        try {
            l2 = Util.isBlank(string2) ? null : Long.valueOf(string2);
        }
        catch (Exception exception) {
            Util_Logger.warning(logger, "Invalid line parameter (" + string2 + ") in " + this.getId() + " translator");
        }
        if (l2 == null) {
            Util_Logger.warning(logger, "Missing parameter line in " + this.getId() + " translator, ignoring action");
            arrayList.add(fsFileInfo2);
        } else {
            long l3;
            Object object;
            String string3 = string + "/" + fsFileInfo2.getFilename();
            String string4 = string + "/" + fsFileInfo2.getFilename() + ".tmp";
            if (l2.intValue() < 0) {
                object = Files.lines(Paths.get(string3, new String[0]), StandardCharsets.UTF_8);
                try {
                    l3 = object.count();
                }
                finally {
                    if (object != null) {
                        object.close();
                    }
                }
                l2 = l3 + l2 + 1L;
            }
            l3 = 0L;
            object = "";
            try (Object object2 = Files.newBufferedWriter(Paths.get(string4, new String[0]), new OpenOption[0]);){
                try (BufferedReader bufferedReader = new BufferedReader(new FileReader(string3));){
                    while ((object = bufferedReader.readLine()) != null) {
                        if (++l3 > l2) {
                            ((BufferedWriter)object2).newLine();
                        }
                        if (l3 < l2) continue;
                        ((Writer)object2).write((String)object);
                    }
                    bufferedReader.close();
                    ((BufferedWriter)object2).flush();
                    ((BufferedWriter)object2).close();
                }
                catch (Exception exception) {
                    Util_Logger.error(logger, "Error processing tail translation: " + exception.getMessage(), exception);
                }
            }
            if (fsFileInfo2.getModifiedDate() != null) {
                object2 = new File(string4);
                ((File)object2).setLastModified(fsFileInfo2.getModifiedDate().getTime());
            }
            FileUtilities.renameFile(string4, string3);
            object2 = new fsFileInfo(fsFileInfo2);
            ((fsFileInfo)object2).setDirectory(string);
            ((fsFileInfo)object2).setSize(new File(string3).length());
            arrayList.add((fsFileInfo)object2);
        }
        return arrayList;
    }
}

