/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Translation;

import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.Files.FileUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationBase;
import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationInt;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class pdrFileTranslationXSLT
extends pdrFileTranslationBase
implements pdrFileTranslationInt {
    private static Logger logger = LoggerFactory.getLogger(pdrFileTranslationXSLT.class);
    private static final String PARAM_TRANSFORM = "transform";
    private static final String PARAM_EXTENSION = "extension";

    public pdrFileTranslationXSLT() {
        super("XSLT");
        super.registerParam("t", PARAM_TRANSFORM, true, "The XSLT transform filename");
        super.registerParam("e", PARAM_EXTENSION, false, "The extension to apply to the output filename");
    }

    @Override
    public boolean acceptFile(fsFileInfo fsFileInfo2) {
        return fsFileInfo2.getFilename().toUpperCase().endsWith(".XML");
    }

    @Override
    public List<fsFileInfo> translateFile(fsFileInfo fsFileInfo2, String string, int n2) throws Exception {
        Object object;
        Object object2;
        Object object3;
        ArrayList<fsFileInfo> arrayList = new ArrayList<fsFileInfo>();
        String string2 = this.getParam(PARAM_TRANSFORM);
        String string3 = this.getParam(PARAM_EXTENSION);
        String string4 = string + "/" + fsFileInfo2.getFilename();
        String string5 = string + "/" + fsFileInfo2.getFilename() + ".tmp";
        try {
            object3 = Files.newBufferedWriter(Paths.get(string5, new String[0]), new OpenOption[0]);
            try {
                object2 = TransformerFactory.newInstance().newTransformer(new StreamSource(string2));
                object = SAXParserFactory.newInstance();
                SAXParser sAXParser = ((SAXParserFactory)object).newSAXParser();
                XMLReader xMLReader = sAXParser.getXMLReader();
                SAXSource sAXSource = new SAXSource(xMLReader, new InputSource(string4));
                ((Transformer)object2).transform(sAXSource, new StreamResult((Writer)object3));
                ((BufferedWriter)object3).flush();
                ((BufferedWriter)object3).close();
            }
            finally {
                if (object3 != null) {
                    ((BufferedWriter)object3).close();
                }
            }
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error processing XSLT translation: " + exception.getMessage(), exception);
        }
        object3 = null;
        object2 = null;
        if (Util.isBlank(string3)) {
            object3 = fsFileInfo2.getFilename();
            object2 = string4;
            FileUtilities.renameFile(string5, string4);
        } else {
            object3 = fsFileInfo2.getName() + "." + string3;
            object2 = string + "/" + (String)object3;
            FileUtilities.renameFile(string5, (String)object2);
            FileUtilities.deleteFile(fsFileInfo2);
        }
        object = new fsFileInfo(fsFileInfo2);
        ((fsFileInfo)object).setDirectory(string);
        ((fsFileInfo)object).setFilename((String)object3);
        ((fsFileInfo)object).setSize(new File((String)object2).length());
        arrayList.add((fsFileInfo)object);
        return arrayList;
    }
}

