/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher;

import au.com.aemo.Common.Application.ApplicationInt;
import au.com.aemo.Common.Application.InstanceLockManager;
import au.com.aemo.Common.FileSystem.FilesystemManager;
import au.com.aemo.Common.FileSystem.fsEventListenerInt;
import au.com.aemo.Common.FileSystem.fsInactivityEventListenerInt;
import au.com.aemo.Common.FileSystem.fsPurgeThread;
import au.com.aemo.Common.Files.FileMaskSpecification;
import au.com.aemo.Common.Files.FileUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.Scheduler.JobSchedulerManager;
import au.com.aemo.Common.Threading.threadMonitor;
import au.com.aemo.Common.Threading.threadMonitorCheckInt;
import au.com.aemo.Common.Threading.threadMonitorStatusItem;
import au.com.aemo.Common.Web.WebServer;
import au.com.nemmco.Pdr.Batcher.IO.pdrBatcherDataIOManager;
import au.com.nemmco.Pdr.Batcher.Processor.pdrBatcherHandlerConfig;
import au.com.nemmco.Pdr.Batcher.Processor.pdrBatcherHandlerConfigTranslator;
import au.com.nemmco.Pdr.Batcher.Processor.pdrBatcherHandlerFactory;
import au.com.nemmco.Pdr.Batcher.Processor.pdrBatcherHandlerInt;
import au.com.nemmco.Pdr.Batcher.Processor.pdrBatcherHandlerJob;
import au.com.nemmco.Pdr.Batcher.Processor.pdrBatcherHandlerManager;
import au.com.nemmco.Pdr.Batcher.Processor.pdrFileCacheManager;
import au.com.nemmco.Pdr.Batcher.Processor.pdrFileWebManager;
import au.com.nemmco.Pdr.Batcher.Translation.pdrFileTranslationUtil;
import au.com.nemmco.Pdr.Batcher.pdrFileEventInt;
import au.com.nemmco.Pdr.Common.Monitor.pdrMonitorManager;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class pdrBatcher
implements threadMonitorCheckInt,
ApplicationInt,
fsInactivityEventListenerInt {
    private static Logger logger = LoggerFactory.getLogger(pdrBatcher.class);
    public static final String PROPERTIES_FILE = System.getProperty("config", "pdrBatcher.properties");
    public static final String APP_NAME = "pdrBatcher";
    public static final String VERSION = "7.6.1";
    public static final String CONFIG_PREFIX = "batcher";
    public static final String THREAD_MODE_CONSUMER = "CONSUMER";
    public static final String THREAD_MODE_CONSUMER_RO = "CONSUMER_RO";
    public static final String THREAD_MODE_CONSUMER_CACHE = "CONSUMER_CACHE";
    public static final String THREAD_MODE_SYNCHRONISE = "SYNCHRONISE";
    public static final String THREAD_MODE_PURGE = "PURGE";
    public static final String THREAD_MODE_ASEXML_SEND_FTP = "ASEXML_SEND_FTP";
    public static final String THREAD_MODE_ASEXML_RECEIVE_FTP = "ASEXML_RECEIVE_FTP";
    public static final String THREAD_MODE_ASEXML_SEND_API = "ASEXML_SEND_API";
    public static final String THREAD_MODE_ASEXML_RECEIVE_API = "ASEXML_RECEIVE_API";
    public static final String THREAD_DELIVERY_PRIMARY = "PRIMARY";
    public static final String THREAD_DELIVERY_BACKUP = "BACKUP";
    public static final String SCHEDULE_MODE_POLL = "POLL";
    public static final String SCHEDULE_MODE_CRON = "CRON";
    public static final String SCHEDULE_MODE_API = "API";
    public static final String SCHEDULE_MODE_EVENT = "EVENT";
    public static final String JOB_TYPE_UPLOAD = "UPLOAD";
    public static final String JOB_TYPE_DOWNLOAD = "DOWNLOAD";
    private boolean itsIsReady = false;
    private volatile Date itsLastBusyTime;
    private int itsInactivityTimeoutSecs;
    private String itsHeartbeatFile;
    private Properties itsConfiguration;

    /*
     * WARNING - void declaration
     */
    public pdrBatcher() throws Exception {
        void var13_26;
        Object object;
        int n2;
        Object object3;
        Object object4;
        Properties properties;
        this.itsConfiguration = properties = Util.getPropertiesObject(PROPERTIES_FILE);
        boolean bl = Util.getProperty(properties, "batcher_single_instance", "true").equalsIgnoreCase("true");
        if (bl && !((InstanceLockManager)(object4 = InstanceLockManager.getInstance())).setLock((String)(object3 = Util.getProperty(properties, "batcher_holding_dir") + "/pdrBatcher.lock"))) {
            Util_Logger.error(logger, "Unable to start PDR batcher, another instance is already running, lock file: " + (String)object3);
        }
        object4 = pdrBatcherDataIOManager.getInstance();
        ((pdrBatcherDataIOManager)object4).configure(properties);
        object3 = pdrBatcherHandlerManager.getInstance();
        pdrMonitorManager pdrMonitorManager2 = pdrMonitorManager.getInstance();
        pdrMonitorManager2.init(properties);
        pdrMonitorManager2.setAppDetails(this);
        this.clearHoldingDirectory();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        String string = Util.getProperty(properties, "batcher_threads_active", null);
        if (Util.isBlank(string)) {
            int n3 = Integer.parseInt(Util.getProperty(properties, "batcher_threads", "1"));
            for (n2 = 1; n2 <= n3; ++n2) {
                arrayList.add(n2);
            }
        } else {
            String[] stringArray;
            for (String object22 : stringArray = Util.getColumns(string, ',')) {
                if (Util.isInteger(object22)) {
                    arrayList.add(Integer.parseInt(object22));
                    continue;
                }
                Util_Logger.warning(logger, "Ignoring invalid batcher thread '" + object22 + "', use integer");
            }
        }
        ArrayList<pdrBatcherHandlerInt> arrayList2 = new ArrayList<pdrBatcherHandlerInt>();
        n2 = 1;
        Object object5 = arrayList.iterator();
        while (object5.hasNext()) {
            int n4 = (Integer)object5.next();
            try {
                pdrBatcherHandlerInt pdrBatcherHandlerInt2 = this.createThread(n4);
                if (pdrBatcherHandlerInt2 == null) continue;
                arrayList2.add(pdrBatcherHandlerInt2);
            }
            catch (Exception exception) {
                Util_Logger.errorNoRaise(logger, "Error creating thread " + n4 + ": " + exception.getMessage(), exception);
                n2 = 0;
            }
        }
        if (n2 == 0) {
            Util_Logger.error(logger, "Detected error configuring pdrBatcher, aborting startup");
        }
        object5 = threadMonitor.getInstance();
        JobSchedulerManager jobSchedulerManager = JobSchedulerManager.getInstance();
        for (pdrBatcherHandlerInt pdrBatcherHandlerInt3 : arrayList2) {
            ((pdrBatcherHandlerManager)object3).registerHandler(pdrBatcherHandlerInt3);
            String string2 = pdrBatcherHandlerInt3.getOperation() + "_" + pdrBatcherHandlerInt3.getId();
            if (Util.isBlank(pdrBatcherHandlerInt3.getSchedulingMode())) {
                Util_Logger.error(logger, "Error starting thread " + pdrBatcherHandlerInt3.getId() + ", scheduling mode is undefined");
            } else if (pdrBatcherHandlerInt3.getSchedulingMode().equalsIgnoreCase(SCHEDULE_MODE_POLL)) {
                ((threadMonitor)object5).addThreadManaged(pdrBatcherHandlerInt3, string2, true);
            } else if (pdrBatcherHandlerInt3.getSchedulingMode().equalsIgnoreCase(SCHEDULE_MODE_CRON)) {
                if (Util.isBlank(pdrBatcherHandlerInt3.getCronJobSchedule())) {
                    Util_Logger.error(logger, "Error starting thread " + pdrBatcherHandlerInt3.getId() + " in CRON mode, CRON expression is not defined");
                }
                object = "pdrBatcherThread";
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("ID", Integer.toString(pdrBatcherHandlerInt3.getId()));
                jobSchedulerManager.scheduleJob((String)object, string2, pdrBatcherHandlerInt3.getCronJobSchedule(), new pdrBatcherHandlerJob(), hashMap);
            } else if (!pdrBatcherHandlerInt3.getSchedulingMode().equalsIgnoreCase(SCHEDULE_MODE_API)) {
                if (pdrBatcherHandlerInt3.getSchedulingMode().equalsIgnoreCase(SCHEDULE_MODE_EVENT)) {
                    ((threadMonitor)object5).addThreadManaged(pdrBatcherHandlerInt3, string2, true);
                } else {
                    Util_Logger.error(logger, "Error starting thread " + pdrBatcherHandlerInt3.getId() + ", unrecognised scheduling mode: " + pdrBatcherHandlerInt3.getSchedulingMode());
                }
            }
            Thread.sleep(1000L);
        }
        Util_Logger.info(logger, "Started " + arrayList.size() + " batcher threads");
        jobSchedulerManager.start();
        this.itsLastBusyTime = new Date();
        String string3 = Util.getProperty(properties, "batcher_inactivity_timeout", "");
        boolean bl2 = false;
        int n3 = 0;
        for (pdrBatcherHandlerInt pdrBatcherHandlerInt4 : pdrBatcherHandlerManager.getInstance().getHandlers()) {
            if (pdrBatcherHandlerInt4.getActivityMonitor()) {
                ++var13_26;
            }
            if (!pdrBatcherHandlerInt4.getDelivery().equalsIgnoreCase(THREAD_DELIVERY_BACKUP)) continue;
            ++n3;
        }
        this.itsInactivityTimeoutSecs = -1;
        if (!Util.isBlank(string3)) {
            if (var13_26 > 0) {
                this.itsInactivityTimeoutSecs = Integer.parseInt(string3);
            } else {
                Util_Logger.warning(logger, "Inactivity monitor is disabled, please enable at least 1 batcher thread for inactivity monitoring");
            }
        } else if (var13_26 > 0) {
            Util_Logger.warning(logger, "Inactivity monitor is disabled, please specify batcher_inactivity_timeout parameter");
        }
        ((threadMonitor)object5).addCheck(this);
        try {
            object = new fsPurgeThread(properties);
            if (((fsPurgeThread)object).getHasConfiguration()) {
                ((threadMonitor)object5).addThreadManaged((Runnable)object, "filesystem_purge", true);
            }
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error creating filesystem purge thread: " + exception.getMessage(), exception);
        }
        object = WebServer.getInstance();
        if (((WebServer)object).getIsEnabled()) {
            ((WebServer)object).addHandlersFromPackage("au.com.nemmco.Pdr.Batcher.API");
        }
        FilesystemManager.getInstance().registerInactvityListener(this);
        FilesystemManager.getInstance().startEventNotificationProviders();
        this.itsIsReady = true;
    }

    public boolean getIsReady() {
        return this.itsIsReady;
    }

    @Override
    public boolean getCheckIsAvailable() {
        return this.itsInactivityTimeoutSecs > 0;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Only accessed via trusted code")
    public Date getCheckTimestamp() {
        return this.itsLastBusyTime;
    }

    @Override
    public int getCheckBusinessCycleSeconds() {
        return this.itsInactivityTimeoutSecs;
    }

    @Override
    public String getCheckDescription() {
        return APP_NAME;
    }

    @Override
    public boolean getCheckIsFatal() {
        return true;
    }

    @Override
    public void resetThread() {
    }

    @Override
    public threadMonitorStatusItem getStatusReport() {
        threadMonitorStatusItem threadMonitorStatusItem2 = new threadMonitorStatusItem("Threads");
        for (pdrBatcherHandlerInt pdrBatcherHandlerInt2 : pdrBatcherHandlerManager.getInstance().getHandlers()) {
            threadMonitorStatusItem2.addItem(pdrBatcherHandlerInt2.getStatusReport());
        }
        return threadMonitorStatusItem2;
    }

    @Override
    public void activateBackupDataSource(String string) {
        boolean bl = false;
        for (pdrBatcherHandlerInt pdrBatcherHandlerInt2 : pdrBatcherHandlerManager.getInstance().getHandlers()) {
            if (!pdrBatcherHandlerInt2.getConfig().DataSource.equalsIgnoreCase(string) || !pdrBatcherHandlerInt2.getDelivery().equalsIgnoreCase(THREAD_DELIVERY_BACKUP)) continue;
            Util_Logger.info(logger, "Enabling BACKUP delivery thread " + pdrBatcherHandlerInt2.getId() + " after inactivity timeout on PRIMARY delivery threads");
            if (!bl) {
                pdrBatcherHandlerInt2.clearDataState();
                bl = true;
            }
            pdrBatcherHandlerInt2.setIsActive(true);
        }
    }

    @Override
    public void deactivateBackupDataSource(String string) {
        for (pdrBatcherHandlerInt pdrBatcherHandlerInt2 : pdrBatcherHandlerManager.getInstance().getHandlers()) {
            if (!pdrBatcherHandlerInt2.getConfig().DataSource.equalsIgnoreCase(string) || !pdrBatcherHandlerInt2.getDelivery().equalsIgnoreCase(THREAD_DELIVERY_BACKUP)) continue;
            Util_Logger.info(logger, "Disabling BACKUP delivery thread " + pdrBatcherHandlerInt2.getId() + " after PRIMARY delivery recovery");
            pdrBatcherHandlerInt2.setIsActive(false);
        }
    }

    private void clearHoldingDirectory() {
        Util_Logger.info(logger, "Commencing clean-out of holding directory");
        try {
            String string = Util.getProperty(PROPERTIES_FILE, "batcher_holding_dir");
            File file = new File(string);
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (int i2 = 0; i2 < fileArray.length; ++i2) {
                    if (!fileArray[i2].exists() || !fileArray[i2].delete()) continue;
                    Util_Logger.info(logger, "Deleted file " + fileArray[i2].getName() + " in holding directory clean-up");
                }
            } else {
                Util_Logger.warning(logger, "Detected network problem accessing " + string + " in batcher", null);
            }
        }
        catch (Exception exception) {
            Util_Logger.warning(logger, "Error in holding directory clean-up: " + exception.getMessage(), exception);
        }
    }

    @SuppressFBWarnings(value={"DM_EXIT", "IS2_INCONSISTENT_SYNC"})
    private pdrBatcherHandlerInt createThread(int n2) throws Exception {
        Object object;
        String string;
        String string2;
        String string32;
        List<String> list;
        String string4;
        String string5;
        String string62;
        String string7;
        pdrBatcherHandlerInt pdrBatcherHandlerInt2 = null;
        pdrBatcherHandlerConfig pdrBatcherHandlerConfig2 = new pdrBatcherHandlerConfig();
        Properties properties = Util.getPropertiesObject(PROPERTIES_FILE);
        String string8 = Util.getProperty(PROPERTIES_FILE, "batcher_holding_dir");
        String string9 = Util.getProperty(PROPERTIES_FILE, "batcher_timeout");
        String string10 = Util.getProperty(PROPERTIES_FILE, "batcher_polling_interval", "5");
        String string11 = Util.getProperty(PROPERTIES_FILE, "batcher_fail_interval", "60");
        this.itsHeartbeatFile = Util.getProperty(PROPERTIES_FILE, "batcher_heartbeat_file", "");
        pdrFileEventInt pdrFileEventInt2 = null;
        try {
            string7 = Util.getProperty(PROPERTIES_FILE, "batcher_event_class", "");
            if (!Util.isBlank(string7)) {
                pdrFileEventInt2 = (pdrFileEventInt)Class.forName(string7).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error instantiating file event handler class: " + exception.getMessage(), exception);
        }
        string7 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_delivery", THREAD_DELIVERY_PRIMARY);
        FileMaskSpecification fileMaskSpecification = new FileMaskSpecification();
        fileMaskSpecification.setIncludeFileMask(Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_inc", null));
        fileMaskSpecification.setExcludeFileMask(Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_exc", null));
        fileMaskSpecification.setFileMaskMode(Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_mask_mode", "EXCLUSIVE"));
        int n3 = Integer.parseInt(Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_min_size_bytes", "-1"));
        int n4 = Integer.parseInt(Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_max_size_kB", "-1"));
        int n5 = Integer.parseInt(Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_timeout", string9));
        int n6 = Integer.parseInt(Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_throttle", "0"));
        int n7 = (int)Double.parseDouble(Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_polling_interval", string10)) * 1000;
        int n8 = Integer.parseInt(Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_fail_interval", string11));
        String string12 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_schedule_mode", SCHEDULE_MODE_POLL);
        String string13 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_cron_job_schedule", null);
        double d2 = Double.parseDouble(Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_pause_interval", "0"));
        int n9 = Integer.parseInt(Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_process_limit", "0"));
        String string14 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_process_order", "");
        boolean bl = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_activity_monitor", "N").equalsIgnoreCase("Y");
        boolean bl2 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_allow_overwrite", "N").equalsIgnoreCase("Y");
        String string15 = "remote";
        String string16 = "local";
        String string17 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_source", string15);
        String string18 = Util.getProperty(PROPERTIES_FILE, "batcher_" + string17 + "_mode");
        String string19 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_mode", THREAD_MODE_CONSUMER);
        String string20 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_dest", string16);
        String string21 = Util.getProperty(PROPERTIES_FILE, "batcher_" + string20 + "_mode", "LOCAL");
        String string22 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_dest_dir_list_file", null);
        ArrayList<pdrBatcherHandlerConfigTranslator> arrayList = new ArrayList<pdrBatcherHandlerConfigTranslator>();
        String string23 = "batcher_thread_" + n2 + "_file_translator";
        for (String string62 : properties.stringPropertyNames()) {
            string5 = string62.toLowerCase();
            if (!string5.startsWith(string23) || string5.endsWith("_inc")) continue;
            string4 = properties.getProperty(string62);
            list = new pdrBatcherHandlerConfigTranslator();
            ((pdrBatcherHandlerConfigTranslator)((Object)list)).IncludeFileMask = Util.getProperty(properties, string62 + "_inc", "*");
            ((pdrBatcherHandlerConfigTranslator)((Object)list)).TranslationSpec = pdrFileTranslationUtil.resolveConfig(string4, string17);
            arrayList.add((pdrBatcherHandlerConfigTranslator)((Object)list));
        }
        Object object2 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_dest_dir", "");
        if (Util.isBlank((String)object2)) {
            object2 = Util.getProperty(PROPERTIES_FILE, "batcher_" + string20 + "_dir");
        }
        if (Util.isBlank(string62 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_source_dir", ""))) {
            string62 = Util.getProperty(PROPERTIES_FILE, "batcher_" + string17 + "_dir");
        }
        if (Util.isBlank(string5 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_source_archive_dir", ""))) {
            string5 = Util.getProperty(PROPERTIES_FILE, "batcher_" + string17 + "_archive_dir", "");
        }
        string4 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_sub_dir", null);
        list = null;
        if (!Util.isBlank(string4)) {
            list = string4.toLowerCase().startsWith("file:") ? Files.readAllLines(Paths.get(string4.substring(5), new String[0])) : Arrays.asList(Util.getColumns(string4, ','));
        }
        boolean bl3 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_dir_recurse", "N").equalsIgnoreCase("Y");
        boolean bl4 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_dir_create", "N").equalsIgnoreCase("Y");
        boolean bl5 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_sub_dir_dest", "Y").equalsIgnoreCase("Y");
        if (string18.equalsIgnoreCase(SCHEDULE_MODE_API)) {
            bl5 = false;
        }
        boolean bl6 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_check_file_integrity", "Y").equalsIgnoreCase("Y");
        int n10 = Integer.parseInt(Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_retention_time_mins", "-1"));
        int n11 = Integer.parseInt(Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_transfer_buffer_size", "-1"));
        String string24 = null;
        string24 = string18.equalsIgnoreCase("LOCAL") ? JOB_TYPE_UPLOAD : JOB_TYPE_DOWNLOAD;
        String string25 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_job_type", string24);
        String string26 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_source_file_mask", "");
        String string27 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_dest_file_mask", "");
        String string28 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_source_ack_dir", "");
        String string29 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_source_ack_api_header_values", "");
        ArrayList<pdrBatcherHandlerConfigTranslator> arrayList2 = new ArrayList<pdrBatcherHandlerConfigTranslator>();
        string23 = "batcher_thread_" + n2 + "_source_ack_translator";
        for (String string32 : properties.stringPropertyNames()) {
            string2 = string32.toLowerCase();
            if (!string2.startsWith(string23) || string2.endsWith("_inc")) continue;
            string = properties.getProperty(string32);
            object = new pdrBatcherHandlerConfigTranslator();
            ((pdrBatcherHandlerConfigTranslator)object).IncludeFileMask = Util.getProperty(properties, string32 + "_inc", "*");
            ((pdrBatcherHandlerConfigTranslator)object).TranslationSpec = pdrFileTranslationUtil.resolveConfig(string, string17);
            arrayList2.add((pdrBatcherHandlerConfigTranslator)object);
        }
        String string30 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_source_dir_list_url", null);
        string32 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_source_dir_list_api_header_values", null);
        string2 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_source_api_header_values", null);
        string = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_dest_api_header_values", null);
        string = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_dest_message_header_values", string);
        object = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_api_business_response_codes", null);
        if (Util.isBlank((String)object)) {
            object = Util.getProperty(PROPERTIES_FILE, "batcher_" + string17 + "_api_business_response_codes", null);
        }
        if (Util.isBlank((String)object)) {
            object = Util.getProperty(PROPERTIES_FILE, "batcher_" + string20 + "_api_business_response_codes", null);
        }
        if (Util.isBlank((String)object)) {
            object = "200";
        }
        String string31 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_hub_mgnt_api_url", null);
        String string32 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_hub_mgnt_api_header_values", null);
        String string33 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_event_data_source", null);
        String string34 = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_event_data_source_binding", null);
        boolean bl7 = Util.getProperty(PROPERTIES_FILE, "batcher_translator_process_chain_reporting", "N").equalsIgnoreCase("Y");
        pdrBatcherHandlerConfig2.ThreadId = n2;
        pdrBatcherHandlerConfig2.Name = "Thread " + n2;
        pdrBatcherHandlerConfig2.Description = Util.getProperty(PROPERTIES_FILE, "batcher_thread_" + n2 + "_description", pdrBatcherHandlerConfig2.Name);
        pdrBatcherHandlerConfig2.ThreadDelivery = string7;
        pdrBatcherHandlerConfig2.DataSource = string17;
        pdrBatcherHandlerConfig2.DataSourceProtocol = string18;
        pdrBatcherHandlerConfig2.DataDestination = string20;
        pdrBatcherHandlerConfig2.DataDestinationProtocol = string21;
        pdrBatcherHandlerConfig2.SourceDir = string62;
        pdrBatcherHandlerConfig2.DestinationDir = object2;
        pdrBatcherHandlerConfig2.FileMaskSpec = fileMaskSpecification;
        pdrBatcherHandlerConfig2.MinFileSizeBytes = n3;
        pdrBatcherHandlerConfig2.MaxFileSizeKB = n4;
        pdrBatcherHandlerConfig2.HoldingDir = string8;
        pdrBatcherHandlerConfig2.PollingIntervalMilliSecs = n7;
        pdrBatcherHandlerConfig2.PauseIntervalSecs = d2;
        pdrBatcherHandlerConfig2.FailWaitIntervalSecs = n8;
        pdrBatcherHandlerConfig2.SchedulingMode = string12;
        pdrBatcherHandlerConfig2.CronJobSchedule = string13;
        pdrBatcherHandlerConfig2.TimeoutSeconds = n5;
        pdrBatcherHandlerConfig2.TrottleBytesPerSecond = n6;
        pdrBatcherHandlerConfig2.ProcessLimitFiles = n9;
        pdrBatcherHandlerConfig2.FileProcessOrder = string14;
        pdrBatcherHandlerConfig2.TransferBufferSize = n11;
        pdrBatcherHandlerConfig2.Parent = this;
        pdrBatcherHandlerConfig2.ThreadActivityMonitor = bl;
        pdrBatcherHandlerConfig2.SubDirList = list;
        pdrBatcherHandlerConfig2.SubDirListDest = bl5;
        pdrBatcherHandlerConfig2.DirectoryRecurse = bl3;
        pdrBatcherHandlerConfig2.DirectoryCreate = bl4;
        pdrBatcherHandlerConfig2.AllowOverwrite = bl2;
        pdrBatcherHandlerConfig2.SourceArchiveDir = string5;
        pdrBatcherHandlerConfig2.DestinationDirListingFile = string22;
        pdrBatcherHandlerConfig2.FileTranslators = arrayList;
        pdrBatcherHandlerConfig2.FileEventHandler = pdrFileEventInt2;
        pdrBatcherHandlerConfig2.CheckFileIntegrity = bl6;
        pdrBatcherHandlerConfig2.JobType = string25;
        pdrBatcherHandlerConfig2.RetentionTimeMins = n10;
        pdrBatcherHandlerConfig2.SourceFilenameMask = string26;
        pdrBatcherHandlerConfig2.DestinationFilenameMask = string27;
        pdrBatcherHandlerConfig2.SourceAckDir = string28;
        pdrBatcherHandlerConfig2.SourceAckAPIHeaderValues = string29;
        pdrBatcherHandlerConfig2.SourceAckTranslators = arrayList2;
        pdrBatcherHandlerConfig2.SourceDirListURL = string30;
        pdrBatcherHandlerConfig2.SourceDirListAPIHeaderValues = string32;
        pdrBatcherHandlerConfig2.SourceAPIHeaderValues = string2;
        pdrBatcherHandlerConfig2.DestinationAPIHeaderValues = string;
        pdrBatcherHandlerConfig2.APIBusinessResponseCodes = object;
        pdrBatcherHandlerConfig2.HubManagementAPIURL = string31;
        pdrBatcherHandlerConfig2.HubManagementAPIHeaderValues = string32;
        pdrBatcherHandlerConfig2.EventDataSource = string33;
        pdrBatcherHandlerConfig2.EventDataSourceBinding = string34;
        pdrBatcherHandlerConfig2.ReportTranslatorProcessChain = bl7;
        pdrBatcherHandlerFactory pdrBatcherHandlerFactory2 = pdrBatcherHandlerFactory.getInstance();
        try {
            pdrBatcherHandlerInt2 = pdrBatcherHandlerFactory2.getProcessor(string19, pdrBatcherHandlerConfig2);
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error creating batcher thread " + n2 + ": " + exception.getMessage(), exception);
            System.exit(-1);
        }
        if (pdrBatcherHandlerInt2 != null) {
            pdrBatcherHandlerInt2.setIsActive(!string7.equalsIgnoreCase(THREAD_DELIVERY_BACKUP));
            if (pdrBatcherHandlerInt2.getDataSourceIsEventBased()) {
                FilesystemManager.getInstance().registerListener((fsEventListenerInt)((Object)pdrBatcherHandlerInt2));
            }
        }
        return pdrBatcherHandlerInt2;
    }

    public synchronized void updateLastBusyTime(String string) {
        Date date;
        this.itsLastBusyTime = date = new Date();
        if (!Util.isBlank(this.itsHeartbeatFile)) {
            File file = new File(this.itsHeartbeatFile);
            try {
                FileUtilities.touch(file);
            }
            catch (Exception exception) {
                Util_Logger.warning(logger, "Error updating heartbeat file: " + exception.getMessage(), exception);
            }
        }
    }

    @Override
    public String getAppName() {
        return APP_NAME;
    }

    @Override
    public String getAppVersion() {
        return VERSION;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Only accessed via trusted code")
    public Properties getConfiguration() {
        return this.itsConfiguration;
    }

    @Override
    public void stop() {
        for (pdrBatcherHandlerInt pdrBatcherHandlerInt2 : pdrBatcherHandlerManager.getInstance().getHandlers()) {
            pdrBatcherHandlerInt2.stop();
        }
    }

    @Override
    public void finaliseShutdown() {
        boolean bl = true;
        while (bl) {
            bl = false;
            for (pdrBatcherHandlerInt pdrBatcherHandlerInt2 : pdrBatcherHandlerManager.getInstance().getHandlers()) {
                bl = bl || !pdrBatcherHandlerInt2.getIsShutdown();
            }
            if (!bl) continue;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        pdrMonitorManager pdrMonitorManager2 = pdrMonitorManager.getInstance();
        pdrMonitorManager2.stop();
        pdrFileWebManager.stop();
        pdrFileCacheManager.stop();
        this.clearHoldingDirectory();
    }
}

