/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Common.Monitor;

import au.com.aemo.Common.FileSystem.fsTransactionMetaData;
import au.com.aemo.Common.Java.Util;
import au.com.nemmco.Pdr.Common.Monitor.pdrMonitorRec;
import au.com.nemmco.Pdr.Common.Monitor.pdrPerformanceJobSizeUnits;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Date;

@XStreamAlias(value="performance")
@SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
public class pdrPerformanceRec
extends pdrMonitorRec {
    private String DataSource;
    private String FileId;
    private String Confidentiality;
    private String Filename;
    private String FileExtension;
    private Date StartDate;
    private Date EndDate;
    private double Duration;
    private Integer HourOfDay;
    private String DayOfWeek;
    private String JobType;
    private long JobSize;
    private pdrPerformanceJobSizeUnits JobSizeUnits;
    private Integer NoJobs;
    private Date ContentCreationDate;
    private Date IntervalEndDate;
    private Double TransactionRate;
    private String MessageId;
    private String InitMessageId;
    private String ParticipantIdFrom;
    private String ParticipantIdTo;
    private double StartDelay;
    private double PrioritisationDelay;
    private Date EventReceivedDate;
    private String ProcessElementId;
    private String ProcessElementParentId;

    public String getFilename() {
        return this.Filename;
    }

    public void setFilename(String string) {
        this.Filename = string;
        if (string != null) {
            this.Confidentiality = string.toUpperCase().startsWith("PUBLIC") ? "PUBLIC" : "PRIVATE";
        }
    }

    private void calculateDuration() {
        if (this.StartDate != null && this.EndDate != null) {
            this.Duration = ((double)this.EndDate.getTime() - (double)this.StartDate.getTime()) / 1000.0;
            this.calculateTransactionRate();
        }
    }

    private void calculateStartDelay() {
        if (this.StartDate != null && this.ContentCreationDate != null) {
            this.StartDelay = ((double)this.StartDate.getTime() - (double)this.ContentCreationDate.getTime()) / 1000.0;
        }
    }

    private void calculateTransactionRate() {
        if (this.JobSize > 0L && this.Duration > 0.0) {
            this.TransactionRate = (double)this.JobSize / this.Duration;
        }
    }

    private void calculatePrioritisationDelay() {
        if (this.StartDate != null && this.EventReceivedDate != null) {
            this.PrioritisationDelay = ((double)this.StartDate.getTime() - (double)this.EventReceivedDate.getTime()) / 1000.0;
        }
    }

    public Date getStartDate() {
        return this.StartDate;
    }

    public void setStartDate(Date date) {
        this.StartDate = date;
        this.calculateDuration();
        this.calculateStartDelay();
        this.calculatePrioritisationDelay();
        if (this.StartDate != null) {
            this.HourOfDay = Integer.parseInt(Util.dateToStr(date, "HH"));
            this.DayOfWeek = Util.dateToStr(date, "E");
        }
    }

    public Date getEndDate() {
        return this.EndDate;
    }

    public void setEndDate(Date date) {
        this.EndDate = date;
        this.calculateDuration();
    }

    public double getDuration() {
        return this.Duration;
    }

    public double getStartDelay() {
        return this.StartDelay;
    }

    public long getJobSize() {
        return this.JobSize;
    }

    public void setJobSize(long l2) {
        this.JobSize = l2;
        this.calculateTransactionRate();
    }

    public pdrPerformanceJobSizeUnits getJobSizeUnits() {
        return this.JobSizeUnits;
    }

    public void setJobSizeUnits(pdrPerformanceJobSizeUnits pdrPerformanceJobSizeUnits2) {
        this.JobSizeUnits = pdrPerformanceJobSizeUnits2;
    }

    public String getDataSource() {
        return this.DataSource;
    }

    public void setDataSource(String string) {
        this.DataSource = string;
    }

    public String getFileExtension() {
        return this.FileExtension;
    }

    public void setFileExtension(String string) {
        this.FileExtension = string;
    }

    public String getJobType() {
        return this.JobType;
    }

    public void setJobType(String string) {
        this.JobType = string;
    }

    public String getFileId() {
        return this.FileId;
    }

    public void setFileId(String string) {
        this.FileId = string;
    }

    public int getNoJobs() {
        return this.NoJobs;
    }

    public void setNoJobs(int n2) {
        this.NoJobs = n2;
    }

    public Date getContentCreationDate() {
        return this.ContentCreationDate;
    }

    public void setContentCreationDate(Date date) {
        this.ContentCreationDate = date;
        this.calculateStartDelay();
    }

    public Date getIntervalEndDate() {
        return this.IntervalEndDate;
    }

    public void setIntervalEndDate(Date date) {
        this.IntervalEndDate = date;
    }

    public String getConfidentiality() {
        return this.Confidentiality;
    }

    public void setConfidentiality(String string) {
        this.Confidentiality = !Util.isBlank(string) ? (string.equalsIgnoreCase("PUBLIC") ? "PUBLIC" : "PRIVATE") : null;
    }

    public Double getTransactionRate() {
        return this.TransactionRate;
    }

    public String getMessageId() {
        return this.MessageId;
    }

    public String getInitiatingMessageId() {
        return this.InitMessageId;
    }

    public String getParticipantIdFrom() {
        return this.ParticipantIdFrom;
    }

    public String getParticipantIdTo() {
        return this.ParticipantIdTo;
    }

    public void setTransactionMetaData(fsTransactionMetaData fsTransactionMetaData2) {
        if (fsTransactionMetaData2 != null) {
            this.ParticipantIdFrom = fsTransactionMetaData2.getParticipantIdFrom();
            this.ParticipantIdTo = fsTransactionMetaData2.getParticipantIdTo();
            this.MessageId = fsTransactionMetaData2.getMessageId();
            this.InitMessageId = fsTransactionMetaData2.getInitiatingMessageId();
            this.FileId = fsTransactionMetaData2.getFileId();
        }
    }

    public Date getEventReceivedDate() {
        return this.EventReceivedDate;
    }

    public void setEventReceivedDate(Date date) {
        this.calculatePrioritisationDelay();
        this.EventReceivedDate = date;
    }

    public double getPrioritisationDelay() {
        return this.PrioritisationDelay;
    }

    public String getProcessElementId() {
        return this.ProcessElementId;
    }

    public void setProcessElementId(String string) {
        this.ProcessElementId = string;
    }

    public String getProcessElementParentId() {
        return this.ProcessElementParentId;
    }

    public void setProcessElementParentId(String string) {
        this.ProcessElementParentId = string;
    }
}

