/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1SetParser;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSet;
import com.enterprisedt.bouncycastle.asn1.DLSet;
import com.enterprisedt.bouncycastle.asn1.c;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Iterable;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class ASN1Set
extends ASN1Primitive
implements Iterable<ASN1Encodable> {
    static final c a = new c(ASN1Set.class, 17){

        @Override
        ASN1Primitive a(ASN1Sequence aSN1Sequence) {
            return aSN1Sequence.h();
        }
    };
    protected final ASN1Encodable[] elements;
    protected ASN1Encodable[] sortedElements;

    public static ASN1Set getInstance(Object obj) {
        if (obj == null || obj instanceof ASN1Set) {
            return (ASN1Set)obj;
        }
        if (obj instanceof ASN1Encodable) {
            ASN1Primitive aSN1Primitive = ((ASN1Encodable)obj).toASN1Primitive();
            if (aSN1Primitive instanceof ASN1Set) {
                return (ASN1Set)aSN1Primitive;
            }
        } else if (obj instanceof byte[]) {
            try {
                return (ASN1Set)a.a((byte[])obj);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("failed to construct set from byte[]: " + iOException.getMessage());
            }
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + obj.getClass().getName());
    }

    public static ASN1Set getInstance(ASN1TaggedObject taggedObject, boolean explicit) {
        return (ASN1Set)a.a(taggedObject, explicit);
    }

    protected ASN1Set() {
        this.elements = ASN1EncodableVector.a;
        this.sortedElements = this.elements;
    }

    protected ASN1Set(ASN1Encodable element) {
        if (null == element) {
            throw new NullPointerException("'element' cannot be null");
        }
        this.elements = new ASN1Encodable[]{element};
        this.sortedElements = this.elements;
    }

    protected ASN1Set(ASN1EncodableVector elementVector, boolean doSort) {
        ASN1Encodable[] aSN1EncodableArray;
        if (null == elementVector) {
            throw new NullPointerException("'elementVector' cannot be null");
        }
        if (doSort && elementVector.size() >= 2) {
            aSN1EncodableArray = elementVector.a();
            ASN1Set.a(aSN1EncodableArray);
        } else {
            aSN1EncodableArray = elementVector.b();
        }
        this.elements = aSN1EncodableArray;
        this.sortedElements = doSort || aSN1EncodableArray.length < 2 ? this.elements : null;
    }

    protected ASN1Set(ASN1Encodable[] elements, boolean doSort) {
        if (Arrays.isNullOrContainsNull(elements)) {
            throw new NullPointerException("'elements' cannot be null, or contain null");
        }
        ASN1Encodable[] aSN1EncodableArray = ASN1EncodableVector.a(elements);
        if (doSort && aSN1EncodableArray.length >= 2) {
            ASN1Set.a(aSN1EncodableArray);
        }
        this.elements = aSN1EncodableArray;
        this.sortedElements = doSort || aSN1EncodableArray.length < 2 ? elements : null;
    }

    ASN1Set(boolean isSorted, ASN1Encodable[] elements) {
        this.elements = elements;
        this.sortedElements = isSorted || elements.length < 2 ? elements : null;
    }

    ASN1Set(ASN1Encodable[] elements, ASN1Encodable[] sortedElements) {
        this.elements = elements;
        this.sortedElements = sortedElements;
    }

    public Enumeration getObjects() {
        return new Enumeration(){
            private int b = 0;

            @Override
            public boolean hasMoreElements() {
                return this.b < ASN1Set.this.elements.length;
            }

            public Object nextElement() {
                if (this.b < ASN1Set.this.elements.length) {
                    return ASN1Set.this.elements[this.b++];
                }
                throw new NoSuchElementException();
            }
        };
    }

    public ASN1Encodable getObjectAt(int index) {
        return this.elements[index];
    }

    public int size() {
        return this.elements.length;
    }

    public ASN1Encodable[] toArray() {
        return ASN1EncodableVector.a(this.elements);
    }

    public ASN1SetParser parser() {
        final int n2 = this.size();
        return new ASN1SetParser(){
            private int c = 0;

            @Override
            public ASN1Encodable readObject() throws IOException {
                ASN1Encodable aSN1Encodable;
                if (n2 == this.c) {
                    return null;
                }
                if ((aSN1Encodable = ASN1Set.this.elements[this.c++]) instanceof ASN1Sequence) {
                    return ((ASN1Sequence)aSN1Encodable).parser();
                }
                if (aSN1Encodable instanceof ASN1Set) {
                    return ((ASN1Set)aSN1Encodable).parser();
                }
                return aSN1Encodable;
            }

            @Override
            public ASN1Primitive getLoadedObject() {
                return ASN1Set.this;
            }

            @Override
            public ASN1Primitive toASN1Primitive() {
                return ASN1Set.this;
            }
        };
    }

    @Override
    public int hashCode() {
        int n2 = this.elements.length;
        int n3 = n2 + 1;
        while (--n2 >= 0) {
            n3 += this.elements[n2].toASN1Primitive().hashCode();
        }
        return n3;
    }

    @Override
    ASN1Primitive b() {
        if (this.sortedElements == null) {
            this.sortedElements = (ASN1Encodable[])this.elements.clone();
            ASN1Set.a(this.sortedElements);
        }
        return new DERSet(true, this.sortedElements);
    }

    @Override
    ASN1Primitive c() {
        return new DLSet(this.elements, this.sortedElements);
    }

    @Override
    boolean a(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1Set)) {
            return false;
        }
        ASN1Set aSN1Set = (ASN1Set)aSN1Primitive;
        int n2 = this.size();
        if (aSN1Set.size() != n2) {
            return false;
        }
        DERSet dERSet = (DERSet)this.b();
        DERSet dERSet2 = (DERSet)aSN1Set.b();
        for (int i2 = 0; i2 < n2; ++i2) {
            ASN1Primitive aSN1Primitive2;
            ASN1Primitive aSN1Primitive3 = dERSet.elements[i2].toASN1Primitive();
            if (aSN1Primitive3 == (aSN1Primitive2 = dERSet2.elements[i2].toASN1Primitive()) || aSN1Primitive3.a(aSN1Primitive2)) continue;
            return false;
        }
        return true;
    }

    @Override
    boolean a() {
        return true;
    }

    public String toString() {
        int n2 = this.size();
        if (0 == n2) {
            return "[]";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        int n3 = 0;
        while (true) {
            stringBuffer.append(this.elements[n3]);
            if (++n3 >= n2) break;
            stringBuffer.append(", ");
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    @Override
    public Iterator<ASN1Encodable> iterator() {
        return new Arrays.Iterator<ASN1Encodable>(this.toArray());
    }

    private static byte[] a(ASN1Encodable aSN1Encodable) {
        try {
            return aSN1Encodable.toASN1Primitive().getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("cannot encode object added to SET");
        }
    }

    private static boolean a(byte[] byArray, byte[] byArray2) {
        int n2 = byArray[0] & 0xDF;
        int n3 = byArray2[0] & 0xDF;
        if (n2 != n3) {
            return n2 < n3;
        }
        int n4 = Math.min(byArray.length, byArray2.length) - 1;
        for (int i2 = 1; i2 < n4; ++i2) {
            if (byArray[i2] == byArray2[i2]) continue;
            return (byArray[i2] & 0xFF) < (byArray2[i2] & 0xFF);
        }
        return (byArray[n4] & 0xFF) <= (byArray2[n4] & 0xFF);
    }

    private static void a(ASN1Encodable[] aSN1EncodableArray) {
        Object object;
        int n2 = aSN1EncodableArray.length;
        if (n2 < 2) {
            return;
        }
        Object object2 = aSN1EncodableArray[0];
        Object object3 = aSN1EncodableArray[1];
        byte[] byArray = ASN1Set.a((ASN1Encodable)object2);
        byte[] byArray2 = ASN1Set.a((ASN1Encodable)object3);
        if (ASN1Set.a(byArray2, byArray)) {
            ASN1Encodable aSN1Encodable = object3;
            object3 = object2;
            object2 = aSN1Encodable;
            object = byArray2;
            byArray2 = byArray;
            byArray = object;
        }
        for (int i2 = 2; i2 < n2; ++i2) {
            ASN1Encodable aSN1Encodable;
            byte[] byArray3;
            object = aSN1EncodableArray[i2];
            byte[] byArray4 = ASN1Set.a((ASN1Encodable)object);
            if (ASN1Set.a(byArray2, byArray4)) {
                aSN1EncodableArray[i2 - 2] = object2;
                object2 = object3;
                byArray = byArray2;
                object3 = object;
                byArray2 = byArray4;
                continue;
            }
            if (ASN1Set.a(byArray, byArray4)) {
                aSN1EncodableArray[i2 - 2] = object2;
                object2 = object;
                byArray = byArray4;
                continue;
            }
            int n3 = i2 - 1;
            while (--n3 > 0 && !ASN1Set.a(byArray3 = ASN1Set.a(aSN1Encodable = aSN1EncodableArray[n3 - 1]), byArray4)) {
                aSN1EncodableArray[n3] = aSN1Encodable;
            }
            aSN1EncodableArray[n3] = object;
        }
        aSN1EncodableArray[n2 - 2] = object2;
        aSN1EncodableArray[n2 - 1] = object3;
    }
}

