/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Exception;
import com.enterprisedt.bouncycastle.asn1.ASN1InputStream;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObjectParser;
import com.enterprisedt.bouncycastle.asn1.BERBitStringParser;
import com.enterprisedt.bouncycastle.asn1.BEROctetStringParser;
import com.enterprisedt.bouncycastle.asn1.BERSequenceParser;
import com.enterprisedt.bouncycastle.asn1.BERSetParser;
import com.enterprisedt.bouncycastle.asn1.DERExternalParser;
import com.enterprisedt.bouncycastle.asn1.DEROctetStringParser;
import com.enterprisedt.bouncycastle.asn1.DLBitStringParser;
import com.enterprisedt.bouncycastle.asn1.DLSequenceParser;
import com.enterprisedt.bouncycastle.asn1.DLSetParser;
import com.enterprisedt.bouncycastle.asn1.InMemoryRepresentable;
import com.enterprisedt.bouncycastle.asn1.f;
import com.enterprisedt.bouncycastle.asn1.m;
import com.enterprisedt.bouncycastle.asn1.n;
import com.enterprisedt.bouncycastle.asn1.o;
import com.enterprisedt.bouncycastle.asn1.s;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ASN1StreamParser {
    private final InputStream a;
    private final int b;
    private final byte[][] c;

    public ASN1StreamParser(InputStream in) {
        this(in, s.a(in));
    }

    public ASN1StreamParser(byte[] encoding) {
        this(new ByteArrayInputStream(encoding), encoding.length);
    }

    public ASN1StreamParser(InputStream in, int limit) {
        this(in, limit, new byte[11][]);
    }

    ASN1StreamParser(InputStream in, int limit, byte[][] tmpBuffers) {
        this.a = in;
        this.b = limit;
        this.c = tmpBuffers;
    }

    public ASN1Encodable readObject() throws IOException {
        int n2 = this.a.read();
        if (n2 < 0) {
            return null;
        }
        return this.a(n2);
    }

    ASN1Encodable a(int n2) throws IOException {
        this.a(false);
        int n3 = ASN1InputStream.a(this.a, n2);
        int n4 = ASN1InputStream.a(this.a, this.b, n3 == 3 || n3 == 4 || n3 == 16 || n3 == 17 || n3 == 8);
        if (n4 < 0) {
            if (0 == (n2 & 0x20)) {
                throw new IOException("indefinite-length primitive encoding encountered");
            }
            o o2 = new o(this.a, this.b);
            ASN1StreamParser aSN1StreamParser = new ASN1StreamParser(o2, this.b, this.c);
            int n5 = n2 & 0xC0;
            if (0 != n5) {
                return new f(n5, n3, aSN1StreamParser);
            }
            return aSN1StreamParser.c(n3);
        }
        n n6 = new n(this.a, n4, this.b);
        if (0 == (n2 & 0xE0)) {
            return this.a(n3, n6);
        }
        ASN1StreamParser aSN1StreamParser = new ASN1StreamParser(n6, n6.c(), this.c);
        int n7 = n2 & 0xC0;
        if (0 != n7) {
            boolean bl = (n2 & 0x20) != 0;
            return new m(n7, n3, bl, aSN1StreamParser);
        }
        return aSN1StreamParser.b(n3);
    }

    ASN1Primitive a(int n2, int n3, boolean bl) throws IOException {
        if (!bl) {
            byte[] byArray = ((n)this.a).b();
            return ASN1TaggedObject.a(n2, n3, byArray);
        }
        ASN1EncodableVector aSN1EncodableVector = this.b();
        return ASN1TaggedObject.a(n2, n3, aSN1EncodableVector);
    }

    ASN1Primitive a(int n2, int n3) throws IOException {
        ASN1EncodableVector aSN1EncodableVector = this.b();
        return ASN1TaggedObject.b(n2, n3, aSN1EncodableVector);
    }

    ASN1Encodable b(int n2) throws IOException {
        switch (n2) {
            case 3: {
                return new BERBitStringParser(this);
            }
            case 8: {
                return new DERExternalParser(this);
            }
            case 4: {
                return new BEROctetStringParser(this);
            }
            case 17: {
                return new DLSetParser(this);
            }
            case 16: {
                return new DLSequenceParser(this);
            }
        }
        throw new ASN1Exception("unknown DL object encountered: 0x" + Integer.toHexString(n2));
    }

    ASN1Encodable c(int n2) throws IOException {
        switch (n2) {
            case 3: {
                return new BERBitStringParser(this);
            }
            case 4: {
                return new BEROctetStringParser(this);
            }
            case 8: {
                return new DERExternalParser(this);
            }
            case 16: {
                return new BERSequenceParser(this);
            }
            case 17: {
                return new BERSetParser(this);
            }
        }
        throw new ASN1Exception("unknown BER object encountered: 0x" + Integer.toHexString(n2));
    }

    ASN1Encodable d(int n2) throws IOException {
        return this.a(n2, (n)this.a);
    }

    ASN1Encodable a(int n2, n n3) throws IOException {
        switch (n2) {
            case 3: {
                return new DLBitStringParser(n3);
            }
            case 8: {
                throw new ASN1Exception("externals must use constructed encoding (see X.690 8.18)");
            }
            case 4: {
                return new DEROctetStringParser(n3);
            }
            case 17: {
                throw new ASN1Exception("sequences must use constructed encoding (see X.690 8.9.1/8.10.1)");
            }
            case 16: {
                throw new ASN1Exception("sets must use constructed encoding (see X.690 8.11.1/8.12.1)");
            }
        }
        try {
            return ASN1InputStream.a(n2, n3, this.c);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ASN1Exception("corrupted stream detected", illegalArgumentException);
        }
    }

    ASN1Encodable e(int n2) throws IOException {
        if (n2 < 0 || n2 > 30) {
            throw new IllegalArgumentException("invalid universal tag number: " + n2);
        }
        int n3 = this.a.read();
        if (n3 < 0) {
            return null;
        }
        if ((n3 & 0xFFFFFFDF) != n2) {
            throw new IOException("unexpected identifier encountered: " + n3);
        }
        return this.a(n3);
    }

    ASN1TaggedObjectParser a() throws IOException {
        int n2 = this.a.read();
        if (n2 < 0) {
            return null;
        }
        int n3 = n2 & 0xC0;
        if (0 == n3) {
            throw new ASN1Exception("no tagged object found");
        }
        return (ASN1TaggedObjectParser)this.a(n2);
    }

    ASN1EncodableVector b() throws IOException {
        int n2 = this.a.read();
        if (n2 < 0) {
            return new ASN1EncodableVector(0);
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        do {
            ASN1Encodable aSN1Encodable;
            if ((aSN1Encodable = this.a(n2)) instanceof InMemoryRepresentable) {
                aSN1EncodableVector.add(((InMemoryRepresentable)((Object)aSN1Encodable)).getLoadedObject());
                continue;
            }
            aSN1EncodableVector.add(aSN1Encodable.toASN1Primitive());
        } while ((n2 = this.a.read()) >= 0);
        return aSN1EncodableVector;
    }

    private void a(boolean bl) {
        if (this.a instanceof o) {
            ((o)this.a).a(bl);
        }
    }
}

