/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.eac;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1InputStream;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1ParsingException;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.eac.CertificateBody;
import com.enterprisedt.bouncycastle.asn1.eac.CertificateHolderAuthorization;
import com.enterprisedt.bouncycastle.asn1.eac.CertificateHolderReference;
import com.enterprisedt.bouncycastle.asn1.eac.CertificationAuthorityReference;
import com.enterprisedt.bouncycastle.asn1.eac.Flags;
import com.enterprisedt.bouncycastle.asn1.eac.PackedDate;
import com.enterprisedt.bouncycastle.asn1.eac.a;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.IOException;
import java.util.Enumeration;

public class CVCertificate
extends ASN1Object {
    private CertificateBody a;
    private byte[] b;
    private int c;
    private static int d = 1;
    private static int e = 2;

    private void a(ASN1TaggedObject aSN1TaggedObject) throws IOException {
        this.c = 0;
        if (aSN1TaggedObject.hasTag(64, 33)) {
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(aSN1TaggedObject.getBaseUniversal(false, 16));
            Enumeration enumeration = aSN1Sequence.getObjects();
            while (enumeration.hasMoreElements()) {
                Object e2 = enumeration.nextElement();
                if (e2 instanceof ASN1TaggedObject) {
                    ASN1TaggedObject aSN1TaggedObject2 = ASN1TaggedObject.getInstance(e2, 64);
                    switch (aSN1TaggedObject2.getTagNo()) {
                        case 78: {
                            this.a = CertificateBody.getInstance(aSN1TaggedObject2);
                            this.c |= d;
                            break;
                        }
                        case 55: {
                            this.b = ASN1OctetString.getInstance(aSN1TaggedObject2.getBaseUniversal(false, 4)).getOctets();
                            this.c |= e;
                            break;
                        }
                        default: {
                            throw new IOException("Invalid tag, not an Iso7816CertificateStructure :" + aSN1TaggedObject2.getTagNo());
                        }
                    }
                    continue;
                }
                throw new IOException("Invalid Object, not an Iso7816CertificateStructure");
            }
        } else {
            throw new IOException("not a CARDHOLDER_CERTIFICATE :" + aSN1TaggedObject.getTagNo());
        }
        if (this.c != (e | d)) {
            throw new IOException("invalid CARDHOLDER_CERTIFICATE :" + aSN1TaggedObject.getTagNo());
        }
    }

    public CVCertificate(ASN1InputStream aIS) throws IOException {
        this.a(aIS);
    }

    private void a(ASN1InputStream aSN1InputStream) throws IOException {
        ASN1Primitive aSN1Primitive;
        while ((aSN1Primitive = aSN1InputStream.readObject()) != null) {
            if (aSN1Primitive instanceof ASN1TaggedObject) {
                this.a((ASN1TaggedObject)aSN1Primitive);
                continue;
            }
            throw new IOException("Invalid Input Stream for creating an Iso7816CertificateStructure");
        }
    }

    private CVCertificate(ASN1TaggedObject appSpe) throws IOException {
        this.a(appSpe);
    }

    public CVCertificate(CertificateBody body, byte[] signature) throws IOException {
        this.a = body;
        this.b = Arrays.clone(signature);
        this.c |= d;
        this.c |= e;
    }

    public static CVCertificate getInstance(Object obj) {
        if (obj instanceof CVCertificate) {
            return (CVCertificate)obj;
        }
        if (obj != null) {
            try {
                return new CVCertificate(ASN1TaggedObject.getInstance(obj, 64));
            }
            catch (IOException iOException) {
                throw new ASN1ParsingException("unable to parse data: " + iOException.getMessage(), iOException);
            }
        }
        return null;
    }

    public byte[] getSignature() {
        return Arrays.clone(this.b);
    }

    public CertificateBody getBody() {
        return this.a;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(2);
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(com.enterprisedt.bouncycastle.asn1.eac.a.a(55, this.b));
        return com.enterprisedt.bouncycastle.asn1.eac.a.a(33, new DERSequence(aSN1EncodableVector));
    }

    public ASN1ObjectIdentifier getHolderAuthorization() throws IOException {
        CertificateHolderAuthorization certificateHolderAuthorization = this.a.getCertificateHolderAuthorization();
        return certificateHolderAuthorization.getOid();
    }

    public PackedDate getEffectiveDate() throws IOException {
        return this.a.getCertificateEffectiveDate();
    }

    public int getCertificateType() {
        return this.a.getCertificateType();
    }

    public PackedDate getExpirationDate() throws IOException {
        return this.a.getCertificateExpirationDate();
    }

    public int getRole() throws IOException {
        CertificateHolderAuthorization certificateHolderAuthorization = this.a.getCertificateHolderAuthorization();
        return certificateHolderAuthorization.getAccessRights();
    }

    public CertificationAuthorityReference getAuthorityReference() throws IOException {
        return this.a.getCertificationAuthorityReference();
    }

    public CertificateHolderReference getHolderReference() throws IOException {
        return this.a.getCertificateHolderReference();
    }

    public int getHolderAuthorizationRole() throws IOException {
        int n2 = this.a.getCertificateHolderAuthorization().getAccessRights();
        return n2 & 0xC0;
    }

    public Flags getHolderAuthorizationRights() throws IOException {
        return new Flags(this.a.getCertificateHolderAuthorization().getAccessRights() & 0x1F);
    }
}

