/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.eac;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1ParsingException;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.eac.CertificateBody;
import com.enterprisedt.bouncycastle.asn1.eac.PublicKeyDataObject;
import com.enterprisedt.bouncycastle.asn1.eac.a;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.IOException;
import java.util.Enumeration;

public class CVCertificateRequest
extends ASN1Object {
    private final ASN1TaggedObject a;
    private CertificateBody b;
    private byte[] c = null;
    private byte[] d = null;

    private CVCertificateRequest(ASN1TaggedObject request) throws IOException {
        this.a = request;
        if (request.hasTag(64, 7)) {
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(request.getBaseUniversal(false, 16));
            this.a(ASN1TaggedObject.getInstance(aSN1Sequence.getObjectAt(0), 64));
            this.d = ASN1OctetString.getInstance(ASN1TaggedObject.getInstance(aSN1Sequence.getObjectAt(aSN1Sequence.size() - 1)).getBaseUniversal(false, 4)).getOctets();
        } else {
            this.a(request);
        }
    }

    private void a(ASN1TaggedObject aSN1TaggedObject) throws IOException {
        if (aSN1TaggedObject.hasTag(64, 33)) {
            int n2 = 0;
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(aSN1TaggedObject.getBaseUniversal(false, 16));
            Enumeration enumeration = aSN1Sequence.getObjects();
            block4: while (enumeration.hasMoreElements()) {
                ASN1TaggedObject aSN1TaggedObject2 = ASN1TaggedObject.getInstance(enumeration.nextElement(), 64);
                switch (aSN1TaggedObject2.getTagNo()) {
                    case 78: {
                        this.b = CertificateBody.getInstance(aSN1TaggedObject2);
                        n2 |= 1;
                        continue block4;
                    }
                    case 55: {
                        this.c = ASN1OctetString.getInstance(aSN1TaggedObject2.getBaseUniversal(false, 4)).getOctets();
                        n2 |= 2;
                        continue block4;
                    }
                }
                throw new IOException("Invalid tag, not an CV Certificate Request element:" + aSN1TaggedObject2.getTagNo());
            }
            if ((n2 & 3) == 0) {
                throw new IOException("Invalid CARDHOLDER_CERTIFICATE in request:" + aSN1TaggedObject.getTagNo());
            }
        } else {
            throw new IOException("not a CARDHOLDER_CERTIFICATE in request:" + aSN1TaggedObject.getTagNo());
        }
    }

    public static CVCertificateRequest getInstance(Object obj) {
        if (obj instanceof CVCertificateRequest) {
            return (CVCertificateRequest)obj;
        }
        if (obj != null) {
            try {
                return new CVCertificateRequest(ASN1TaggedObject.getInstance(obj, 64));
            }
            catch (IOException iOException) {
                throw new ASN1ParsingException("unable to parse data: " + iOException.getMessage(), iOException);
            }
        }
        return null;
    }

    public CertificateBody getCertificateBody() {
        return this.b;
    }

    public PublicKeyDataObject getPublicKey() {
        return this.b.getPublicKey();
    }

    public byte[] getInnerSignature() {
        return Arrays.clone(this.c);
    }

    public byte[] getOuterSignature() {
        return Arrays.clone(this.d);
    }

    public boolean hasOuterSignature() {
        return this.d != null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        if (this.a != null) {
            return this.a;
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(2);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(com.enterprisedt.bouncycastle.asn1.eac.a.a(55, this.c));
        return com.enterprisedt.bouncycastle.asn1.eac.a.a(33, new DERSequence(aSN1EncodableVector));
    }
}

