/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.esf;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.esf.CrlIdentifier;
import com.enterprisedt.bouncycastle.asn1.esf.OtherHash;

public class CrlValidatedID
extends ASN1Object {
    private OtherHash a;
    private CrlIdentifier b;

    public static CrlValidatedID getInstance(Object obj) {
        if (obj instanceof CrlValidatedID) {
            return (CrlValidatedID)obj;
        }
        if (obj != null) {
            return new CrlValidatedID(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private CrlValidatedID(ASN1Sequence seq) {
        if (seq.size() < 1 || seq.size() > 2) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        this.a = OtherHash.getInstance(seq.getObjectAt(0));
        if (seq.size() > 1) {
            this.b = CrlIdentifier.getInstance(seq.getObjectAt(1));
        }
    }

    public CrlValidatedID(OtherHash crlHash) {
        this(crlHash, null);
    }

    public CrlValidatedID(OtherHash crlHash, CrlIdentifier crlIdentifier) {
        this.a = crlHash;
        this.b = crlIdentifier;
    }

    public OtherHash getCrlHash() {
        return this.a;
    }

    public CrlIdentifier getCrlIdentifier() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(2);
        aSN1EncodableVector.add(this.a.toASN1Primitive());
        if (null != this.b) {
            aSN1EncodableVector.add(this.b.toASN1Primitive());
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

