/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.pkcs;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.BERSequence;
import com.enterprisedt.bouncycastle.asn1.BERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class EncryptedData
extends ASN1Object {
    ASN1Sequence a;

    public static EncryptedData getInstance(Object obj) {
        if (obj instanceof EncryptedData) {
            return (EncryptedData)obj;
        }
        if (obj != null) {
            return new EncryptedData(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private EncryptedData(ASN1Sequence seq) {
        ASN1Integer aSN1Integer = (ASN1Integer)seq.getObjectAt(0);
        if (!aSN1Integer.hasValue(0)) {
            throw new IllegalArgumentException("sequence not version 0");
        }
        this.a = ASN1Sequence.getInstance(seq.getObjectAt(1));
    }

    public EncryptedData(ASN1ObjectIdentifier contentType, AlgorithmIdentifier encryptionAlgorithm, ASN1Encodable content) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(3);
        aSN1EncodableVector.add(contentType);
        aSN1EncodableVector.add(encryptionAlgorithm.toASN1Primitive());
        aSN1EncodableVector.add(new BERTaggedObject(false, 0, content));
        this.a = new BERSequence(aSN1EncodableVector);
    }

    public ASN1ObjectIdentifier getContentType() {
        return ASN1ObjectIdentifier.getInstance(this.a.getObjectAt(0));
    }

    public AlgorithmIdentifier getEncryptionAlgorithm() {
        return AlgorithmIdentifier.getInstance(this.a.getObjectAt(1));
    }

    public ASN1OctetString getContent() {
        if (this.a.size() == 3) {
            ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(this.a.getObjectAt(2));
            return ASN1OctetString.getInstance(aSN1TaggedObject, false);
        }
        return null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(2);
        aSN1EncodableVector.add(new ASN1Integer(0L));
        aSN1EncodableVector.add(this.a);
        return new BERSequence(aSN1EncodableVector);
    }
}

