/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.pkcs;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERNull;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.math.BigInteger;
import java.util.Enumeration;

public class PBKDF2Params
extends ASN1Object {
    private static final AlgorithmIdentifier a = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA1, DERNull.INSTANCE);
    private final ASN1OctetString b;
    private final ASN1Integer c;
    private final ASN1Integer d;
    private final AlgorithmIdentifier e;

    public static PBKDF2Params getInstance(Object obj) {
        if (obj instanceof PBKDF2Params) {
            return (PBKDF2Params)obj;
        }
        if (obj != null) {
            return new PBKDF2Params(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public PBKDF2Params(byte[] salt, int iterationCount) {
        this(salt, iterationCount, 0);
    }

    public PBKDF2Params(byte[] salt, int iterationCount, int keyLength) {
        this(salt, iterationCount, keyLength, null);
    }

    public PBKDF2Params(byte[] salt, int iterationCount, int keyLength, AlgorithmIdentifier prf) {
        this.b = new DEROctetString(Arrays.clone(salt));
        this.c = new ASN1Integer(iterationCount);
        this.d = keyLength > 0 ? new ASN1Integer(keyLength) : null;
        this.e = prf;
    }

    public PBKDF2Params(byte[] salt, int iterationCount, AlgorithmIdentifier prf) {
        this(salt, iterationCount, 0, prf);
    }

    private PBKDF2Params(ASN1Sequence seq) {
        Enumeration enumeration = seq.getObjects();
        this.b = (ASN1OctetString)enumeration.nextElement();
        this.c = (ASN1Integer)enumeration.nextElement();
        if (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if (object instanceof ASN1Integer) {
                this.d = ASN1Integer.getInstance(object);
                object = enumeration.hasMoreElements() ? enumeration.nextElement() : null;
            } else {
                this.d = null;
            }
            this.e = object != null ? AlgorithmIdentifier.getInstance(object) : null;
        } else {
            this.d = null;
            this.e = null;
        }
    }

    public byte[] getSalt() {
        return Arrays.clone(this.b.getOctets());
    }

    public BigInteger getIterationCount() {
        return this.c.getValue();
    }

    public BigInteger getKeyLength() {
        if (this.d != null) {
            return this.d.getValue();
        }
        return null;
    }

    public boolean isDefaultPrf() {
        return this.e == null || this.e.equals(a);
    }

    public AlgorithmIdentifier getPrf() {
        if (this.e != null) {
            return this.e;
        }
        return a;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(4);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        if (this.d != null) {
            aSN1EncodableVector.add(this.d);
        }
        if (this.e != null && !this.e.equals(a)) {
            aSN1EncodableVector.add(this.e);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

