/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.pkcs;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.pkcs.PBKDF2Params;
import com.enterprisedt.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;
import java.util.Enumeration;

public class PBMAC1Params
extends ASN1Object
implements PKCSObjectIdentifiers {
    private AlgorithmIdentifier a;
    private AlgorithmIdentifier b;

    public static PBMAC1Params getInstance(Object obj) {
        if (obj instanceof PBMAC1Params) {
            return (PBMAC1Params)obj;
        }
        if (obj != null) {
            return new PBMAC1Params(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public PBMAC1Params(AlgorithmIdentifier keyDevFunc, AlgorithmIdentifier encScheme) {
        this.a = keyDevFunc;
        this.b = encScheme;
    }

    private PBMAC1Params(ASN1Sequence obj) {
        Enumeration enumeration = obj.getObjects();
        ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(((ASN1Encodable)enumeration.nextElement()).toASN1Primitive());
        this.a = aSN1Sequence.getObjectAt(0).equals(id_PBKDF2) ? new AlgorithmIdentifier(id_PBKDF2, PBKDF2Params.getInstance(aSN1Sequence.getObjectAt(1))) : AlgorithmIdentifier.getInstance(aSN1Sequence);
        this.b = AlgorithmIdentifier.getInstance(enumeration.nextElement());
    }

    public AlgorithmIdentifier getKeyDerivationFunc() {
        return this.a;
    }

    public AlgorithmIdentifier getMessageAuthScheme() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(2);
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        return new DERSequence(aSN1EncodableVector);
    }
}

