/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.pkcs;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import java.math.BigInteger;

public class RC2CBCParameter
extends ASN1Object {
    ASN1Integer a;
    ASN1OctetString b;

    public static RC2CBCParameter getInstance(Object o2) {
        if (o2 instanceof RC2CBCParameter) {
            return (RC2CBCParameter)o2;
        }
        if (o2 != null) {
            return new RC2CBCParameter(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public RC2CBCParameter(byte[] iv) {
        this.a = null;
        this.b = new DEROctetString(iv);
    }

    public RC2CBCParameter(int parameterVersion, byte[] iv) {
        this.a = new ASN1Integer(parameterVersion);
        this.b = new DEROctetString(iv);
    }

    private RC2CBCParameter(ASN1Sequence seq) {
        if (seq.size() == 1) {
            this.a = null;
            this.b = (ASN1OctetString)seq.getObjectAt(0);
        } else {
            this.a = (ASN1Integer)seq.getObjectAt(0);
            this.b = (ASN1OctetString)seq.getObjectAt(1);
        }
    }

    public BigInteger getRC2ParameterVersion() {
        if (this.a == null) {
            return null;
        }
        return this.a.getValue();
    }

    public byte[] getIV() {
        return this.b.getOctets();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(2);
        if (this.a != null) {
            aSN1EncodableVector.add(this.a);
        }
        aSN1EncodableVector.add(this.b);
        return new DERSequence(aSN1EncodableVector);
    }
}

