/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.pkcs;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1Set;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DLSequence;
import com.enterprisedt.bouncycastle.asn1.DLTaggedObject;

public class SafeBag
extends ASN1Object {
    private ASN1ObjectIdentifier a;
    private ASN1Encodable b;
    private ASN1Set c;

    public SafeBag(ASN1ObjectIdentifier oid, ASN1Encodable obj) {
        this.a = oid;
        this.b = obj;
        this.c = null;
    }

    public SafeBag(ASN1ObjectIdentifier oid, ASN1Encodable obj, ASN1Set bagAttributes) {
        this.a = oid;
        this.b = obj;
        this.c = bagAttributes;
    }

    public static SafeBag getInstance(Object obj) {
        if (obj instanceof SafeBag) {
            return (SafeBag)obj;
        }
        if (obj != null) {
            return new SafeBag(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private SafeBag(ASN1Sequence seq) {
        this.a = (ASN1ObjectIdentifier)seq.getObjectAt(0);
        this.b = ((ASN1TaggedObject)seq.getObjectAt(1)).getExplicitBaseObject();
        if (seq.size() == 3) {
            this.c = (ASN1Set)seq.getObjectAt(2);
        }
    }

    public ASN1ObjectIdentifier getBagId() {
        return this.a;
    }

    public ASN1Encodable getBagValue() {
        return this.b;
    }

    public ASN1Set getBagAttributes() {
        return this.c;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(3);
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(new DLTaggedObject(true, 0, this.b));
        if (this.c != null) {
            aSN1EncodableVector.add(this.c);
        }
        return new DLSequence(aSN1EncodableVector);
    }
}

