/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.pkcs;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1Set;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.BERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.pkcs.ContentInfo;
import com.enterprisedt.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import java.util.Enumeration;

public class SignedData
extends ASN1Object
implements PKCSObjectIdentifiers {
    private ASN1Integer a;
    private ASN1Set b;
    private ContentInfo c;
    private ASN1Set d;
    private ASN1Set e;
    private ASN1Set f;

    public static SignedData getInstance(Object o2) {
        if (o2 instanceof SignedData) {
            return (SignedData)o2;
        }
        if (o2 != null) {
            return new SignedData(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public SignedData(ASN1Integer _version, ASN1Set _digestAlgorithms, ContentInfo _contentInfo, ASN1Set _certificates, ASN1Set _crls, ASN1Set _signerInfos) {
        this.a = _version;
        this.b = _digestAlgorithms;
        this.c = _contentInfo;
        this.d = _certificates;
        this.e = _crls;
        this.f = _signerInfos;
    }

    public SignedData(ASN1Sequence seq) {
        Enumeration enumeration = seq.getObjects();
        this.a = (ASN1Integer)enumeration.nextElement();
        this.b = (ASN1Set)enumeration.nextElement();
        this.c = ContentInfo.getInstance(enumeration.nextElement());
        while (enumeration.hasMoreElements()) {
            ASN1Primitive aSN1Primitive = (ASN1Primitive)enumeration.nextElement();
            if (aSN1Primitive instanceof ASN1TaggedObject) {
                ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)aSN1Primitive;
                switch (aSN1TaggedObject.getTagNo()) {
                    case 0: {
                        this.d = ASN1Set.getInstance(aSN1TaggedObject, false);
                        break;
                    }
                    case 1: {
                        this.e = ASN1Set.getInstance(aSN1TaggedObject, false);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown tag value " + aSN1TaggedObject.getTagNo());
                    }
                }
                continue;
            }
            this.f = (ASN1Set)aSN1Primitive;
        }
    }

    public ASN1Integer getVersion() {
        return this.a;
    }

    public ASN1Set getDigestAlgorithms() {
        return this.b;
    }

    public ContentInfo getContentInfo() {
        return this.c;
    }

    public ASN1Set getCertificates() {
        return this.d;
    }

    public ASN1Set getCRLs() {
        return this.e;
    }

    public ASN1Set getSignerInfos() {
        return this.f;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(6);
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        if (this.d != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, (ASN1Encodable)this.d));
        }
        if (this.e != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 1, (ASN1Encodable)this.e));
        }
        aSN1EncodableVector.add(this.f);
        return new BERSequence(aSN1EncodableVector);
    }
}

