/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.ua;

import com.enterprisedt.bouncycastle.math.ec.ECConstants;
import com.enterprisedt.bouncycastle.math.ec.ECCurve;
import com.enterprisedt.bouncycastle.math.ec.ECFieldElement;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import java.math.BigInteger;
import java.util.Random;

public abstract class DSTU4145PointEncoder {
    private static ECFieldElement a(ECFieldElement eCFieldElement) {
        ECFieldElement eCFieldElement2 = eCFieldElement;
        for (int i2 = 1; i2 < eCFieldElement.getFieldSize(); ++i2) {
            eCFieldElement2 = eCFieldElement2.square().add(eCFieldElement);
        }
        return eCFieldElement2;
    }

    private static ECFieldElement a(ECCurve eCCurve, ECFieldElement eCFieldElement) {
        if (eCFieldElement.isZero()) {
            return eCFieldElement;
        }
        ECFieldElement eCFieldElement2 = eCCurve.fromBigInteger(ECConstants.ZERO);
        ECFieldElement eCFieldElement3 = null;
        ECFieldElement eCFieldElement4 = null;
        Random random = new Random();
        int n2 = eCFieldElement.getFieldSize();
        do {
            ECFieldElement eCFieldElement5 = eCCurve.fromBigInteger(new BigInteger(n2, random));
            eCFieldElement3 = eCFieldElement2;
            ECFieldElement eCFieldElement6 = eCFieldElement;
            for (int i2 = 1; i2 <= n2 - 1; ++i2) {
                ECFieldElement eCFieldElement7 = eCFieldElement6.square();
                eCFieldElement3 = eCFieldElement3.square().add(eCFieldElement7.multiply(eCFieldElement5));
                eCFieldElement6 = eCFieldElement7.add(eCFieldElement);
            }
            if (eCFieldElement6.isZero()) continue;
            return null;
        } while ((eCFieldElement4 = eCFieldElement3.square().add(eCFieldElement3)).isZero());
        return eCFieldElement3;
    }

    public static byte[] encodePoint(ECPoint Q) {
        Q = Q.normalize();
        ECFieldElement eCFieldElement = Q.getAffineXCoord();
        byte[] byArray = eCFieldElement.getEncoded();
        if (!eCFieldElement.isZero()) {
            ECFieldElement eCFieldElement2 = Q.getAffineYCoord().divide(eCFieldElement);
            if (DSTU4145PointEncoder.a(eCFieldElement2).isOne()) {
                int n2 = byArray.length - 1;
                byArray[n2] = (byte)(byArray[n2] | 1);
            } else {
                int n3 = byArray.length - 1;
                byArray[n3] = (byte)(byArray[n3] & 0xFE);
            }
        }
        return byArray;
    }

    public static ECPoint decodePoint(ECCurve curve, byte[] bytes) {
        ECFieldElement eCFieldElement = curve.fromBigInteger(BigInteger.valueOf(bytes[bytes.length - 1] & 1));
        ECFieldElement eCFieldElement2 = curve.fromBigInteger(new BigInteger(1, bytes));
        if (!DSTU4145PointEncoder.a(eCFieldElement2).equals(curve.getA())) {
            eCFieldElement2 = eCFieldElement2.addOne();
        }
        ECFieldElement eCFieldElement3 = null;
        if (eCFieldElement2.isZero()) {
            eCFieldElement3 = curve.getB().sqrt();
        } else {
            ECFieldElement eCFieldElement4 = eCFieldElement2.square().invert().multiply(curve.getB()).add(curve.getA()).add(eCFieldElement2);
            ECFieldElement eCFieldElement5 = DSTU4145PointEncoder.a(curve, eCFieldElement4);
            if (eCFieldElement5 != null) {
                if (!DSTU4145PointEncoder.a(eCFieldElement5).equals(eCFieldElement)) {
                    eCFieldElement5 = eCFieldElement5.addOne();
                }
                eCFieldElement3 = eCFieldElement2.multiply(eCFieldElement5);
            }
        }
        if (eCFieldElement3 == null) {
            throw new IllegalArgumentException("Invalid point compression");
        }
        return curve.validatePoint(eCFieldElement2.toBigInteger(), eCFieldElement3.toBigInteger());
    }
}

