/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x509;

import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.util.BigIntegers;
import java.math.BigInteger;

public class CRLNumber
extends ASN1Object {
    private BigInteger a;

    public CRLNumber(BigInteger number) {
        if (BigIntegers.ZERO.compareTo(number) > 0) {
            throw new IllegalArgumentException("Invalid CRL number : not in (0..MAX)");
        }
        this.a = number;
    }

    public BigInteger getCRLNumber() {
        return this.a;
    }

    public String toString() {
        return "CRLNumber: " + this.getCRLNumber();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new ASN1Integer(this.a);
    }

    public static CRLNumber getInstance(Object o2) {
        if (o2 instanceof CRLNumber) {
            return (CRLNumber)o2;
        }
        if (o2 != null) {
            return new CRLNumber(ASN1Integer.getInstance(o2).getValue());
        }
        return null;
    }
}

