/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x509;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.x509.Certificate;
import java.util.Enumeration;

public class CertificatePair
extends ASN1Object {
    private Certificate a;
    private Certificate b;

    public static CertificatePair getInstance(Object obj) {
        if (obj == null || obj instanceof CertificatePair) {
            return (CertificatePair)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new CertificatePair((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    private CertificatePair(ASN1Sequence seq) {
        if (seq.size() != 1 && seq.size() != 2) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        Enumeration enumeration = seq.getObjects();
        while (enumeration.hasMoreElements()) {
            ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(enumeration.nextElement());
            if (aSN1TaggedObject.getTagNo() == 0) {
                this.a = Certificate.getInstance(aSN1TaggedObject, true);
                continue;
            }
            if (aSN1TaggedObject.getTagNo() == 1) {
                this.b = Certificate.getInstance(aSN1TaggedObject, true);
                continue;
            }
            throw new IllegalArgumentException("Bad tag number: " + aSN1TaggedObject.getTagNo());
        }
    }

    public CertificatePair(Certificate forward, Certificate reverse) {
        this.a = forward;
        this.b = reverse;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(2);
        if (this.a != null) {
            aSN1EncodableVector.add(new DERTaggedObject(0, this.a));
        }
        if (this.b != null) {
            aSN1EncodableVector.add(new DERTaggedObject(1, this.b));
        }
        return new DERSequence(aSN1EncodableVector);
    }

    public Certificate getForward() {
        return this.a;
    }

    public Certificate getReverse() {
        return this.b;
    }
}

