/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x509;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.x509.Extension;
import com.enterprisedt.bouncycastle.asn1.x509.Extensions;
import com.enterprisedt.bouncycastle.asn1.x509.KeyPurposeId;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ExtendedKeyUsage
extends ASN1Object {
    Hashtable a = new Hashtable();
    ASN1Sequence b;

    public static ExtendedKeyUsage getInstance(ASN1TaggedObject obj, boolean explicit) {
        return ExtendedKeyUsage.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static ExtendedKeyUsage getInstance(Object obj) {
        if (obj instanceof ExtendedKeyUsage) {
            return (ExtendedKeyUsage)obj;
        }
        if (obj != null) {
            return new ExtendedKeyUsage(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public static ExtendedKeyUsage fromExtensions(Extensions extensions) {
        return ExtendedKeyUsage.getInstance(Extensions.getExtensionParsedValue(extensions, Extension.extendedKeyUsage));
    }

    public ExtendedKeyUsage(KeyPurposeId usage) {
        this.b = new DERSequence(usage);
        this.a.put(usage, usage);
    }

    private ExtendedKeyUsage(ASN1Sequence seq) {
        this.b = seq;
        Enumeration enumeration = seq.getObjects();
        while (enumeration.hasMoreElements()) {
            ASN1Encodable aSN1Encodable = (ASN1Encodable)enumeration.nextElement();
            if (!(aSN1Encodable.toASN1Primitive() instanceof ASN1ObjectIdentifier)) {
                throw new IllegalArgumentException("Only ASN1ObjectIdentifiers allowed in ExtendedKeyUsage.");
            }
            this.a.put(aSN1Encodable, aSN1Encodable);
        }
    }

    public ExtendedKeyUsage(KeyPurposeId[] usages) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(usages.length);
        for (int i2 = 0; i2 != usages.length; ++i2) {
            aSN1EncodableVector.add(usages[i2]);
            this.a.put(usages[i2], usages[i2]);
        }
        this.b = new DERSequence(aSN1EncodableVector);
    }

    public ExtendedKeyUsage(Vector usages) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(usages.size());
        Enumeration enumeration = usages.elements();
        while (enumeration.hasMoreElements()) {
            KeyPurposeId keyPurposeId = KeyPurposeId.getInstance(enumeration.nextElement());
            aSN1EncodableVector.add(keyPurposeId);
            this.a.put(keyPurposeId, keyPurposeId);
        }
        this.b = new DERSequence(aSN1EncodableVector);
    }

    public boolean hasKeyPurposeId(KeyPurposeId keyPurposeId) {
        return this.a.get(keyPurposeId) != null;
    }

    public KeyPurposeId[] getUsages() {
        KeyPurposeId[] keyPurposeIdArray = new KeyPurposeId[this.b.size()];
        int n2 = 0;
        Enumeration enumeration = this.b.getObjects();
        while (enumeration.hasMoreElements()) {
            keyPurposeIdArray[n2++] = KeyPurposeId.getInstance(enumeration.nextElement());
        }
        return keyPurposeIdArray;
    }

    public int size() {
        return this.a.size();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.b;
    }
}

