/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x509;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.x509.Extension;
import com.enterprisedt.bouncycastle.util.Properties;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Extensions
extends ASN1Object {
    private Hashtable a = new Hashtable();
    private Vector b = new Vector();

    public static Extension getExtension(Extensions extensions, ASN1ObjectIdentifier oid) {
        return null == extensions ? null : extensions.getExtension(oid);
    }

    public static ASN1Encodable getExtensionParsedValue(Extensions extensions, ASN1ObjectIdentifier oid) {
        return null == extensions ? null : extensions.getExtensionParsedValue(oid);
    }

    public static Extensions getInstance(ASN1TaggedObject obj, boolean explicit) {
        return Extensions.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static Extensions getInstance(Object obj) {
        if (obj instanceof Extensions) {
            return (Extensions)obj;
        }
        if (obj != null) {
            return new Extensions(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private Extensions(ASN1Sequence seq) {
        if (seq.size() == 0) {
            throw new IllegalArgumentException("empty extension sequence found");
        }
        Enumeration enumeration = seq.getObjects();
        while (enumeration.hasMoreElements()) {
            Extension extension = Extension.getInstance(enumeration.nextElement());
            if (this.a.containsKey(extension.getExtnId()) && !Properties.isOverrideSet("com.enterprisedt.bouncycastle.x509.ignore_repeated_extensions")) {
                throw new IllegalArgumentException("repeated extension found: " + extension.getExtnId());
            }
            this.a.put(extension.getExtnId(), extension);
            this.b.addElement(extension.getExtnId());
        }
    }

    public Extensions(Extension extension) {
        this.b.addElement(extension.getExtnId());
        this.a.put(extension.getExtnId(), extension);
    }

    public Extensions(Extension[] extensions) {
        if (extensions == null || extensions.length == 0) {
            throw new IllegalArgumentException("extension array cannot be null or empty");
        }
        for (int i2 = 0; i2 != extensions.length; ++i2) {
            Extension extension = extensions[i2];
            this.b.addElement(extension.getExtnId());
            this.a.put(extension.getExtnId(), extension);
        }
    }

    public Enumeration oids() {
        return this.b.elements();
    }

    public Extension getExtension(ASN1ObjectIdentifier oid) {
        return (Extension)this.a.get(oid);
    }

    public ASN1Encodable getExtensionParsedValue(ASN1ObjectIdentifier oid) {
        Extension extension = this.getExtension(oid);
        if (extension != null) {
            return extension.getParsedValue();
        }
        return null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(this.b.size());
        Enumeration enumeration = this.b.elements();
        while (enumeration.hasMoreElements()) {
            ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)enumeration.nextElement();
            Extension extension = (Extension)this.a.get(aSN1ObjectIdentifier);
            aSN1EncodableVector.add(extension);
        }
        return new DERSequence(aSN1EncodableVector);
    }

    public boolean equivalent(Extensions other) {
        if (this.a.size() != other.a.size()) {
            return false;
        }
        Enumeration enumeration = this.a.keys();
        while (enumeration.hasMoreElements()) {
            Object k2 = enumeration.nextElement();
            if (this.a.get(k2).equals(other.a.get(k2))) continue;
            return false;
        }
        return true;
    }

    public ASN1ObjectIdentifier[] getExtensionOIDs() {
        return this.a(this.b);
    }

    public ASN1ObjectIdentifier[] getNonCriticalExtensionOIDs() {
        return this.a(false);
    }

    public ASN1ObjectIdentifier[] getCriticalExtensionOIDs() {
        return this.a(true);
    }

    private ASN1ObjectIdentifier[] a(boolean bl) {
        Vector vector = new Vector();
        for (int i2 = 0; i2 != this.b.size(); ++i2) {
            Object e2 = this.b.elementAt(i2);
            if (((Extension)this.a.get(e2)).isCritical() != bl) continue;
            vector.addElement(e2);
        }
        return this.a(vector);
    }

    private ASN1ObjectIdentifier[] a(Vector vector) {
        ASN1ObjectIdentifier[] aSN1ObjectIdentifierArray = new ASN1ObjectIdentifier[vector.size()];
        for (int i2 = 0; i2 != aSN1ObjectIdentifierArray.length; ++i2) {
            aSN1ObjectIdentifierArray[i2] = (ASN1ObjectIdentifier)vector.elementAt(i2);
        }
        return aSN1ObjectIdentifierArray;
    }
}

