/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x509;

import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.x509.Extensions;
import com.enterprisedt.bouncycastle.asn1.x509.GeneralName;
import com.enterprisedt.bouncycastle.util.Strings;

public class GeneralNames
extends ASN1Object {
    private final GeneralName[] a;

    private static GeneralName[] a(GeneralName[] generalNameArray) {
        GeneralName[] generalNameArray2 = new GeneralName[generalNameArray.length];
        System.arraycopy(generalNameArray, 0, generalNameArray2, 0, generalNameArray.length);
        return generalNameArray2;
    }

    public static GeneralNames getInstance(Object obj) {
        if (obj instanceof GeneralNames) {
            return (GeneralNames)obj;
        }
        if (obj != null) {
            return new GeneralNames(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public static GeneralNames getInstance(ASN1TaggedObject obj, boolean explicit) {
        return new GeneralNames(ASN1Sequence.getInstance(obj, explicit));
    }

    public static GeneralNames fromExtensions(Extensions extensions, ASN1ObjectIdentifier extOID) {
        return GeneralNames.getInstance(Extensions.getExtensionParsedValue(extensions, extOID));
    }

    public GeneralNames(GeneralName name) {
        this.a = new GeneralName[]{name};
    }

    public GeneralNames(GeneralName[] names) {
        this.a = GeneralNames.a(names);
    }

    private GeneralNames(ASN1Sequence seq) {
        this.a = new GeneralName[seq.size()];
        for (int i2 = 0; i2 != seq.size(); ++i2) {
            this.a[i2] = GeneralName.getInstance(seq.getObjectAt(i2));
        }
    }

    public GeneralName[] getNames() {
        return GeneralNames.a(this.a);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(this.a);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = Strings.lineSeparator();
        stringBuffer.append("GeneralNames:");
        stringBuffer.append(string);
        for (int i2 = 0; i2 != this.a.length; ++i2) {
            stringBuffer.append("    ");
            stringBuffer.append(this.a[i2]);
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

