/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x9;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.x9.X9Curve;
import com.enterprisedt.bouncycastle.asn1.x9.X9ECPoint;
import com.enterprisedt.bouncycastle.asn1.x9.X9FieldID;
import com.enterprisedt.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.enterprisedt.bouncycastle.math.ec.ECAlgorithms;
import com.enterprisedt.bouncycastle.math.ec.ECCurve;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.bouncycastle.math.field.PolynomialExtensionField;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class X9ECParameters
extends ASN1Object
implements X9ObjectIdentifiers {
    private static final BigInteger a = BigInteger.valueOf(1L);
    private X9FieldID b;
    private ECCurve c;
    private X9ECPoint d;
    private BigInteger e;
    private BigInteger f;
    private byte[] g;

    private X9ECParameters(ASN1Sequence seq) {
        if (!(seq.getObjectAt(0) instanceof ASN1Integer) || !((ASN1Integer)seq.getObjectAt(0)).hasValue(1)) {
            throw new IllegalArgumentException("bad version in X9ECParameters");
        }
        this.e = ((ASN1Integer)seq.getObjectAt(4)).getValue();
        if (seq.size() == 6) {
            this.f = ((ASN1Integer)seq.getObjectAt(5)).getValue();
        }
        X9Curve x9Curve = new X9Curve(X9FieldID.getInstance(seq.getObjectAt(1)), this.e, this.f, ASN1Sequence.getInstance(seq.getObjectAt(2)));
        this.c = x9Curve.getCurve();
        ASN1Encodable aSN1Encodable = seq.getObjectAt(3);
        this.d = aSN1Encodable instanceof X9ECPoint ? (X9ECPoint)aSN1Encodable : new X9ECPoint(this.c, (ASN1OctetString)aSN1Encodable);
        this.g = x9Curve.getSeed();
    }

    public static X9ECParameters getInstance(Object obj) {
        if (obj instanceof X9ECParameters) {
            return (X9ECParameters)obj;
        }
        if (obj != null) {
            return new X9ECParameters(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public X9ECParameters(ECCurve curve, X9ECPoint g2, BigInteger n2) {
        this(curve, g2, n2, null, null);
    }

    public X9ECParameters(ECCurve curve, X9ECPoint g2, BigInteger n2, BigInteger h2) {
        this(curve, g2, n2, h2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public X9ECParameters(ECCurve curve, X9ECPoint g2, BigInteger n2, BigInteger h2, byte[] seed) {
        this.c = curve;
        this.d = g2;
        this.e = n2;
        this.f = h2;
        this.g = Arrays.clone(seed);
        if (ECAlgorithms.isFpCurve(curve)) {
            this.b = new X9FieldID(curve.getField().getCharacteristic());
            return;
        } else {
            if (!ECAlgorithms.isF2mCurve(curve)) throw new IllegalArgumentException("'curve' is of an unsupported type");
            PolynomialExtensionField polynomialExtensionField = (PolynomialExtensionField)curve.getField();
            int[] nArray = polynomialExtensionField.getMinimalPolynomial().getExponentsPresent();
            if (nArray.length == 3) {
                this.b = new X9FieldID(nArray[2], nArray[1]);
                return;
            } else {
                if (nArray.length != 5) throw new IllegalArgumentException("Only trinomial and pentomial curves are supported");
                this.b = new X9FieldID(nArray[4], nArray[1], nArray[2], nArray[3]);
            }
        }
    }

    public ECCurve getCurve() {
        return this.c;
    }

    public ECPoint getG() {
        return this.d.getPoint();
    }

    public BigInteger getN() {
        return this.e;
    }

    public BigInteger getH() {
        return this.f;
    }

    public byte[] getSeed() {
        return Arrays.clone(this.g);
    }

    public boolean hasSeed() {
        return null != this.g;
    }

    public X9Curve getCurveEntry() {
        return new X9Curve(this.c, this.g);
    }

    public X9FieldID getFieldIDEntry() {
        return this.b;
    }

    public X9ECPoint getBaseEntry() {
        return this.d;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(6);
        aSN1EncodableVector.add(new ASN1Integer(a));
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(new X9Curve(this.c, this.g));
        aSN1EncodableVector.add(this.d);
        aSN1EncodableVector.add(new ASN1Integer(this.e));
        if (this.f != null) {
            aSN1EncodableVector.add(new ASN1Integer(this.f));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

