/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto;

import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.KeyGenerationParameters;
import com.enterprisedt.bouncycastle.crypto.constraints.DefaultServiceProperties;
import java.security.SecureRandom;

public class CipherKeyGenerator {
    protected SecureRandom random;
    protected int strength;

    public void init(KeyGenerationParameters param) {
        this.random = param.getRandom();
        this.strength = (param.getStrength() + 7) / 8;
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("SymKeyGen", param.getStrength()));
    }

    public byte[] generateKey() {
        byte[] byArray = new byte[this.strength];
        this.random.nextBytes(byArray);
        return byArray;
    }
}

