/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.util.Strings;

public abstract class PBEParametersGenerator {
    protected byte[] password;
    protected byte[] salt;
    protected int iterationCount;

    protected PBEParametersGenerator() {
    }

    public void init(byte[] password, byte[] salt, int iterationCount) {
        this.password = password;
        this.salt = salt;
        this.iterationCount = iterationCount;
    }

    public byte[] getPassword() {
        return this.password;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    public abstract CipherParameters generateDerivedParameters(int var1);

    public abstract CipherParameters generateDerivedParameters(int var1, int var2);

    public abstract CipherParameters generateDerivedMacParameters(int var1);

    public static byte[] PKCS5PasswordToBytes(char[] password) {
        if (password != null) {
            byte[] byArray = new byte[password.length];
            for (int i2 = 0; i2 != byArray.length; ++i2) {
                byArray[i2] = (byte)password[i2];
            }
            return byArray;
        }
        return new byte[0];
    }

    public static byte[] PKCS5PasswordToUTF8Bytes(char[] password) {
        if (password != null) {
            return Strings.toUTF8ByteArray(password);
        }
        return new byte[0];
    }

    public static byte[] PKCS12PasswordToBytes(char[] password) {
        if (password != null && password.length > 0) {
            byte[] byArray = new byte[(password.length + 1) * 2];
            for (int i2 = 0; i2 != password.length; ++i2) {
                byArray[i2 * 2] = (byte)(password[i2] >>> 8);
                byArray[i2 * 2 + 1] = (byte)password[i2];
            }
            return byArray;
        }
        return new byte[0];
    }
}

