/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.agreement.jpake;

import com.enterprisedt.bouncycastle.crypto.agreement.jpake.JPAKEUtil;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class JPAKERound2Payload {
    private final String a;
    private final BigInteger b;
    private final BigInteger[] c;

    public JPAKERound2Payload(String participantId, BigInteger a2, BigInteger[] knowledgeProofForX2s) {
        JPAKEUtil.validateNotNull(participantId, "participantId");
        JPAKEUtil.validateNotNull(a2, "a");
        JPAKEUtil.validateNotNull(knowledgeProofForX2s, "knowledgeProofForX2s");
        this.a = participantId;
        this.b = a2;
        this.c = Arrays.copyOf(knowledgeProofForX2s, knowledgeProofForX2s.length);
    }

    public String getParticipantId() {
        return this.a;
    }

    public BigInteger getA() {
        return this.b;
    }

    public BigInteger[] getKnowledgeProofForX2s() {
        return Arrays.copyOf(this.c, this.c.length);
    }
}

