/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.agreement.kdf;

import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.DerivationParameters;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.DigestDerivationFunction;
import com.enterprisedt.bouncycastle.crypto.agreement.kdf.GSKKDFParameters;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Pack;

public class GSKKFDGenerator
implements DigestDerivationFunction {
    private final Digest a;
    private byte[] b;
    private int c;
    private byte[] d;
    private byte[] e;

    public GSKKFDGenerator(Digest digest) {
        this.a = digest;
        this.e = new byte[digest.getDigestSize()];
    }

    @Override
    public Digest getDigest() {
        return this.a;
    }

    @Override
    public void init(DerivationParameters param) {
        if (!(param instanceof GSKKDFParameters)) {
            throw new IllegalArgumentException("unkown parameters type");
        }
        this.b = ((GSKKDFParameters)param).getZ();
        this.c = ((GSKKDFParameters)param).getStartCounter();
        this.d = ((GSKKDFParameters)param).getNonce();
    }

    @Override
    public int generateBytes(byte[] out, int outOff, int len) throws DataLengthException, IllegalArgumentException {
        if (outOff + len > out.length) {
            throw new DataLengthException("output buffer too small");
        }
        this.a.update(this.b, 0, this.b.length);
        byte[] byArray = Pack.intToBigEndian(this.c++);
        this.a.update(byArray, 0, byArray.length);
        if (this.d != null) {
            this.a.update(this.d, 0, this.d.length);
        }
        this.a.doFinal(this.e, 0);
        System.arraycopy(this.e, 0, out, outOff, len);
        Arrays.clear(this.e);
        return len;
    }
}

