/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.constraints;

import com.enterprisedt.bouncycastle.math.ec.ECCurve;
import java.math.BigInteger;

public class ConstraintUtils {
    public static int bitsOfSecurityFor(BigInteger p2) {
        return ConstraintUtils.bitsOfSecurityForFF(p2.bitLength());
    }

    public static int bitsOfSecurityFor(ECCurve curve) {
        int n2 = (curve.getFieldSize() + 1) / 2;
        return n2 > 256 ? 256 : n2;
    }

    public static int bitsOfSecurityForFF(int strength) {
        if (strength >= 2048) {
            return strength >= 3072 ? (strength >= 7680 ? (strength >= 15360 ? 256 : 192) : 128) : 112;
        }
        return strength >= 1024 ? 80 : 20;
    }
}

