/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.digests;

import com.enterprisedt.bouncycastle.crypto.CryptoServicePurpose;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.Xof;
import com.enterprisedt.bouncycastle.crypto.digests.Blake2sDigest;
import com.enterprisedt.bouncycastle.util.Arrays;

public class Blake2xsDigest
implements Xof {
    public static final int UNKNOWN_DIGEST_LENGTH = 65535;
    private int a;
    private Blake2sDigest b;
    private byte[] c = null;
    private byte[] d = new byte[32];
    private int e = 32;
    private int f = 0;
    private long g = 0L;
    private long h;
    private final CryptoServicePurpose i;

    public Blake2xsDigest() {
        this(65535, CryptoServicePurpose.ANY);
    }

    public Blake2xsDigest(int digestBytes, CryptoServicePurpose purpose) {
        this(digestBytes, null, null, null, purpose);
    }

    public Blake2xsDigest(int digestBytes) {
        this(digestBytes, CryptoServicePurpose.ANY);
    }

    public Blake2xsDigest(int digestBytes, byte[] key) {
        this(digestBytes, key, null, null, CryptoServicePurpose.ANY);
    }

    public Blake2xsDigest(int digestBytes, byte[] key, byte[] salt, byte[] personalization, CryptoServicePurpose purpose) {
        if (digestBytes < 1 || digestBytes > 65535) {
            throw new IllegalArgumentException("BLAKE2xs digest length must be between 1 and 2^16-1");
        }
        this.a = digestBytes;
        this.h = this.b();
        this.i = purpose;
        this.b = new Blake2sDigest(32, key, salt, personalization, this.h, purpose);
    }

    public Blake2xsDigest(Blake2xsDigest digest) {
        this.a = digest.a;
        this.b = new Blake2sDigest(digest.b);
        this.c = Arrays.clone(digest.c);
        this.d = Arrays.clone(digest.d);
        this.e = digest.e;
        this.f = digest.f;
        this.g = digest.g;
        this.h = digest.h;
        this.i = digest.i;
    }

    @Override
    public String getAlgorithmName() {
        return "BLAKE2xs";
    }

    @Override
    public int getDigestSize() {
        return this.a;
    }

    @Override
    public int getByteLength() {
        return this.b.getByteLength();
    }

    public long getUnknownMaxLength() {
        return 0x2000000000L;
    }

    @Override
    public void update(byte in) {
        this.b.update(in);
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        this.b.update(in, inOff, len);
    }

    @Override
    public void reset() {
        this.b.reset();
        this.c = null;
        this.e = 32;
        this.f = 0;
        this.g = 0L;
        this.h = this.b();
    }

    @Override
    public int doFinal(byte[] out, int outOffset) {
        return this.doFinal(out, outOffset, this.a);
    }

    @Override
    public int doFinal(byte[] out, int outOff, int outLen) {
        int n2 = this.doOutput(out, outOff, outLen);
        this.reset();
        return n2;
    }

    @Override
    public int doOutput(byte[] out, int outOff, int outLen) {
        if (outOff > out.length - outLen) {
            throw new OutputLengthException("output buffer too short");
        }
        if (this.c == null) {
            this.c = new byte[this.b.getDigestSize()];
            this.b.doFinal(this.c, 0);
        }
        if (this.a != 65535) {
            if (this.f + outLen > this.a) {
                throw new IllegalArgumentException("Output length is above the digest length");
            }
        } else if (this.g << 5 >= this.getUnknownMaxLength()) {
            throw new IllegalArgumentException("Maximum length is 2^32 blocks of 32 bytes");
        }
        for (int i2 = 0; i2 < outLen; ++i2) {
            if (this.e >= 32) {
                Blake2sDigest blake2sDigest = new Blake2sDigest(this.a(), 32, this.h);
                blake2sDigest.update(this.c, 0, this.c.length);
                Arrays.fill(this.d, (byte)0);
                blake2sDigest.doFinal(this.d, 0);
                this.e = 0;
                ++this.h;
                ++this.g;
            }
            out[outOff + i2] = this.d[this.e];
            ++this.e;
            ++this.f;
        }
        return outLen;
    }

    private int a() {
        if (this.a == 65535) {
            return 32;
        }
        return Math.min(32, this.a - this.f);
    }

    private long b() {
        return (long)this.a * 0x100000000L;
    }
}

