/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.digests;

import com.enterprisedt.bouncycastle.crypto.CryptoServicePurpose;
import com.enterprisedt.bouncycastle.crypto.digests.SHAKEDigest;
import com.enterprisedt.bouncycastle.crypto.digests.XofUtils;
import com.enterprisedt.bouncycastle.util.Arrays;

public class CSHAKEDigest
extends SHAKEDigest {
    private static final byte[] a = new byte[100];
    private final byte[] b;

    public CSHAKEDigest(int bitLength, byte[] N, byte[] S) {
        this(bitLength, CryptoServicePurpose.ANY, N, S);
    }

    public CSHAKEDigest(int bitLength, CryptoServicePurpose purpose, byte[] N, byte[] S) {
        super(bitLength, purpose);
        if (!(N != null && N.length != 0 || S != null && S.length != 0)) {
            this.b = null;
        } else {
            this.b = Arrays.concatenate(XofUtils.leftEncode(this.rate / 8), this.a(N), this.a(S));
            this.a();
        }
    }

    public CSHAKEDigest(CSHAKEDigest source) {
        super(source);
        this.b = Arrays.clone(source.b);
    }

    private void a() {
        int n2 = this.rate / 8;
        this.absorb(this.b, 0, this.b.length);
        int n3 = this.b.length % n2;
        if (n3 != 0) {
            int n4;
            for (n4 = n2 - n3; n4 > a.length; n4 -= a.length) {
                this.absorb(a, 0, a.length);
            }
            this.absorb(a, 0, n4);
        }
    }

    private byte[] a(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return XofUtils.leftEncode(0L);
        }
        return Arrays.concatenate(XofUtils.leftEncode((long)byArray.length * 8L), byArray);
    }

    @Override
    public String getAlgorithmName() {
        return "CSHAKE" + this.fixedOutputLength;
    }

    @Override
    public int doOutput(byte[] out, int outOff, int outLen) {
        if (this.b != null) {
            if (!this.squeezing) {
                this.absorbBits(0, 2);
            }
            this.squeeze(out, outOff, (long)outLen * 8L);
            return outLen;
        }
        return super.doOutput(out, outOff, outLen);
    }

    @Override
    public void reset() {
        super.reset();
        if (this.b != null) {
            this.a();
        }
    }
}

