/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.digests;

import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.Xof;
import com.enterprisedt.bouncycastle.crypto.digests.CSHAKEDigest;
import com.enterprisedt.bouncycastle.crypto.digests.XofUtils;
import com.enterprisedt.bouncycastle.util.Strings;

public class TupleHash
implements Digest,
Xof {
    private static final byte[] a = Strings.toByteArray("TupleHash");
    private final CSHAKEDigest b;
    private final int c;
    private final int d;
    private boolean e;

    public TupleHash(int bitLength, byte[] S) {
        this(bitLength, S, bitLength * 2);
    }

    public TupleHash(int bitLength, byte[] S, int outputSize) {
        this.b = new CSHAKEDigest(bitLength, a, S);
        this.c = bitLength;
        this.d = (outputSize + 7) / 8;
        this.reset();
    }

    public TupleHash(TupleHash original) {
        this.b = new CSHAKEDigest(original.b);
        this.c = this.b.fixedOutputLength;
        this.d = this.c * 2 / 8;
        this.e = original.e;
    }

    @Override
    public String getAlgorithmName() {
        return "TupleHash" + this.b.getAlgorithmName().substring(6);
    }

    @Override
    public int getByteLength() {
        return this.b.getByteLength();
    }

    @Override
    public int getDigestSize() {
        return this.d;
    }

    @Override
    public void update(byte in) throws IllegalStateException {
        byte[] byArray = XofUtils.a(in);
        this.b.update(byArray, 0, byArray.length);
    }

    @Override
    public void update(byte[] in, int inOff, int len) throws DataLengthException, IllegalStateException {
        byte[] byArray = XofUtils.a(in, inOff, len);
        this.b.update(byArray, 0, byArray.length);
    }

    private void a(int n2) {
        byte[] byArray = XofUtils.rightEncode((long)n2 * 8L);
        this.b.update(byArray, 0, byArray.length);
        this.e = false;
    }

    @Override
    public int doFinal(byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        if (this.e) {
            this.a(this.getDigestSize());
        }
        int n2 = this.b.doFinal(out, outOff, this.getDigestSize());
        this.reset();
        return n2;
    }

    @Override
    public int doFinal(byte[] out, int outOff, int outLen) {
        if (this.e) {
            this.a(this.getDigestSize());
        }
        int n2 = this.b.doFinal(out, outOff, outLen);
        this.reset();
        return n2;
    }

    @Override
    public int doOutput(byte[] out, int outOff, int outLen) {
        if (this.e) {
            this.a(0);
        }
        return this.b.doOutput(out, outOff, outLen);
    }

    @Override
    public void reset() {
        this.b.reset();
        this.e = true;
    }
}

