/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.engines;

import com.enterprisedt.bouncycastle.crypto.BasicAgreement;
import com.enterprisedt.bouncycastle.crypto.BufferedBlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.DerivationFunction;
import com.enterprisedt.bouncycastle.crypto.DerivationParameters;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.DigestDerivationFunction;
import com.enterprisedt.bouncycastle.crypto.EphemeralKeyPair;
import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.KeyParser;
import com.enterprisedt.bouncycastle.crypto.Mac;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.SavableDigest;
import com.enterprisedt.bouncycastle.crypto.digests.SHA256Digest;
import com.enterprisedt.bouncycastle.crypto.generators.EphemeralKeyPairGenerator;
import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.IESParameters;
import com.enterprisedt.bouncycastle.crypto.params.IESWithCipherParameters;
import com.enterprisedt.bouncycastle.crypto.params.ISO18033KDFParameters;
import com.enterprisedt.bouncycastle.crypto.params.KDFParameters;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.BigIntegers;
import com.enterprisedt.bouncycastle.util.Pack;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class EthereumIESEngine {
    BasicAgreement a;
    DerivationFunction b;
    Mac c;
    BufferedBlockCipher d;
    byte[] e;
    byte[] f;
    boolean g;
    CipherParameters h;
    CipherParameters i;
    IESParameters j;
    byte[] k;
    private EphemeralKeyPairGenerator l;
    private KeyParser m;
    private byte[] n;

    public EthereumIESEngine(BasicAgreement agree, DerivationFunction kdf, Mac mac, byte[] commonMac) {
        this.a = agree;
        this.b = kdf;
        this.c = mac;
        this.e = new byte[mac.getMacSize()];
        this.f = commonMac;
        this.d = null;
    }

    public EthereumIESEngine(BasicAgreement agree, DerivationFunction kdf, Mac mac, byte[] commonMac, BufferedBlockCipher cipher) {
        this.a = agree;
        this.b = kdf;
        this.c = mac;
        this.e = new byte[mac.getMacSize()];
        this.f = commonMac;
        this.d = cipher;
    }

    public void init(boolean forEncryption, CipherParameters privParam, CipherParameters pubParam, CipherParameters params) {
        this.g = forEncryption;
        this.h = privParam;
        this.i = pubParam;
        this.k = new byte[0];
        this.a(params);
    }

    public void init(AsymmetricKeyParameter publicKey, CipherParameters params, EphemeralKeyPairGenerator ephemeralKeyPairGenerator) {
        this.g = true;
        this.i = publicKey;
        this.l = ephemeralKeyPairGenerator;
        this.a(params);
    }

    public void init(AsymmetricKeyParameter privateKey, CipherParameters params, KeyParser publicKeyParser) {
        this.g = false;
        this.h = privateKey;
        this.m = publicKeyParser;
        this.a(params);
    }

    private void a(CipherParameters cipherParameters) {
        if (cipherParameters instanceof ParametersWithIV) {
            this.n = ((ParametersWithIV)cipherParameters).getIV();
            this.j = (IESParameters)((ParametersWithIV)cipherParameters).getParameters();
        } else {
            this.n = null;
            this.j = (IESParameters)cipherParameters;
        }
    }

    public BufferedBlockCipher getCipher() {
        return this.d;
    }

    public Mac getMac() {
        return this.c;
    }

    private byte[] a(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        int n4;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        byte[] byArray5 = null;
        if (this.d == null) {
            byArray4 = new byte[n3];
            byArray5 = new byte[this.j.getMacKeySize() / 8];
            byArray3 = new byte[byArray4.length + byArray5.length];
            this.b.generateBytes(byArray3, 0, byArray3.length);
            if (this.k.length != 0) {
                System.arraycopy(byArray3, 0, byArray5, 0, byArray5.length);
                System.arraycopy(byArray3, byArray5.length, byArray4, 0, byArray4.length);
            } else {
                System.arraycopy(byArray3, 0, byArray4, 0, byArray4.length);
                System.arraycopy(byArray3, n3, byArray5, 0, byArray5.length);
            }
            byArray2 = new byte[n3];
            for (int i2 = 0; i2 != n3; ++i2) {
                byArray2[i2] = (byte)(byArray[n2 + i2] ^ byArray4[i2]);
            }
            n4 = n3;
        } else {
            byArray4 = new byte[((IESWithCipherParameters)this.j).getCipherKeySize() / 8];
            byArray5 = new byte[this.j.getMacKeySize() / 8];
            byArray3 = new byte[byArray4.length + byArray5.length];
            this.b.generateBytes(byArray3, 0, byArray3.length);
            System.arraycopy(byArray3, 0, byArray4, 0, byArray4.length);
            System.arraycopy(byArray3, byArray4.length, byArray5, 0, byArray5.length);
            if (this.n != null) {
                this.d.init(true, new ParametersWithIV(new KeyParameter(byArray4), this.n));
            } else {
                this.d.init(true, new KeyParameter(byArray4));
            }
            byArray2 = new byte[this.d.getOutputSize(n3)];
            n4 = this.d.processBytes(byArray, n2, n3, byArray2, 0);
            n4 += this.d.doFinal(byArray2, n4);
        }
        byte[] byArray6 = this.j.getEncodingV();
        byte[] byArray7 = null;
        if (this.k.length != 0) {
            byArray7 = this.getLengthTag(byArray6);
        }
        byte[] byArray8 = new byte[this.c.getMacSize()];
        SavableDigest savableDigest = SHA256Digest.newInstance();
        byte[] byArray9 = new byte[savableDigest.getDigestSize()];
        savableDigest.reset();
        savableDigest.update(byArray5, 0, byArray5.length);
        savableDigest.doFinal(byArray9, 0);
        this.c.init(new KeyParameter(byArray9));
        this.c.update(this.n, 0, this.n.length);
        this.c.update(byArray2, 0, byArray2.length);
        if (byArray6 != null) {
            this.c.update(byArray6, 0, byArray6.length);
        }
        if (this.k.length != 0) {
            this.c.update(byArray7, 0, byArray7.length);
        }
        this.c.update(this.f, 0, this.f.length);
        this.c.doFinal(byArray8, 0);
        byte[] byArray10 = new byte[this.k.length + n4 + byArray8.length];
        System.arraycopy(this.k, 0, byArray10, 0, this.k.length);
        System.arraycopy(byArray2, 0, byArray10, this.k.length, n4);
        System.arraycopy(byArray8, 0, byArray10, this.k.length + n4, byArray8.length);
        return byArray10;
    }

    private byte[] b(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        byte[] byArray2;
        byte[] byArray3;
        int n4 = 0;
        if (n3 < this.k.length + this.c.getMacSize()) {
            throw new InvalidCipherTextException("length of input must be greater than the MAC and V combined");
        }
        if (this.d == null) {
            byte[] byArray4 = new byte[n3 - this.k.length - this.c.getMacSize()];
            byArray3 = new byte[this.j.getMacKeySize() / 8];
            byte[] byArray5 = new byte[byArray4.length + byArray3.length];
            this.b.generateBytes(byArray5, 0, byArray5.length);
            if (this.k.length != 0) {
                System.arraycopy(byArray5, 0, byArray3, 0, byArray3.length);
                System.arraycopy(byArray5, byArray3.length, byArray4, 0, byArray4.length);
            } else {
                System.arraycopy(byArray5, 0, byArray4, 0, byArray4.length);
                System.arraycopy(byArray5, byArray4.length, byArray3, 0, byArray3.length);
            }
            byArray2 = new byte[byArray4.length];
            for (int i2 = 0; i2 != byArray4.length; ++i2) {
                byArray2[i2] = (byte)(byArray[n2 + this.k.length + i2] ^ byArray4[i2]);
            }
        } else {
            byte[] byArray6 = new byte[((IESWithCipherParameters)this.j).getCipherKeySize() / 8];
            byArray3 = new byte[this.j.getMacKeySize() / 8];
            byte[] byArray7 = new byte[byArray6.length + byArray3.length];
            this.b.generateBytes(byArray7, 0, byArray7.length);
            System.arraycopy(byArray7, 0, byArray6, 0, byArray6.length);
            System.arraycopy(byArray7, byArray6.length, byArray3, 0, byArray3.length);
            CipherParameters cipherParameters = new KeyParameter(byArray6);
            if (this.n != null) {
                cipherParameters = new ParametersWithIV(cipherParameters, this.n);
            }
            this.d.init(false, cipherParameters);
            byArray2 = new byte[this.d.getOutputSize(n3 - this.k.length - this.c.getMacSize())];
            n4 = this.d.processBytes(byArray, n2 + this.k.length, n3 - this.k.length - this.c.getMacSize(), byArray2, 0);
        }
        byte[] byArray8 = this.j.getEncodingV();
        byte[] byArray9 = null;
        if (this.k.length != 0) {
            byArray9 = this.getLengthTag(byArray8);
        }
        int n5 = n2 + n3;
        byte[] byArray10 = Arrays.copyOfRange(byArray, n5 - this.c.getMacSize(), n5);
        byte[] byArray11 = new byte[byArray10.length];
        SavableDigest savableDigest = SHA256Digest.newInstance();
        byte[] byArray12 = new byte[savableDigest.getDigestSize()];
        savableDigest.reset();
        savableDigest.update(byArray3, 0, byArray3.length);
        savableDigest.doFinal(byArray12, 0);
        this.c.init(new KeyParameter(byArray12));
        this.c.update(this.n, 0, this.n.length);
        this.c.update(byArray, n2 + this.k.length, n3 - this.k.length - byArray11.length);
        if (byArray8 != null) {
            this.c.update(byArray8, 0, byArray8.length);
        }
        if (this.k.length != 0) {
            this.c.update(byArray9, 0, byArray9.length);
        }
        this.c.update(this.f, 0, this.f.length);
        this.c.doFinal(byArray11, 0);
        if (!Arrays.constantTimeAreEqual(byArray10, byArray11)) {
            throw new InvalidCipherTextException("invalid MAC");
        }
        if (this.d == null) {
            return byArray2;
        }
        n4 += this.d.doFinal(byArray2, n4);
        return Arrays.copyOfRange(byArray2, 0, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] processBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        Object object;
        Object object2;
        if (this.g) {
            if (this.l != null) {
                object2 = this.l.generate();
                this.h = ((EphemeralKeyPair)object2).getKeyPair().getPrivate();
                this.k = ((EphemeralKeyPair)object2).getEncodedPublicKey();
            }
        } else if (this.m != null) {
            object2 = new ByteArrayInputStream(in, inOff, inLen);
            try {
                this.i = this.m.readKey((InputStream)object2);
            }
            catch (IOException iOException) {
                throw new InvalidCipherTextException("unable to recover ephemeral public key: " + iOException.getMessage(), iOException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidCipherTextException("unable to recover ephemeral public key: " + illegalArgumentException.getMessage(), illegalArgumentException);
            }
            int n2 = inLen - ((ByteArrayInputStream)object2).available();
            this.k = Arrays.copyOfRange(in, inOff, inOff + n2);
        }
        this.a.init(this.h);
        object2 = this.a.calculateAgreement(this.i);
        byte[] byArray = BigIntegers.asUnsignedByteArray(this.a.getFieldSize(), (BigInteger)object2);
        if (this.k.length != 0) {
            object = Arrays.concatenate(this.k, byArray);
            Arrays.fill(byArray, (byte)0);
            byArray = object;
        }
        try {
            object = new KDFParameters(byArray, this.j.getDerivationV());
            this.b.init((DerivationParameters)object);
            byte[] byArray2 = this.g ? this.a(in, inOff, inLen) : this.b(in, inOff, inLen);
            return byArray2;
        }
        finally {
            Arrays.fill(byArray, (byte)0);
        }
    }

    protected byte[] getLengthTag(byte[] p2) {
        byte[] byArray = new byte[8];
        if (p2 != null) {
            Pack.longToBigEndian((long)p2.length * 8L, byArray, 0);
        }
        return byArray;
    }

    public static class HandshakeKDFFunction
    implements DigestDerivationFunction {
        private int a;
        private Digest b;
        private byte[] c;
        private byte[] d;

        public HandshakeKDFFunction(int counterStart, Digest digest) {
            this.a = counterStart;
            this.b = digest;
        }

        @Override
        public void init(DerivationParameters param) {
            if (param instanceof KDFParameters) {
                KDFParameters kDFParameters = (KDFParameters)param;
                this.c = kDFParameters.getSharedSecret();
                this.d = kDFParameters.getIV();
            } else if (param instanceof ISO18033KDFParameters) {
                ISO18033KDFParameters iSO18033KDFParameters = (ISO18033KDFParameters)param;
                this.c = iSO18033KDFParameters.getSeed();
                this.d = null;
            } else {
                throw new IllegalArgumentException("KDF parameters required for generator");
            }
        }

        @Override
        public Digest getDigest() {
            return this.b;
        }

        @Override
        public int generateBytes(byte[] out, int outOff, int len) throws DataLengthException, IllegalArgumentException {
            if (out.length - len < outOff) {
                throw new OutputLengthException("output buffer too small");
            }
            long l2 = len;
            int n2 = this.b.getDigestSize();
            if (l2 > 0x1FFFFFFFFL) {
                throw new IllegalArgumentException("output length too large");
            }
            int n3 = (int)((l2 + (long)n2 - 1L) / (long)n2);
            byte[] byArray = new byte[this.b.getDigestSize()];
            byte[] byArray2 = new byte[4];
            Pack.intToBigEndian(this.a, byArray2, 0);
            int n4 = this.a & 0xFFFFFF00;
            for (int i2 = 0; i2 < n3; ++i2) {
                this.b.update(byArray2, 0, byArray2.length);
                this.b.update(this.c, 0, this.c.length);
                if (this.d != null) {
                    this.b.update(this.d, 0, this.d.length);
                }
                this.b.doFinal(byArray, 0);
                if (len > n2) {
                    System.arraycopy(byArray, 0, out, outOff, n2);
                    outOff += n2;
                    len -= n2;
                } else {
                    System.arraycopy(byArray, 0, out, outOff, len);
                }
                byArray2[3] = (byte)(byArray2[3] + 1);
                if (byArray2[3] != 0) continue;
                Pack.intToBigEndian(n4 += 256, byArray2, 0);
            }
            this.b.reset();
            return (int)l2;
        }
    }
}

