/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.engines;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.constraints.DefaultServiceProperties;
import com.enterprisedt.bouncycastle.crypto.engines.c;
import com.enterprisedt.bouncycastle.crypto.modes.AEADCipher;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;
import com.enterprisedt.bouncycastle.util.Pack;
import java.io.ByteArrayOutputStream;

public class Grain128AEADEngine
implements AEADCipher {
    private byte[] a;
    private byte[] b;
    private int[] c;
    private int[] d;
    private int[] e;
    private int[] f;
    private boolean g = false;
    private boolean h = false;
    private a i = new a();
    private byte[] j;

    @Override
    public String getAlgorithmName() {
        return "Grain-128AEAD";
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        if (!(params instanceof ParametersWithIV)) {
            throw new IllegalArgumentException("Grain-128AEAD init parameters must include an IV");
        }
        ParametersWithIV parametersWithIV = (ParametersWithIV)params;
        byte[] byArray = parametersWithIV.getIV();
        if (byArray == null || byArray.length != 12) {
            throw new IllegalArgumentException("Grain-128AEAD requires exactly 12 bytes of IV");
        }
        if (!(parametersWithIV.getParameters() instanceof KeyParameter)) {
            throw new IllegalArgumentException("Grain-128AEAD init parameters must include a key");
        }
        KeyParameter keyParameter = (KeyParameter)parametersWithIV.getParameters();
        byte[] byArray2 = keyParameter.getKey();
        if (byArray2.length != 16) {
            throw new IllegalArgumentException("Grain-128AEAD key must be 128 bits long");
        }
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties(this.getAlgorithmName(), 128, params, com.enterprisedt.bouncycastle.crypto.engines.c.a(forEncryption)));
        this.b = new byte[16];
        this.a = new byte[16];
        this.c = new int[4];
        this.d = new int[4];
        this.e = new int[2];
        this.f = new int[2];
        System.arraycopy(byArray, 0, this.b, 0, byArray.length);
        System.arraycopy(byArray2, 0, this.a, 0, byArray2.length);
        this.reset();
    }

    private void a() {
        int n2;
        int n3;
        int n4;
        for (n4 = 0; n4 < 320; ++n4) {
            n3 = this.d();
            this.d = this.a(this.d, (this.b() ^ this.c[0] ^ n3) & 1);
            this.c = this.a(this.c, (this.c() ^ n3) & 1);
        }
        for (n4 = 0; n4 < 8; ++n4) {
            for (n3 = 0; n3 < 8; ++n3) {
                n2 = this.d();
                this.d = this.a(this.d, (this.b() ^ this.c[0] ^ n2 ^ this.a[n4] >> n3) & 1);
                this.c = this.a(this.c, (this.c() ^ n2 ^ this.a[n4 + 8] >> n3) & 1);
            }
        }
        for (n4 = 0; n4 < 2; ++n4) {
            for (n3 = 0; n3 < 32; ++n3) {
                n2 = this.d();
                this.d = this.a(this.d, (this.b() ^ this.c[0]) & 1);
                this.c = this.a(this.c, this.c() & 1);
                int n5 = n4;
                this.e[n5] = this.e[n5] | n2 << n3;
            }
        }
        for (n4 = 0; n4 < 2; ++n4) {
            for (n3 = 0; n3 < 32; ++n3) {
                n2 = this.d();
                this.d = this.a(this.d, (this.b() ^ this.c[0]) & 1);
                this.c = this.a(this.c, this.c() & 1);
                int n6 = n4;
                this.f[n6] = this.f[n6] | n2 << n3;
            }
        }
        this.g = true;
    }

    private int b() {
        int n2 = this.d[0];
        int n3 = this.d[0] >>> 3;
        int n4 = this.d[0] >>> 11;
        int n5 = this.d[0] >>> 13;
        int n6 = this.d[0] >>> 17;
        int n7 = this.d[0] >>> 18;
        int n8 = this.d[0] >>> 22;
        int n9 = this.d[0] >>> 24;
        int n10 = this.d[0] >>> 25;
        int n11 = this.d[0] >>> 26;
        int n12 = this.d[0] >>> 27;
        int n13 = this.d[1] >>> 8;
        int n14 = this.d[1] >>> 16;
        int n15 = this.d[1] >>> 24;
        int n16 = this.d[1] >>> 27;
        int n17 = this.d[1] >>> 29;
        int n18 = this.d[2] >>> 1;
        int n19 = this.d[2] >>> 3;
        int n20 = this.d[2] >>> 4;
        int n21 = this.d[2] >>> 6;
        int n22 = this.d[2] >>> 14;
        int n23 = this.d[2] >>> 18;
        int n24 = this.d[2] >>> 20;
        int n25 = this.d[2] >>> 24;
        int n26 = this.d[2] >>> 27;
        int n27 = this.d[2] >>> 28;
        int n28 = this.d[2] >>> 29;
        int n29 = this.d[2] >>> 31;
        int n30 = this.d[3];
        return (n2 ^ n11 ^ n15 ^ n26 ^ n30 ^ n3 & n19 ^ n4 & n5 ^ n6 & n7 ^ n12 & n16 ^ n13 & n14 ^ n17 & n18 ^ n20 & n24 ^ n8 & n9 & n10 ^ n21 & n22 & n23 ^ n25 & n27 & n28 & n29) & 1;
    }

    private int c() {
        int n2 = this.c[0];
        int n3 = this.c[0] >>> 7;
        int n4 = this.c[1] >>> 6;
        int n5 = this.c[2] >>> 6;
        int n6 = this.c[2] >>> 17;
        int n7 = this.c[3];
        return (n2 ^ n3 ^ n4 ^ n5 ^ n6 ^ n7) & 1;
    }

    private int d() {
        int n2 = this.d[0] >>> 2;
        int n3 = this.d[0] >>> 12;
        int n4 = this.d[0] >>> 15;
        int n5 = this.d[1] >>> 4;
        int n6 = this.d[1] >>> 13;
        int n7 = this.d[2];
        int n8 = this.d[2] >>> 9;
        int n9 = this.d[2] >>> 25;
        int n10 = this.d[2] >>> 31;
        int n11 = this.c[0] >>> 8;
        int n12 = this.c[0] >>> 13;
        int n13 = this.c[0] >>> 20;
        int n14 = this.c[1] >>> 10;
        int n15 = this.c[1] >>> 28;
        int n16 = this.c[2] >>> 15;
        int n17 = this.c[2] >>> 29;
        int n18 = this.c[2] >>> 30;
        return (n3 & n11 ^ n12 & n13 ^ n10 & n14 ^ n15 & n16 ^ n3 & n10 & n18 ^ n17 ^ n2 ^ n4 ^ n5 ^ n6 ^ n7 ^ n8 ^ n9) & 1;
    }

    private int[] a(int[] nArray, int n2) {
        nArray[0] = nArray[0] >>> 1 | nArray[1] << 31;
        nArray[1] = nArray[1] >>> 1 | nArray[2] << 31;
        nArray[2] = nArray[2] >>> 1 | nArray[3] << 31;
        nArray[3] = nArray[3] >>> 1 | n2 << 31;
        return nArray;
    }

    private void a(byte[] byArray, byte[] byArray2) {
        byArray2[12] = -1;
        byArray2[13] = -1;
        byArray2[14] = -1;
        byArray2[15] = 127;
        this.a = byArray;
        this.b = byArray2;
        Pack.littleEndianToInt(this.a, 0, this.d);
        Pack.littleEndianToInt(this.b, 0, this.c);
    }

    @Override
    public int processBytes(byte[] input, int inOff, int len, byte[] output, int outOff) throws DataLengthException {
        if (!this.g) {
            throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
        }
        if (!this.h) {
            this.a(this.i.a(), 0, this.i.size());
            this.h = true;
        }
        if (inOff + len > input.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + len > output.length) {
            throw new OutputLengthException("output buffer too short");
        }
        this.a(input, inOff, len, output, outOff);
        return len;
    }

    @Override
    public void reset() {
        this.a(true);
    }

    private void a(boolean bl) {
        if (bl) {
            this.j = null;
        }
        this.i.reset();
        this.h = false;
        this.a(this.a, this.b);
        this.a();
    }

    private byte[] a(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        for (int i2 = 0; i2 < n3; ++i2) {
            byte by = 0;
            byte by2 = byArray[n2 + i2];
            for (int i3 = 0; i3 < 8; ++i3) {
                int n5 = this.d();
                this.d = this.a(this.d, (this.b() ^ this.c[0]) & 1);
                this.c = this.a(this.c, this.c() & 1);
                int n6 = by2 >> i3 & 1;
                by = (byte)(by | (n6 ^ n5) << i3);
                int n7 = -n6;
                this.e[0] = this.e[0] ^ this.f[0] & n7;
                this.e[1] = this.e[1] ^ this.f[1] & n7;
                this.a(this.d());
                this.d = this.a(this.d, (this.b() ^ this.c[0]) & 1);
                this.c = this.a(this.c, this.c() & 1);
            }
            byArray2[n4 + i2] = by;
        }
        return byArray2;
    }

    @Override
    public void processAADByte(byte in) {
        if (this.h) {
            throw new IllegalStateException("associated data must be added before plaintext/ciphertext");
        }
        this.i.write(in);
    }

    @Override
    public void processAADBytes(byte[] input, int inOff, int len) {
        if (this.h) {
            throw new IllegalStateException("associated data must be added before plaintext/ciphertext");
        }
        this.i.write(input, inOff, len);
    }

    private void a(byte[] byArray, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        byte[] byArray2;
        if (n3 < 128) {
            byArray2 = new byte[1 + n3];
            byArray2[0] = (byte)n3;
            n6 = 0;
        } else {
            n6 = Grain128AEADEngine.b(n3);
            byArray2 = new byte[1 + n6 + n3];
            byArray2[0] = (byte)(0x80 | n6);
            n5 = n3;
            for (n4 = 0; n4 < n6; ++n4) {
                byArray2[1 + n4] = (byte)n5;
                n5 >>>= 8;
            }
        }
        for (n5 = 0; n5 < n3; ++n5) {
            byArray2[1 + n6 + n5] = byArray[n2 + n5];
        }
        for (n5 = 0; n5 < byArray2.length; ++n5) {
            n4 = byArray2[n5];
            for (int i2 = 0; i2 < 8; ++i2) {
                this.d = this.a(this.d, (this.b() ^ this.c[0]) & 1);
                this.c = this.a(this.c, this.c() & 1);
                int n7 = n4 >> i2 & 1;
                int n8 = -n7;
                this.e[0] = this.e[0] ^ this.f[0] & n8;
                this.e[1] = this.e[1] ^ this.f[1] & n8;
                this.a(this.d());
                this.d = this.a(this.d, (this.b() ^ this.c[0]) & 1);
                this.c = this.a(this.c, this.c() & 1);
            }
        }
    }

    private void e() {
        this.e[0] = this.e[0] ^ this.f[0];
        this.e[1] = this.e[1] ^ this.f[1];
    }

    private void a(int n2) {
        this.f[0] = this.f[0] >>> 1 | this.f[1] << 31;
        this.f[1] = this.f[1] >>> 1 | n2 << 31;
    }

    @Override
    public int processByte(byte input, byte[] output, int outOff) throws DataLengthException {
        return this.processBytes(new byte[]{input}, 0, 1, output, outOff);
    }

    @Override
    public int doFinal(byte[] out, int outOff) throws IllegalStateException, InvalidCipherTextException {
        if (!this.h) {
            this.a(this.i.a(), 0, this.i.size());
            this.h = true;
        }
        this.e();
        this.j = Pack.intToLittleEndian(this.e);
        System.arraycopy(this.j, 0, out, outOff, this.j.length);
        this.a(false);
        return this.j.length;
    }

    @Override
    public byte[] getMac() {
        return this.j;
    }

    @Override
    public int getUpdateOutputSize(int len) {
        return len;
    }

    @Override
    public int getOutputSize(int len) {
        return len + 8;
    }

    private static int b(int n2) {
        if ((n2 & 0xFF) == n2) {
            return 1;
        }
        if ((n2 & 0xFFFF) == n2) {
            return 2;
        }
        if ((n2 & 0xFFFFFF) == n2) {
            return 3;
        }
        return 4;
    }

    private static final class a
    extends ByteArrayOutputStream {
        public byte[] a() {
            return this.buf;
        }
    }
}

