/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.engines;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.StreamCipher;
import com.enterprisedt.bouncycastle.crypto.constraints.DefaultServiceProperties;
import com.enterprisedt.bouncycastle.crypto.engines.c;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;

public class Grain128Engine
implements StreamCipher {
    private byte[] a;
    private byte[] b;
    private byte[] c;
    private int[] d;
    private int[] e;
    private int f;
    private int g = 4;
    private boolean h = false;

    @Override
    public String getAlgorithmName() {
        return "Grain-128";
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        if (!(params instanceof ParametersWithIV)) {
            throw new IllegalArgumentException("Grain-128 Init parameters must include an IV");
        }
        ParametersWithIV parametersWithIV = (ParametersWithIV)params;
        byte[] byArray = parametersWithIV.getIV();
        if (byArray == null || byArray.length != 12) {
            throw new IllegalArgumentException("Grain-128 requires exactly 12 bytes of IV");
        }
        if (!(parametersWithIV.getParameters() instanceof KeyParameter)) {
            throw new IllegalArgumentException("Grain-128 init parameters must include a key");
        }
        KeyParameter keyParameter = (KeyParameter)parametersWithIV.getParameters();
        byte[] byArray2 = keyParameter.getKey();
        if (byArray2.length != 16) {
            throw new IllegalArgumentException("Grain-128 key must be 128 bits long");
        }
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties(this.getAlgorithmName(), 128, params, com.enterprisedt.bouncycastle.crypto.engines.c.a(forEncryption)));
        this.b = new byte[byArray2.length];
        this.a = new byte[byArray2.length];
        this.d = new int[4];
        this.e = new int[4];
        this.c = new byte[4];
        System.arraycopy(byArray, 0, this.b, 0, byArray.length);
        System.arraycopy(byArray2, 0, this.a, 0, byArray2.length);
        this.reset();
    }

    private void a() {
        for (int i2 = 0; i2 < 8; ++i2) {
            this.f = this.d();
            this.e = this.a(this.e, this.b() ^ this.d[0] ^ this.f);
            this.d = this.a(this.d, this.c() ^ this.f);
        }
        this.h = true;
    }

    private int b() {
        int n2 = this.e[0];
        int n3 = this.e[0] >>> 3 | this.e[1] << 29;
        int n4 = this.e[0] >>> 11 | this.e[1] << 21;
        int n5 = this.e[0] >>> 13 | this.e[1] << 19;
        int n6 = this.e[0] >>> 17 | this.e[1] << 15;
        int n7 = this.e[0] >>> 18 | this.e[1] << 14;
        int n8 = this.e[0] >>> 26 | this.e[1] << 6;
        int n9 = this.e[0] >>> 27 | this.e[1] << 5;
        int n10 = this.e[1] >>> 8 | this.e[2] << 24;
        int n11 = this.e[1] >>> 16 | this.e[2] << 16;
        int n12 = this.e[1] >>> 24 | this.e[2] << 8;
        int n13 = this.e[1] >>> 27 | this.e[2] << 5;
        int n14 = this.e[1] >>> 29 | this.e[2] << 3;
        int n15 = this.e[2] >>> 1 | this.e[3] << 31;
        int n16 = this.e[2] >>> 3 | this.e[3] << 29;
        int n17 = this.e[2] >>> 4 | this.e[3] << 28;
        int n18 = this.e[2] >>> 20 | this.e[3] << 12;
        int n19 = this.e[2] >>> 27 | this.e[3] << 5;
        int n20 = this.e[3];
        return n2 ^ n8 ^ n12 ^ n19 ^ n20 ^ n3 & n16 ^ n4 & n5 ^ n6 & n7 ^ n9 & n13 ^ n10 & n11 ^ n14 & n15 ^ n17 & n18;
    }

    private int c() {
        int n2 = this.d[0];
        int n3 = this.d[0] >>> 7 | this.d[1] << 25;
        int n4 = this.d[1] >>> 6 | this.d[2] << 26;
        int n5 = this.d[2] >>> 6 | this.d[3] << 26;
        int n6 = this.d[2] >>> 17 | this.d[3] << 15;
        int n7 = this.d[3];
        return n2 ^ n3 ^ n4 ^ n5 ^ n6 ^ n7;
    }

    private int d() {
        int n2 = this.e[0] >>> 2 | this.e[1] << 30;
        int n3 = this.e[0] >>> 12 | this.e[1] << 20;
        int n4 = this.e[0] >>> 15 | this.e[1] << 17;
        int n5 = this.e[1] >>> 4 | this.e[2] << 28;
        int n6 = this.e[1] >>> 13 | this.e[2] << 19;
        int n7 = this.e[2];
        int n8 = this.e[2] >>> 9 | this.e[3] << 23;
        int n9 = this.e[2] >>> 25 | this.e[3] << 7;
        int n10 = this.e[2] >>> 31 | this.e[3] << 1;
        int n11 = this.d[0] >>> 8 | this.d[1] << 24;
        int n12 = this.d[0] >>> 13 | this.d[1] << 19;
        int n13 = this.d[0] >>> 20 | this.d[1] << 12;
        int n14 = this.d[1] >>> 10 | this.d[2] << 22;
        int n15 = this.d[1] >>> 28 | this.d[2] << 4;
        int n16 = this.d[2] >>> 15 | this.d[3] << 17;
        int n17 = this.d[2] >>> 29 | this.d[3] << 3;
        int n18 = this.d[2] >>> 31 | this.d[3] << 1;
        return n3 & n11 ^ n12 & n13 ^ n10 & n14 ^ n15 & n16 ^ n3 & n10 & n18 ^ n17 ^ n2 ^ n4 ^ n5 ^ n6 ^ n7 ^ n8 ^ n9;
    }

    private int[] a(int[] nArray, int n2) {
        nArray[0] = nArray[1];
        nArray[1] = nArray[2];
        nArray[2] = nArray[3];
        nArray[3] = n2;
        return nArray;
    }

    private void a(byte[] byArray, byte[] byArray2) {
        byArray2[12] = -1;
        byArray2[13] = -1;
        byArray2[14] = -1;
        byArray2[15] = -1;
        this.a = byArray;
        this.b = byArray2;
        int n2 = 0;
        for (int i2 = 0; i2 < this.e.length; ++i2) {
            this.e[i2] = this.a[n2 + 3] << 24 | this.a[n2 + 2] << 16 & 0xFF0000 | this.a[n2 + 1] << 8 & 0xFF00 | this.a[n2] & 0xFF;
            this.d[i2] = this.b[n2 + 3] << 24 | this.b[n2 + 2] << 16 & 0xFF0000 | this.b[n2 + 1] << 8 & 0xFF00 | this.b[n2] & 0xFF;
            n2 += 4;
        }
    }

    @Override
    public int processBytes(byte[] in, int inOff, int len, byte[] out, int outOff) throws DataLengthException {
        if (!this.h) {
            throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
        }
        if (inOff + len > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + len > out.length) {
            throw new OutputLengthException("output buffer too short");
        }
        for (int i2 = 0; i2 < len; ++i2) {
            out[outOff + i2] = (byte)(in[inOff + i2] ^ this.f());
        }
        return len;
    }

    @Override
    public void reset() {
        this.g = 4;
        this.a(this.a, this.b);
        this.a();
    }

    private void e() {
        this.f = this.d();
        this.c[0] = (byte)this.f;
        this.c[1] = (byte)(this.f >> 8);
        this.c[2] = (byte)(this.f >> 16);
        this.c[3] = (byte)(this.f >> 24);
        this.e = this.a(this.e, this.b() ^ this.d[0]);
        this.d = this.a(this.d, this.c());
    }

    @Override
    public byte returnByte(byte in) {
        if (!this.h) {
            throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
        }
        return (byte)(in ^ this.f());
    }

    private byte f() {
        if (this.g > 3) {
            this.e();
            this.g = 0;
        }
        return this.c[this.g++];
    }
}

