/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.engines;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.constraints.DefaultServiceProperties;
import com.enterprisedt.bouncycastle.crypto.modes.AEADCipher;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;
import com.enterprisedt.bouncycastle.util.Pack;
import java.io.ByteArrayOutputStream;

public class ISAPEngine
implements AEADCipher {
    private String d;
    private boolean e;
    private boolean f;
    final int a = 16;
    final int b = 16;
    final int c = 40;
    private byte[] g;
    private byte[] h;
    private byte[] i;
    private byte[] j;
    private byte[] k;
    private ByteArrayOutputStream l = new ByteArrayOutputStream();
    private final ByteArrayOutputStream m = new ByteArrayOutputStream();
    private final ByteArrayOutputStream n = new ByteArrayOutputStream();
    private int o;
    private int p;
    private f q;

    public ISAPEngine(IsapType isapType) {
        switch (isapType) {
            case ISAP_A_128A: {
                this.q = new b();
                this.d = "ISAP-A-128A AEAD";
                break;
            }
            case ISAP_K_128A: {
                this.q = new e();
                this.d = "ISAP-K-128A AEAD";
                break;
            }
            case ISAP_A_128: {
                this.q = new a();
                this.d = "ISAP-A-128 AEAD";
                break;
            }
            case ISAP_K_128: {
                this.q = new d();
                this.d = "ISAP-K-128 AEAD";
            }
        }
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        this.e = forEncryption;
        if (!(params instanceof ParametersWithIV)) {
            throw new IllegalArgumentException("ISAP AEAD init parameters must include an IV");
        }
        ParametersWithIV parametersWithIV = (ParametersWithIV)params;
        byte[] byArray = parametersWithIV.getIV();
        if (byArray == null || byArray.length != 16) {
            throw new IllegalArgumentException("ISAP AEAD requires exactly 12 bytes of IV");
        }
        if (!(parametersWithIV.getParameters() instanceof KeyParameter)) {
            throw new IllegalArgumentException("ISAP AEAD init parameters must include a key");
        }
        KeyParameter keyParameter = (KeyParameter)parametersWithIV.getParameters();
        byte[] byArray2 = keyParameter.getKey();
        if (byArray2.length != 16) {
            throw new IllegalArgumentException("ISAP AEAD key must be 128 bits long");
        }
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties(this.getAlgorithmName(), 128, params, com.enterprisedt.bouncycastle.crypto.engines.c.a(forEncryption)));
        this.j = new byte[byArray.length];
        this.g = new byte[byArray2.length];
        System.arraycopy(byArray, 0, this.j, 0, byArray.length);
        System.arraycopy(byArray2, 0, this.g, 0, byArray2.length);
        this.q.init();
        this.f = true;
        this.reset();
    }

    @Override
    public String getAlgorithmName() {
        return this.d;
    }

    @Override
    public void processAADByte(byte in) {
        this.l.write(in);
    }

    @Override
    public void processAADBytes(byte[] in, int inOff, int len) {
        if (inOff + len > in.length) {
            throw new DataLengthException("input buffer too short" + (this.e ? "encryption" : "decryption"));
        }
        this.l.write(in, inOff, len);
    }

    @Override
    public int processByte(byte in, byte[] out, int outOff) throws DataLengthException {
        return this.processBytes(new byte[]{in}, 0, 1, out, outOff);
    }

    @Override
    public int processBytes(byte[] input, int inOff, int len, byte[] output, int outOff) throws DataLengthException {
        if (!this.f) {
            throw new IllegalArgumentException("Need call init function before encryption/decryption");
        }
        if (inOff + len > input.length) {
            throw new DataLengthException("input buffer too short");
        }
        this.m.write(input, inOff, len);
        if (this.e && this.m.size() >= this.p) {
            len = this.m.size() / this.p * this.p;
            if (outOff + len > output.length) {
                throw new OutputLengthException("output buffer is too short");
            }
            byte[] byArray = this.m.toByteArray();
            this.q.isap_enc(byArray, 0, len, output, outOff, output.length);
            this.n.write(output, outOff, len);
            this.m.reset();
            this.m.write(byArray, len, byArray.length - len);
            return len;
        }
        return 0;
    }

    @Override
    public int doFinal(byte[] output, int outOff) throws IllegalStateException, InvalidCipherTextException {
        int n2;
        if (!this.f) {
            throw new IllegalArgumentException("Need call init function before encryption/decryption");
        }
        if (this.e) {
            byte[] byArray = this.m.toByteArray();
            n2 = byArray.length;
            if (outOff + n2 + 16 > output.length) {
                throw new OutputLengthException("output buffer is too short");
            }
            this.q.isap_enc(byArray, 0, n2, output, outOff, output.length);
            this.n.write(output, outOff, n2);
            this.i = this.l.toByteArray();
            this.h = this.n.toByteArray();
            this.k = new byte[16];
            this.q.isap_mac(this.i, this.i.length, this.h, this.h.length, this.k, 0);
            System.arraycopy(this.k, 0, output, outOff += n2, 16);
            n2 += 16;
        } else {
            this.i = this.l.toByteArray();
            this.h = this.m.toByteArray();
            this.k = new byte[16];
            n2 = this.h.length - this.k.length;
            if (n2 + outOff > output.length) {
                throw new OutputLengthException("output buffer is too short");
            }
            this.q.isap_mac(this.i, this.i.length, this.h, n2, this.k, 0);
            this.q.reset();
            for (int i2 = 0; i2 < 16; ++i2) {
                if (this.k[i2] == this.h[n2 + i2]) continue;
                throw new IllegalArgumentException("Mac does not match");
            }
            this.q.isap_enc(this.h, 0, n2, output, outOff, output.length);
        }
        return n2;
    }

    @Override
    public byte[] getMac() {
        return this.k;
    }

    @Override
    public int getUpdateOutputSize(int len) {
        return len;
    }

    @Override
    public int getOutputSize(int len) {
        return len + 16;
    }

    @Override
    public void reset() {
        if (!this.f) {
            throw new IllegalArgumentException("Need call init function before encryption/decryption");
        }
        this.l.reset();
        this.q.reset();
        this.m.reset();
        this.n.reset();
    }

    public int getKeyBytesSize() {
        return 16;
    }

    public int getIVBytesSize() {
        return 16;
    }

    public int getBlockSize() {
        return this.p;
    }

    private class d
    extends c {
        public d() {
            this.b = new short[]{-32767, 400, 3092, 3084};
            this.c = new short[]{-32766, 400, 3092, 3084};
            this.d = new short[]{-32765, 400, 3092, 3084};
        }

        @Override
        protected void a(short[] sArray, short[] sArray2, short[] sArray3) {
            this.a(sArray, sArray3);
            this.a(0, sArray, sArray2, sArray3);
            this.a(1, sArray2, sArray, sArray3);
            this.a(2, sArray, sArray2, sArray3);
            this.a(3, sArray2, sArray, sArray3);
            this.e(sArray, sArray2, sArray3);
        }

        @Override
        protected void b(short[] sArray, short[] sArray2, short[] sArray3) {
            this.d(sArray, sArray2, sArray3);
        }

        @Override
        protected void c(short[] sArray, short[] sArray2, short[] sArray3) {
            this.d(sArray, sArray2, sArray3);
        }
    }

    private class e
    extends c {
        public e() {
            this.b = new short[]{-32767, 400, 272, 2056};
            this.c = new short[]{-32766, 400, 272, 2056};
            this.d = new short[]{-32765, 400, 272, 2056};
        }

        @Override
        protected void a(short[] sArray, short[] sArray2, short[] sArray3) {
            this.a(sArray, sArray3);
            this.e(sArray, sArray2, sArray3);
        }

        @Override
        protected void b(short[] sArray, short[] sArray2, short[] sArray3) {
            this.a(sArray, sArray3);
            this.g(sArray, sArray2, sArray3);
        }

        @Override
        protected void c(short[] sArray, short[] sArray2, short[] sArray3) {
            this.a(sArray, sArray3);
            this.a(19, sArray, sArray2, sArray3);
            System.arraycopy(sArray2, 0, sArray, 0, sArray2.length);
        }
    }

    private abstract class c
    implements f {
        final int a = 24;
        protected short[] b;
        protected short[] c;
        protected short[] d;
        protected short[] e;
        protected short[] f;
        private final int[] k = new int[]{1, 32898, 32906, 32768, 32907, 1, 32897, 32777, 138, 136, 32777, 10, 32907, 139, 32905, 32771, 32770, 128, 32778, 10};
        protected short[] g = new short[25];
        protected short[] h = new short[25];
        protected short[] i = new short[5];

        public c() {
            ISAPEngine.this.o = 144;
            ISAPEngine.this.p = ISAPEngine.this.o + 7 >> 3;
        }

        @Override
        public void init() {
            this.e = new short[ISAPEngine.this.g.length >> 1];
            this.b(ISAPEngine.this.g, this.e, this.e.length);
            this.f = new short[ISAPEngine.this.j.length >> 1];
            this.b(ISAPEngine.this.j, this.f, this.f.length);
            this.reset();
        }

        @Override
        public void reset() {
            this.g = new short[25];
            this.h = new short[25];
            this.i = new short[5];
            this.a(this.d, ISAPEngine.this.j, 16, this.g, 24, this.i);
            System.arraycopy(this.f, 0, this.g, 17, 8);
            this.b(this.g, this.h, this.i);
        }

        protected abstract void a(short[] var1, short[] var2, short[] var3);

        protected abstract void b(short[] var1, short[] var2, short[] var3);

        protected abstract void c(short[] var1, short[] var2, short[] var3);

        protected void a(short[] sArray, byte[] byArray, int n2, short[] sArray2, short[] sArray3) {
            int n3;
            int n4 = 0;
            for (n3 = n2; n3 > ISAPEngine.this.p; n3 -= ISAPEngine.this.p) {
                this.a(byArray, sArray, ISAPEngine.this.p >> 1);
                n4 += ISAPEngine.this.p;
                this.a(sArray, sArray2, sArray3);
            }
            if (n3 == ISAPEngine.this.p) {
                this.a(byArray, sArray, ISAPEngine.this.p >> 1);
                this.a(sArray, sArray2, sArray3);
                sArray[0] = (short)(sArray[0] ^ 0x80);
                this.a(sArray, sArray2, sArray3);
            } else {
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n5 = i2 >> 1;
                    sArray[n5] = (short)(sArray[n5] ^ (byArray[n4++] & 0xFF) << ((i2 & 1) << 3));
                }
                int n6 = n3 >> 1;
                sArray[n6] = (short)(sArray[n6] ^ 128 << ((n3 & 1) << 3));
                this.a(sArray, sArray2, sArray3);
            }
        }

        public void a(short[] sArray, byte[] byArray, int n2, short[] sArray2, int n3, short[] sArray3) {
            short[] sArray4 = new short[25];
            short[] sArray5 = new short[25];
            System.arraycopy(this.e, 0, sArray4, 0, 8);
            System.arraycopy(sArray, 0, sArray4, 8, 4);
            this.b(sArray4, sArray5, sArray3);
            for (int i2 = 0; i2 < (n2 << 3) - 1; ++i2) {
                sArray4[0] = (short)(sArray4[0] ^ (byArray[i2 >> 3] >>> 7 - (i2 & 7) & 1) << 7);
                this.c(sArray4, sArray5, sArray3);
            }
            sArray4[0] = (short)(sArray4[0] ^ (byArray[n2 - 1] & 1) << 7);
            this.b(sArray4, sArray5, sArray3);
            System.arraycopy(sArray4, 0, sArray2, 0, n3 == 24 ? 17 : 8);
        }

        @Override
        public void isap_mac(byte[] ad, int adlen, byte[] c2, int clen, byte[] tag, int tagOff) {
            this.g = new short[25];
            System.arraycopy(this.f, 0, this.g, 0, 8);
            System.arraycopy(this.b, 0, this.g, 8, 4);
            this.a(this.g, this.h, this.i);
            this.a(this.g, ad, adlen, this.h, this.i);
            this.g[24] = (short)(this.g[24] ^ 0x100);
            this.a(this.g, c2, clen, this.h, this.i);
            this.a(this.g, tag, tagOff);
            this.a(this.c, tag, 16, this.g, 16, this.i);
            this.a(this.g, this.h, this.i);
            this.a(this.g, tag, tagOff);
        }

        @Override
        public void isap_enc(byte[] m2, int mOff, int mlen, byte[] c2, int cOff, int clen) {
            int n2;
            while (mlen >= ISAPEngine.this.p) {
                for (n2 = 0; n2 < ISAPEngine.this.p; ++n2) {
                    c2[cOff++] = (byte)(this.g[n2 >> 1] >>> ((n2 & 1) << 3) ^ m2[mOff++]);
                }
                mlen -= ISAPEngine.this.p;
                this.b(this.g, this.h, this.i);
            }
            for (n2 = 0; n2 < mlen; ++n2) {
                c2[cOff++] = (byte)(this.g[n2 >> 1] >>> ((n2 & 1) << 3) ^ m2[mOff++]);
            }
        }

        private void a(byte[] byArray, short[] sArray, int n2) {
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = i2;
                sArray[n3] = (short)(sArray[n3] ^ Pack.littleEndianToShort(byArray, i2 << 1));
            }
        }

        private void b(byte[] byArray, short[] sArray, int n2) {
            for (int i2 = 0; i2 < n2; ++i2) {
                sArray[i2] = Pack.littleEndianToShort(byArray, i2 << 1);
            }
        }

        private void a(short[] sArray, byte[] byArray, int n2) {
            for (int i2 = 0; i2 < 8; ++i2) {
                Pack.shortToLittleEndian(sArray[i2], byArray, n2 + (i2 << 1));
            }
        }

        protected void d(short[] sArray, short[] sArray2, short[] sArray3) {
            this.a(sArray, sArray3);
            this.f(sArray, sArray2, sArray3);
        }

        protected void e(short[] sArray, short[] sArray2, short[] sArray3) {
            this.a(4, sArray, sArray2, sArray3);
            this.a(5, sArray2, sArray, sArray3);
            this.a(6, sArray, sArray2, sArray3);
            this.a(7, sArray2, sArray, sArray3);
            this.f(sArray, sArray2, sArray3);
        }

        protected void f(short[] sArray, short[] sArray2, short[] sArray3) {
            this.a(8, sArray, sArray2, sArray3);
            this.a(9, sArray2, sArray, sArray3);
            this.a(10, sArray, sArray2, sArray3);
            this.a(11, sArray2, sArray, sArray3);
            this.g(sArray, sArray2, sArray3);
        }

        protected void g(short[] sArray, short[] sArray2, short[] sArray3) {
            this.a(12, sArray, sArray2, sArray3);
            this.a(13, sArray2, sArray, sArray3);
            this.a(14, sArray, sArray2, sArray3);
            this.a(15, sArray2, sArray, sArray3);
            this.a(16, sArray, sArray2, sArray3);
            this.a(17, sArray2, sArray, sArray3);
            this.a(18, sArray, sArray2, sArray3);
            this.h(sArray2, sArray, sArray3);
        }

        protected void a(short[] sArray, short[] sArray2) {
            sArray2[0] = (short)(sArray[0] ^ sArray[5] ^ sArray[10] ^ sArray[15] ^ sArray[20]);
            sArray2[1] = (short)(sArray[1] ^ sArray[6] ^ sArray[11] ^ sArray[16] ^ sArray[21]);
            sArray2[2] = (short)(sArray[2] ^ sArray[7] ^ sArray[12] ^ sArray[17] ^ sArray[22]);
            sArray2[3] = (short)(sArray[3] ^ sArray[8] ^ sArray[13] ^ sArray[18] ^ sArray[23]);
            sArray2[4] = (short)(sArray[4] ^ sArray[9] ^ sArray[14] ^ sArray[19] ^ sArray[24]);
        }

        private short a(short s2, int n2) {
            return (short)((s2 & 0xFFFF) << n2 ^ (s2 & 0xFFFF) >>> 16 - n2);
        }

        protected void a(int n2, short[] sArray, short[] sArray2, short[] sArray3) {
            short s2 = (short)(sArray3[4] ^ this.a(sArray3[1], 1));
            short s3 = (short)(sArray3[0] ^ this.a(sArray3[2], 1));
            short s4 = (short)(sArray3[1] ^ this.a(sArray3[3], 1));
            short s5 = (short)(sArray3[2] ^ this.a(sArray3[4], 1));
            short s6 = (short)(sArray3[3] ^ this.a(sArray3[0], 1));
            short s7 = sArray[0] = (short)(sArray[0] ^ s2);
            sArray[6] = (short)(sArray[6] ^ s3);
            short s8 = this.a(sArray[6], 12);
            sArray[12] = (short)(sArray[12] ^ s4);
            short s9 = this.a(sArray[12], 11);
            sArray[18] = (short)(sArray[18] ^ s5);
            short s10 = this.a(sArray[18], 5);
            sArray[24] = (short)(sArray[24] ^ s6);
            short s11 = this.a(sArray[24], 14);
            sArray3[0] = sArray2[0] = (short)(s7 ^ ~s8 & s9 ^ this.k[n2]);
            sArray3[1] = sArray2[1] = (short)(s8 ^ ~s9 & s10);
            sArray3[2] = sArray2[2] = (short)(s9 ^ ~s10 & s11);
            sArray3[3] = sArray2[3] = (short)(s10 ^ ~s11 & s7);
            sArray3[4] = sArray2[4] = (short)(s11 ^ ~s7 & s8);
            sArray[3] = (short)(sArray[3] ^ s5);
            s7 = this.a(sArray[3], 12);
            sArray[9] = (short)(sArray[9] ^ s6);
            s8 = this.a(sArray[9], 4);
            sArray[10] = (short)(sArray[10] ^ s2);
            s9 = this.a(sArray[10], 3);
            sArray[16] = (short)(sArray[16] ^ s3);
            s10 = this.a(sArray[16], 13);
            sArray[22] = (short)(sArray[22] ^ s4);
            s11 = this.a(sArray[22], 13);
            sArray2[5] = (short)(s7 ^ ~s8 & s9);
            sArray3[0] = (short)(sArray3[0] ^ sArray2[5]);
            sArray2[6] = (short)(s8 ^ ~s9 & s10);
            sArray3[1] = (short)(sArray3[1] ^ sArray2[6]);
            sArray2[7] = (short)(s9 ^ ~s10 & s11);
            sArray3[2] = (short)(sArray3[2] ^ sArray2[7]);
            sArray2[8] = (short)(s10 ^ ~s11 & s7);
            sArray3[3] = (short)(sArray3[3] ^ sArray2[8]);
            sArray2[9] = (short)(s11 ^ ~s7 & s8);
            sArray3[4] = (short)(sArray3[4] ^ sArray2[9]);
            sArray[1] = (short)(sArray[1] ^ s3);
            s7 = this.a(sArray[1], 1);
            sArray[7] = (short)(sArray[7] ^ s4);
            s8 = this.a(sArray[7], 6);
            sArray[13] = (short)(sArray[13] ^ s5);
            s9 = this.a(sArray[13], 9);
            sArray[19] = (short)(sArray[19] ^ s6);
            s10 = this.a(sArray[19], 8);
            sArray[20] = (short)(sArray[20] ^ s2);
            s11 = this.a(sArray[20], 2);
            sArray2[10] = (short)(s7 ^ ~s8 & s9);
            sArray3[0] = (short)(sArray3[0] ^ sArray2[10]);
            sArray2[11] = (short)(s8 ^ ~s9 & s10);
            sArray3[1] = (short)(sArray3[1] ^ sArray2[11]);
            sArray2[12] = (short)(s9 ^ ~s10 & s11);
            sArray3[2] = (short)(sArray3[2] ^ sArray2[12]);
            sArray2[13] = (short)(s10 ^ ~s11 & s7);
            sArray3[3] = (short)(sArray3[3] ^ sArray2[13]);
            sArray2[14] = (short)(s11 ^ ~s7 & s8);
            sArray3[4] = (short)(sArray3[4] ^ sArray2[14]);
            sArray[4] = (short)(sArray[4] ^ s6);
            s7 = this.a(sArray[4], 11);
            sArray[5] = (short)(sArray[5] ^ s2);
            s8 = this.a(sArray[5], 4);
            sArray[11] = (short)(sArray[11] ^ s3);
            s9 = this.a(sArray[11], 10);
            sArray[17] = (short)(sArray[17] ^ s4);
            s10 = this.a(sArray[17], 15);
            sArray[23] = (short)(sArray[23] ^ s5);
            s11 = this.a(sArray[23], 8);
            sArray2[15] = (short)(s7 ^ ~s8 & s9);
            sArray3[0] = (short)(sArray3[0] ^ sArray2[15]);
            sArray2[16] = (short)(s8 ^ ~s9 & s10);
            sArray3[1] = (short)(sArray3[1] ^ sArray2[16]);
            sArray2[17] = (short)(s9 ^ ~s10 & s11);
            sArray3[2] = (short)(sArray3[2] ^ sArray2[17]);
            sArray2[18] = (short)(s10 ^ ~s11 & s7);
            sArray3[3] = (short)(sArray3[3] ^ sArray2[18]);
            sArray2[19] = (short)(s11 ^ ~s7 & s8);
            sArray3[4] = (short)(sArray3[4] ^ sArray2[19]);
            sArray[2] = (short)(sArray[2] ^ s4);
            s7 = this.a(sArray[2], 14);
            sArray[8] = (short)(sArray[8] ^ s5);
            s8 = this.a(sArray[8], 7);
            sArray[14] = (short)(sArray[14] ^ s6);
            s9 = this.a(sArray[14], 7);
            sArray[15] = (short)(sArray[15] ^ s2);
            s10 = this.a(sArray[15], 9);
            sArray[21] = (short)(sArray[21] ^ s3);
            s11 = this.a(sArray[21], 2);
            sArray2[20] = (short)(s7 ^ ~s8 & s9);
            sArray3[0] = (short)(sArray3[0] ^ sArray2[20]);
            sArray2[21] = (short)(s8 ^ ~s9 & s10);
            sArray3[1] = (short)(sArray3[1] ^ sArray2[21]);
            sArray2[22] = (short)(s9 ^ ~s10 & s11);
            sArray3[2] = (short)(sArray3[2] ^ sArray2[22]);
            sArray2[23] = (short)(s10 ^ ~s11 & s7);
            sArray3[3] = (short)(sArray3[3] ^ sArray2[23]);
            sArray2[24] = (short)(s11 ^ ~s7 & s8);
            sArray3[4] = (short)(sArray3[4] ^ sArray2[24]);
        }

        protected void h(short[] sArray, short[] sArray2, short[] sArray3) {
            short s2 = (short)(sArray3[4] ^ this.a(sArray3[1], 1));
            short s3 = (short)(sArray3[0] ^ this.a(sArray3[2], 1));
            short s4 = (short)(sArray3[1] ^ this.a(sArray3[3], 1));
            short s5 = (short)(sArray3[2] ^ this.a(sArray3[4], 1));
            short s6 = (short)(sArray3[3] ^ this.a(sArray3[0], 1));
            short s7 = sArray[0] = (short)(sArray[0] ^ s2);
            sArray[6] = (short)(sArray[6] ^ s3);
            short s8 = this.a(sArray[6], 12);
            sArray[12] = (short)(sArray[12] ^ s4);
            short s9 = this.a(sArray[12], 11);
            sArray[18] = (short)(sArray[18] ^ s5);
            short s10 = this.a(sArray[18], 5);
            sArray[24] = (short)(sArray[24] ^ s6);
            short s11 = this.a(sArray[24], 14);
            sArray2[0] = (short)(s7 ^ ~s8 & s9 ^ this.k[19]);
            sArray2[1] = (short)(s8 ^ ~s9 & s10);
            sArray2[2] = (short)(s9 ^ ~s10 & s11);
            sArray2[3] = (short)(s10 ^ ~s11 & s7);
            sArray2[4] = (short)(s11 ^ ~s7 & s8);
            sArray[3] = (short)(sArray[3] ^ s5);
            s7 = this.a(sArray[3], 12);
            sArray[9] = (short)(sArray[9] ^ s6);
            s8 = this.a(sArray[9], 4);
            sArray[10] = (short)(sArray[10] ^ s2);
            s9 = this.a(sArray[10], 3);
            sArray[16] = (short)(sArray[16] ^ s3);
            s10 = this.a(sArray[16], 13);
            sArray[22] = (short)(sArray[22] ^ s4);
            s11 = this.a(sArray[22], 13);
            sArray2[5] = (short)(s7 ^ ~s8 & s9);
            sArray2[6] = (short)(s8 ^ ~s9 & s10);
            sArray2[7] = (short)(s9 ^ ~s10 & s11);
            sArray2[8] = (short)(s10 ^ ~s11 & s7);
            sArray2[9] = (short)(s11 ^ ~s7 & s8);
            sArray[1] = (short)(sArray[1] ^ s3);
            s7 = this.a(sArray[1], 1);
            sArray[7] = (short)(sArray[7] ^ s4);
            s8 = this.a(sArray[7], 6);
            sArray[13] = (short)(sArray[13] ^ s5);
            s9 = this.a(sArray[13], 9);
            sArray[19] = (short)(sArray[19] ^ s6);
            s10 = this.a(sArray[19], 8);
            sArray[20] = (short)(sArray[20] ^ s2);
            s11 = this.a(sArray[20], 2);
            sArray2[10] = (short)(s7 ^ ~s8 & s9);
            sArray2[11] = (short)(s8 ^ ~s9 & s10);
            sArray2[12] = (short)(s9 ^ ~s10 & s11);
            sArray2[13] = (short)(s10 ^ ~s11 & s7);
            sArray2[14] = (short)(s11 ^ ~s7 & s8);
            sArray[4] = (short)(sArray[4] ^ s6);
            s7 = this.a(sArray[4], 11);
            sArray[5] = (short)(sArray[5] ^ s2);
            s8 = this.a(sArray[5], 4);
            sArray[11] = (short)(sArray[11] ^ s3);
            s9 = this.a(sArray[11], 10);
            sArray[17] = (short)(sArray[17] ^ s4);
            s10 = this.a(sArray[17], 15);
            sArray[23] = (short)(sArray[23] ^ s5);
            s11 = this.a(sArray[23], 8);
            sArray2[15] = (short)(s7 ^ ~s8 & s9);
            sArray2[16] = (short)(s8 ^ ~s9 & s10);
            sArray2[17] = (short)(s9 ^ ~s10 & s11);
            sArray2[18] = (short)(s10 ^ ~s11 & s7);
            sArray2[19] = (short)(s11 ^ ~s7 & s8);
            sArray[2] = (short)(sArray[2] ^ s4);
            s7 = this.a(sArray[2], 14);
            sArray[8] = (short)(sArray[8] ^ s5);
            s8 = this.a(sArray[8], 7);
            sArray[14] = (short)(sArray[14] ^ s6);
            s9 = this.a(sArray[14], 7);
            sArray[15] = (short)(sArray[15] ^ s2);
            s10 = this.a(sArray[15], 9);
            sArray[21] = (short)(sArray[21] ^ s3);
            s11 = this.a(sArray[21], 2);
            sArray2[20] = (short)(s7 ^ ~s8 & s9);
            sArray2[21] = (short)(s8 ^ ~s9 & s10);
            sArray2[22] = (short)(s9 ^ ~s10 & s11);
            sArray2[23] = (short)(s10 ^ ~s11 & s7);
            sArray2[24] = (short)(s11 ^ ~s7 & s8);
        }
    }

    private class a
    extends ISAPAEAD_A {
        public a() {
            this.ISAP_IV1_64 = 108156764298152972L;
            this.ISAP_IV2_64 = 180214358336080908L;
            this.ISAP_IV3_64 = 252271952374008844L;
        }

        @Override
        protected void PX1() {
            this.P12();
        }

        @Override
        protected void PX2() {
            this.P12();
        }
    }

    private class b
    extends ISAPAEAD_A {
        public b() {
            this.ISAP_IV1_64 = 108156764297430540L;
            this.ISAP_IV2_64 = 180214358335358476L;
            this.ISAP_IV3_64 = 252271952373286412L;
        }

        @Override
        protected void PX1() {
            this.P6();
        }

        @Override
        protected void PX2() {
            this.ROUND(75L);
        }
    }

    public abstract class ISAPAEAD_A
    implements f {
        protected long[] k64;
        protected long[] npub64;
        protected long ISAP_IV1_64;
        protected long ISAP_IV2_64;
        protected long ISAP_IV3_64;
        protected long x0;
        protected long x1;
        protected long x2;
        protected long x3;
        protected long x4;
        protected long t0;
        protected long t1;
        protected long t2;
        protected long t3;
        protected long t4;

        public ISAPAEAD_A() {
            ISAPEngine.this.o = 64;
            ISAPEngine.this.p = ISAPEngine.this.o + 7 >> 3;
        }

        @Override
        public void init() {
            this.npub64 = new long[this.a(ISAPEngine.this.j.length)];
            Pack.littleEndianToLong(ISAPEngine.this.j, 0, this.npub64, 0, this.npub64.length);
            this.npub64[0] = this.U64BIG(this.npub64[0]);
            this.npub64[1] = this.U64BIG(this.npub64[1]);
            this.k64 = new long[this.a(ISAPEngine.this.g.length)];
            Pack.littleEndianToLong(ISAPEngine.this.g, 0, this.k64, 0, this.k64.length);
            this.k64[0] = this.U64BIG(this.k64[0]);
            this.k64[1] = this.U64BIG(this.k64[1]);
            this.reset();
        }

        protected abstract void PX1();

        protected abstract void PX2();

        protected void ABSORB_MAC(byte[] src, int len) {
            long[] lArray = new long[src.length >> 3];
            Pack.littleEndianToLong(src, 0, lArray, 0, lArray.length);
            int n2 = 0;
            while (len >= ISAPEngine.this.p) {
                this.x0 ^= this.U64BIG(lArray[n2++]);
                this.P12();
                len -= ISAPEngine.this.p;
            }
            for (int i2 = 0; i2 < len; ++i2) {
                this.x0 ^= ((long)src[(n2 << 3) + i2] & 0xFFL) << (7 - i2 << 3);
            }
            this.x0 ^= 128L << (7 - len << 3);
            this.P12();
        }

        @Override
        public void isap_mac(byte[] ad, int adlen, byte[] c2, int clen, byte[] tag, int tagOff) {
            this.x0 = this.npub64[0];
            this.x1 = this.npub64[1];
            this.x2 = this.ISAP_IV1_64;
            this.x4 = 0L;
            this.x3 = 0L;
            this.P12();
            this.ABSORB_MAC(ad, adlen);
            this.x4 ^= 1L;
            this.ABSORB_MAC(c2, clen);
            Pack.longToLittleEndian(this.U64BIG(this.x0), tag, 0);
            Pack.longToLittleEndian(this.U64BIG(this.x1), tag, 8);
            long l2 = this.x2;
            long l3 = this.x3;
            long l4 = this.x4;
            this.isap_rk(this.ISAP_IV2_64, tag, 16);
            this.x2 = l2;
            this.x3 = l3;
            this.x4 = l4;
            this.P12();
            Pack.longToLittleEndian(this.U64BIG(this.x0), tag, tagOff);
            Pack.longToLittleEndian(this.U64BIG(this.x1), tag, tagOff + 8);
        }

        public void isap_rk(long iv64, byte[] y, int ylen) {
            this.x0 = this.k64[0];
            this.x1 = this.k64[1];
            this.x2 = iv64;
            this.x4 = 0L;
            this.x3 = 0L;
            this.P12();
            for (int i2 = 0; i2 < (ylen << 3) - 1; ++i2) {
                this.x0 ^= ((long)((y[i2 >>> 3] >>> 7 - (i2 & 7) & 1) << 7) & 0xFFL) << 56;
                this.PX2();
            }
            this.x0 ^= ((long)y[ylen - 1] & 1L) << 7 << 56;
            this.P12();
        }

        @Override
        public void isap_enc(byte[] m2, int mOff, int mlen, byte[] c2, int cOff, int clen) {
            long[] lArray = new long[mlen >> 3];
            Pack.littleEndianToLong(m2, mOff, lArray, 0, lArray.length);
            long[] lArray2 = new long[lArray.length];
            int n2 = 0;
            while (mlen >= ISAPEngine.this.p) {
                lArray2[n2] = this.U64BIG(this.x0) ^ lArray[n2];
                this.PX1();
                ++n2;
                mlen -= ISAPEngine.this.p;
            }
            Pack.longToLittleEndian(lArray2, 0, lArray2.length, c2, cOff);
            byte[] byArray = Pack.longToLittleEndian(this.x0);
            while (mlen > 0) {
                c2[(n2 << 3) + cOff + mlen - 1] = (byte)(byArray[ISAPEngine.this.p - mlen] ^ m2[(n2 << 3) + mOff + --mlen]);
            }
        }

        @Override
        public void reset() {
            this.isap_rk(this.ISAP_IV3_64, ISAPEngine.this.j, 16);
            this.x3 = this.npub64[0];
            this.x4 = this.npub64[1];
            this.PX1();
        }

        private int a(int n2) {
            return (n2 >>> 3) + ((n2 & 7) != 0 ? 1 : 0);
        }

        private long a(long l2, long l3) {
            return l2 >>> (int)l3 | l2 << (int)(64L - l3);
        }

        protected long U64BIG(long x) {
            return this.a(x, 8L) & 0xFF000000FF000000L | this.a(x, 24L) & 0xFF000000FF0000L | this.a(x, 40L) & 0xFF000000FF00L | this.a(x, 56L) & 0xFF000000FFL;
        }

        protected void ROUND(long C) {
            this.t0 = this.x0 ^ this.x1 ^ this.x2 ^ this.x3 ^ C ^ this.x1 & (this.x0 ^ this.x2 ^ this.x4 ^ C);
            this.t1 = this.x0 ^ this.x2 ^ this.x3 ^ this.x4 ^ C ^ (this.x1 ^ this.x2 ^ C) & (this.x1 ^ this.x3);
            this.t2 = this.x1 ^ this.x2 ^ this.x4 ^ C ^ this.x3 & this.x4;
            this.t3 = this.x0 ^ this.x1 ^ this.x2 ^ C ^ (this.x0 ^ 0xFFFFFFFFFFFFFFFFL) & (this.x3 ^ this.x4);
            this.t4 = this.x1 ^ this.x3 ^ this.x4 ^ (this.x0 ^ this.x4) & this.x1;
            this.x0 = this.t0 ^ this.a(this.t0, 19L) ^ this.a(this.t0, 28L);
            this.x1 = this.t1 ^ this.a(this.t1, 39L) ^ this.a(this.t1, 61L);
            this.x2 = this.t2 ^ this.a(this.t2, 1L) ^ this.a(this.t2, 6L) ^ 0xFFFFFFFFFFFFFFFFL;
            this.x3 = this.t3 ^ this.a(this.t3, 10L) ^ this.a(this.t3, 17L);
            this.x4 = this.t4 ^ this.a(this.t4, 7L) ^ this.a(this.t4, 41L);
        }

        public void P12() {
            this.ROUND(240L);
            this.ROUND(225L);
            this.ROUND(210L);
            this.ROUND(195L);
            this.ROUND(180L);
            this.ROUND(165L);
            this.P6();
        }

        protected void P6() {
            this.ROUND(150L);
            this.ROUND(135L);
            this.ROUND(120L);
            this.ROUND(105L);
            this.ROUND(90L);
            this.ROUND(75L);
        }
    }

    private static interface f {
        public void isap_enc(byte[] var1, int var2, int var3, byte[] var4, int var5, int var6);

        public void init();

        public void isap_mac(byte[] var1, int var2, byte[] var3, int var4, byte[] var5, int var6);

        public void reset();
    }

    public static enum IsapType {
        ISAP_A_128A,
        ISAP_K_128A,
        ISAP_A_128,
        ISAP_K_128;

    }
}

