/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.engines;

import com.enterprisedt.bouncycastle.crypto.AsymmetricBlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.constraints.ConstraintUtils;
import com.enterprisedt.bouncycastle.crypto.constraints.DefaultServiceProperties;
import com.enterprisedt.bouncycastle.crypto.engines.c;
import com.enterprisedt.bouncycastle.crypto.params.NaccacheSternKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.NaccacheSternPrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.math.BigInteger;
import java.util.Vector;

public class NaccacheSternEngine
implements AsymmetricBlockCipher {
    private boolean a;
    private NaccacheSternKeyParameters b;
    private Vector[] c = null;
    private boolean d = false;
    private static BigInteger e = BigInteger.valueOf(0L);
    private static BigInteger f = BigInteger.valueOf(1L);

    @Override
    public void init(boolean forEncryption, CipherParameters param) {
        this.a = forEncryption;
        if (param instanceof ParametersWithRandom) {
            param = ((ParametersWithRandom)param).getParameters();
        }
        this.b = (NaccacheSternKeyParameters)param;
        if (!this.a) {
            if (this.d) {
                System.out.println("Constructing lookup Array");
            }
            NaccacheSternPrivateKeyParameters naccacheSternPrivateKeyParameters = (NaccacheSternPrivateKeyParameters)this.b;
            Vector vector = naccacheSternPrivateKeyParameters.getSmallPrimes();
            this.c = new Vector[vector.size()];
            for (int i2 = 0; i2 < vector.size(); ++i2) {
                BigInteger bigInteger = (BigInteger)vector.elementAt(i2);
                int n2 = bigInteger.intValue();
                this.c[i2] = new Vector();
                this.c[i2].addElement(f);
                if (this.d) {
                    System.out.println("Constructing lookup ArrayList for " + n2);
                }
                BigInteger bigInteger2 = e;
                for (int i3 = 1; i3 < n2; ++i3) {
                    bigInteger2 = bigInteger2.add(naccacheSternPrivateKeyParameters.getPhi_n());
                    BigInteger bigInteger3 = bigInteger2.divide(bigInteger);
                    this.c[i2].addElement(naccacheSternPrivateKeyParameters.getG().modPow(bigInteger3, naccacheSternPrivateKeyParameters.getModulus()));
                }
            }
        }
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("NaccacheStern", ConstraintUtils.bitsOfSecurityFor(this.b.getModulus()), param, com.enterprisedt.bouncycastle.crypto.engines.c.a(forEncryption)));
    }

    public void setDebug(boolean debug) {
        this.d = debug;
    }

    @Override
    public int getInputBlockSize() {
        if (this.a) {
            return (this.b.getLowerSigmaBound() + 7) / 8 - 1;
        }
        return this.b.getModulus().toByteArray().length;
    }

    @Override
    public int getOutputBlockSize() {
        if (this.a) {
            return this.b.getModulus().toByteArray().length;
        }
        return (this.b.getLowerSigmaBound() + 7) / 8 - 1;
    }

    @Override
    public byte[] processBlock(byte[] in, int inOff, int len) throws InvalidCipherTextException {
        byte[] byArray;
        byte[] byArray2;
        if (this.b == null) {
            throw new IllegalStateException("NaccacheStern engine not initialised");
        }
        if (len > this.getInputBlockSize() + 1) {
            throw new DataLengthException("input too large for Naccache-Stern cipher.\n");
        }
        if (!this.a && len < this.getInputBlockSize()) {
            throw new InvalidCipherTextException("BlockLength does not match modulus for Naccache-Stern cipher.\n");
        }
        if (inOff != 0 || len != in.length) {
            byArray2 = new byte[len];
            System.arraycopy(in, inOff, byArray2, 0, len);
        } else {
            byArray2 = in;
        }
        BigInteger bigInteger = new BigInteger(1, byArray2);
        if (this.d) {
            System.out.println("input as BigInteger: " + bigInteger);
        }
        if (this.a) {
            byArray = this.encrypt(bigInteger);
        } else {
            Vector<BigInteger> vector = new Vector<BigInteger>();
            NaccacheSternPrivateKeyParameters naccacheSternPrivateKeyParameters = (NaccacheSternPrivateKeyParameters)this.b;
            Vector vector2 = naccacheSternPrivateKeyParameters.getSmallPrimes();
            for (int i2 = 0; i2 < vector2.size(); ++i2) {
                BigInteger bigInteger2 = bigInteger.modPow(naccacheSternPrivateKeyParameters.getPhi_n().divide((BigInteger)vector2.elementAt(i2)), naccacheSternPrivateKeyParameters.getModulus());
                Vector vector3 = this.c[i2];
                if (this.c[i2].size() != ((BigInteger)vector2.elementAt(i2)).intValue()) {
                    if (this.d) {
                        System.out.println("Prime is " + vector2.elementAt(i2) + ", lookup table has size " + vector3.size());
                    }
                    throw new InvalidCipherTextException("Error in lookup Array for " + ((BigInteger)vector2.elementAt(i2)).intValue() + ": Size mismatch. Expected ArrayList with length " + ((BigInteger)vector2.elementAt(i2)).intValue() + " but found ArrayList of length " + this.c[i2].size());
                }
                int n2 = vector3.indexOf(bigInteger2);
                if (n2 == -1) {
                    if (this.d) {
                        System.out.println("Actual prime is " + vector2.elementAt(i2));
                        System.out.println("Decrypted value is " + bigInteger2);
                        System.out.println("LookupList for " + vector2.elementAt(i2) + " with size " + this.c[i2].size() + " is: ");
                        for (int i3 = 0; i3 < this.c[i2].size(); ++i3) {
                            System.out.println(this.c[i2].elementAt(i3));
                        }
                    }
                    throw new InvalidCipherTextException("Lookup failed");
                }
                vector.addElement(BigInteger.valueOf(n2));
            }
            BigInteger bigInteger3 = NaccacheSternEngine.a(vector, vector2);
            byArray = bigInteger3.toByteArray();
        }
        return byArray;
    }

    public byte[] encrypt(BigInteger plain) {
        byte[] byArray = this.b.getModulus().toByteArray();
        Arrays.fill(byArray, (byte)0);
        byte[] byArray2 = this.b.getG().modPow(plain, this.b.getModulus()).toByteArray();
        System.arraycopy(byArray2, 0, byArray, byArray.length - byArray2.length, byArray2.length);
        if (this.d) {
            System.out.println("Encrypted value is:  " + new BigInteger(byArray));
        }
        return byArray;
    }

    public byte[] addCryptedBlocks(byte[] block1, byte[] block2) throws InvalidCipherTextException {
        if (this.a ? block1.length > this.getOutputBlockSize() || block2.length > this.getOutputBlockSize() : block1.length > this.getInputBlockSize() || block2.length > this.getInputBlockSize()) {
            throw new InvalidCipherTextException("BlockLength too large for simple addition.\n");
        }
        BigInteger bigInteger = new BigInteger(1, block1);
        BigInteger bigInteger2 = new BigInteger(1, block2);
        BigInteger bigInteger3 = bigInteger.multiply(bigInteger2);
        bigInteger3 = bigInteger3.mod(this.b.getModulus());
        if (this.d) {
            System.out.println("c(m1) as BigInteger:....... " + bigInteger);
            System.out.println("c(m2) as BigInteger:....... " + bigInteger2);
            System.out.println("c(m1)*c(m2)%n = c(m1+m2)%n: " + bigInteger3);
        }
        byte[] byArray = this.b.getModulus().toByteArray();
        Arrays.fill(byArray, (byte)0);
        System.arraycopy(bigInteger3.toByteArray(), 0, byArray, byArray.length - bigInteger3.toByteArray().length, bigInteger3.toByteArray().length);
        return byArray;
    }

    public byte[] processData(byte[] data) throws InvalidCipherTextException {
        if (this.d) {
            System.out.println();
        }
        if (data.length > this.getInputBlockSize()) {
            byte[] byArray;
            int n2 = this.getInputBlockSize();
            int n3 = this.getOutputBlockSize();
            if (this.d) {
                System.out.println("Input blocksize is:  " + n2 + " bytes");
                System.out.println("Output blocksize is: " + n3 + " bytes");
                System.out.println("Data has length:.... " + data.length + " bytes");
            }
            int n4 = 0;
            int n5 = 0;
            byte[] byArray2 = new byte[(data.length / n2 + 1) * n3];
            while (n4 < data.length) {
                if (n4 + n2 < data.length) {
                    byArray = this.processBlock(data, n4, n2);
                    n4 += n2;
                } else {
                    byArray = this.processBlock(data, n4, data.length - n4);
                    n4 += data.length - n4;
                }
                if (this.d) {
                    System.out.println("new datapos is " + n4);
                }
                if (byArray != null) {
                    System.arraycopy(byArray, 0, byArray2, n5, byArray.length);
                    n5 += byArray.length;
                    continue;
                }
                if (this.d) {
                    System.out.println("cipher returned null");
                }
                throw new InvalidCipherTextException("cipher returned null");
            }
            byArray = new byte[n5];
            System.arraycopy(byArray2, 0, byArray, 0, n5);
            if (this.d) {
                System.out.println("returning " + byArray.length + " bytes");
            }
            return byArray;
        }
        if (this.d) {
            System.out.println("data size is less then input block size, processing directly");
        }
        return this.processBlock(data, 0, data.length);
    }

    private static BigInteger a(Vector vector, Vector vector2) {
        int n2;
        BigInteger bigInteger = e;
        BigInteger bigInteger2 = f;
        for (n2 = 0; n2 < vector2.size(); ++n2) {
            bigInteger2 = bigInteger2.multiply((BigInteger)vector2.elementAt(n2));
        }
        for (n2 = 0; n2 < vector2.size(); ++n2) {
            BigInteger bigInteger3 = (BigInteger)vector2.elementAt(n2);
            BigInteger bigInteger4 = bigInteger2.divide(bigInteger3);
            BigInteger bigInteger5 = bigInteger4.modInverse(bigInteger3);
            BigInteger bigInteger6 = bigInteger4.multiply(bigInteger5);
            bigInteger6 = bigInteger6.multiply((BigInteger)vector.elementAt(n2));
            bigInteger = bigInteger.add(bigInteger6);
        }
        return bigInteger.mod(bigInteger2);
    }
}

