/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.engines;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.constraints.DefaultServiceProperties;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.TweakableBlockCipherParameters;
import com.enterprisedt.bouncycastle.util.Pack;

public class ThreefishEngine
implements BlockCipher {
    public static final int BLOCKSIZE_256 = 256;
    public static final int BLOCKSIZE_512 = 512;
    public static final int BLOCKSIZE_1024 = 1024;
    private static int[] a = new int[80];
    private static int[] b = new int[a.length];
    private static int[] c = new int[a.length];
    private static int[] d = new int[a.length];
    private int e;
    private int f;
    private long[] g;
    private long[] h = new long[5];
    private long[] i;
    private d j;
    private boolean k;

    public ThreefishEngine(int blocksizeBits) {
        this.e = blocksizeBits / 8;
        this.f = this.e / 8;
        this.g = new long[this.f];
        this.i = new long[2 * this.f + 1];
        switch (blocksizeBits) {
            case 256: {
                this.j = new b(this.i, this.h);
                break;
            }
            case 512: {
                this.j = new c(this.i, this.h);
                break;
            }
            case 1024: {
                this.j = new a(this.i, this.h);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid blocksize - Threefish is defined with block size of 256, 512, or 1024 bits");
            }
        }
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        byte[] byArray;
        byte[] byArray2;
        Object object;
        if (params instanceof TweakableBlockCipherParameters) {
            object = (TweakableBlockCipherParameters)params;
            byArray2 = ((TweakableBlockCipherParameters)object).getKey().getKey();
            byArray = ((TweakableBlockCipherParameters)object).getTweak();
        } else if (params instanceof KeyParameter) {
            byArray2 = ((KeyParameter)params).getKey();
            byArray = null;
        } else {
            throw new IllegalArgumentException("Invalid parameter passed to Threefish init - " + params.getClass().getName());
        }
        object = null;
        long[] lArray = null;
        if (byArray2 != null) {
            if (byArray2.length != this.e) {
                throw new IllegalArgumentException("Threefish key must be same size as block (" + this.e + " bytes)");
            }
            object = new long[this.f];
            Pack.littleEndianToLong(byArray2, 0, (long[])object);
        }
        if (byArray != null) {
            if (byArray.length != 16) {
                throw new IllegalArgumentException("Threefish tweak must be 16 bytes");
            }
            lArray = new long[2];
            Pack.littleEndianToLong(byArray, 0, lArray);
        }
        this.init(forEncryption, (long[])object, lArray);
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties(this.getAlgorithmName(), 256, params, com.enterprisedt.bouncycastle.crypto.engines.c.a(forEncryption)));
    }

    public void init(boolean forEncryption, long[] key, long[] tweak) {
        this.k = forEncryption;
        if (key != null) {
            this.a(key);
        }
        if (tweak != null) {
            this.b(tweak);
        }
    }

    private void a(long[] lArray) {
        if (lArray.length != this.f) {
            throw new IllegalArgumentException("Threefish key must be same size as block (" + this.f + " words)");
        }
        long l2 = 2004413935125273122L;
        for (int i2 = 0; i2 < this.f; ++i2) {
            this.i[i2] = lArray[i2];
            l2 ^= this.i[i2];
        }
        this.i[this.f] = l2;
        System.arraycopy(this.i, 0, this.i, this.f + 1, this.f);
    }

    private void b(long[] lArray) {
        if (lArray.length != 2) {
            throw new IllegalArgumentException("Tweak must be 2 words.");
        }
        this.h[0] = lArray[0];
        this.h[1] = lArray[1];
        this.h[2] = this.h[0] ^ this.h[1];
        this.h[3] = this.h[0];
        this.h[4] = this.h[1];
    }

    @Override
    public String getAlgorithmName() {
        return "Threefish-" + this.e * 8;
    }

    @Override
    public int getBlockSize() {
        return this.e;
    }

    @Override
    public void reset() {
    }

    @Override
    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        if (inOff + this.e > in.length) {
            throw new DataLengthException("Input buffer too short");
        }
        if (outOff + this.e > out.length) {
            throw new OutputLengthException("Output buffer too short");
        }
        Pack.littleEndianToLong(in, inOff, this.g);
        this.processBlock(this.g, this.g);
        Pack.longToLittleEndian(this.g, out, outOff);
        return this.e;
    }

    public int processBlock(long[] in, long[] out) throws DataLengthException, IllegalStateException {
        if (this.i[this.f] == 0L) {
            throw new IllegalStateException("Threefish engine not initialised");
        }
        if (in.length != this.f) {
            throw new DataLengthException("Input buffer too short");
        }
        if (out.length != this.f) {
            throw new OutputLengthException("Output buffer too short");
        }
        if (this.k) {
            this.j.a(in, out);
        } else {
            this.j.b(in, out);
        }
        return this.f;
    }

    public static long bytesToWord(byte[] bytes, int off) {
        return Pack.littleEndianToLong(bytes, off);
    }

    public static void wordToBytes(long word, byte[] bytes, int off) {
        Pack.longToLittleEndian(word, bytes, off);
    }

    static long a(long l2, int n2, long l3) {
        return (l2 << n2 | l2 >>> -n2) ^ l3;
    }

    static long b(long l2, int n2, long l3) {
        long l4 = l2 ^ l3;
        return l4 >>> n2 | l4 << -n2;
    }

    static {
        for (int i2 = 0; i2 < a.length; ++i2) {
            ThreefishEngine.b[i2] = i2 % 17;
            ThreefishEngine.a[i2] = i2 % 9;
            ThreefishEngine.c[i2] = i2 % 5;
            ThreefishEngine.d[i2] = i2 % 3;
        }
    }

    private static final class a
    extends d {
        public a(long[] lArray, long[] lArray2) {
            super(lArray, lArray2);
        }

        @Override
        void a(long[] lArray, long[] lArray2) {
            long[] lArray3 = this.b;
            long[] lArray4 = this.a;
            int[] nArray = b;
            int[] nArray2 = d;
            if (lArray3.length != 33) {
                throw new IllegalArgumentException();
            }
            if (lArray4.length != 5) {
                throw new IllegalArgumentException();
            }
            long l2 = lArray[0];
            long l3 = lArray[1];
            long l4 = lArray[2];
            long l5 = lArray[3];
            long l6 = lArray[4];
            long l7 = lArray[5];
            long l8 = lArray[6];
            long l9 = lArray[7];
            long l10 = lArray[8];
            long l11 = lArray[9];
            long l12 = lArray[10];
            long l13 = lArray[11];
            long l14 = lArray[12];
            long l15 = lArray[13];
            long l16 = lArray[14];
            long l17 = lArray[15];
            l2 += lArray3[0];
            l3 += lArray3[1];
            l4 += lArray3[2];
            l5 += lArray3[3];
            l6 += lArray3[4];
            l7 += lArray3[5];
            l8 += lArray3[6];
            l9 += lArray3[7];
            l10 += lArray3[8];
            l11 += lArray3[9];
            l12 += lArray3[10];
            l13 += lArray3[11];
            l14 += lArray3[12];
            l15 += lArray3[13] + lArray4[0];
            l16 += lArray3[14] + lArray4[1];
            l17 += lArray3[15];
            for (int i2 = 1; i2 < 20; i2 += 2) {
                int n2 = nArray[i2];
                int n3 = nArray2[i2];
                l2 += l3;
                l3 = ThreefishEngine.a(l3, 24, l2);
                l4 += l5;
                l5 = ThreefishEngine.a(l5, 13, l4);
                l6 += l7;
                l7 = ThreefishEngine.a(l7, 8, l6);
                l8 += l9;
                l9 = ThreefishEngine.a(l9, 47, l8);
                l10 += l11;
                l11 = ThreefishEngine.a(l11, 8, l10);
                l12 += l13;
                l13 = ThreefishEngine.a(l13, 17, l12);
                l14 += l15;
                l15 = ThreefishEngine.a(l15, 22, l14);
                l16 += l17;
                l17 = ThreefishEngine.a(l17, 37, l16);
                l2 += l11;
                l11 = ThreefishEngine.a(l11, 38, l2);
                l4 += l15;
                l15 = ThreefishEngine.a(l15, 19, l4);
                l8 += l13;
                l13 = ThreefishEngine.a(l13, 10, l8);
                l6 += l17;
                l17 = ThreefishEngine.a(l17, 55, l6);
                l12 += l9;
                l9 = ThreefishEngine.a(l9, 49, l12);
                l14 += l5;
                l5 = ThreefishEngine.a(l5, 18, l14);
                l16 += l7;
                l7 = ThreefishEngine.a(l7, 23, l16);
                l10 += l3;
                l3 = ThreefishEngine.a(l3, 52, l10);
                l2 += l9;
                l9 = ThreefishEngine.a(l9, 33, l2);
                l4 += l7;
                l7 = ThreefishEngine.a(l7, 4, l4);
                l6 += l5;
                l5 = ThreefishEngine.a(l5, 51, l6);
                l8 += l3;
                l3 = ThreefishEngine.a(l3, 13, l8);
                l14 += l17;
                l17 = ThreefishEngine.a(l17, 34, l14);
                l16 += l15;
                l15 = ThreefishEngine.a(l15, 41, l16);
                l10 += l13;
                l13 = ThreefishEngine.a(l13, 59, l10);
                l12 += l11;
                l11 = ThreefishEngine.a(l11, 17, l12);
                l2 += l17;
                l17 = ThreefishEngine.a(l17, 5, l2);
                l4 += l13;
                l13 = ThreefishEngine.a(l13, 20, l4);
                l8 += l15;
                l15 = ThreefishEngine.a(l15, 48, l8);
                l6 += l11;
                l11 = ThreefishEngine.a(l11, 41, l6);
                l16 += l3;
                l3 = ThreefishEngine.a(l3, 47, l16);
                l10 += l7;
                l7 = ThreefishEngine.a(l7, 28, l10);
                l12 += l5;
                l5 = ThreefishEngine.a(l5, 16, l12);
                l14 += l9;
                l9 = ThreefishEngine.a(l9, 25, l14);
                l2 += lArray3[n2];
                l3 += lArray3[n2 + 1];
                l4 += lArray3[n2 + 2];
                l5 += lArray3[n2 + 3];
                l6 += lArray3[n2 + 4];
                l7 += lArray3[n2 + 5];
                l8 += lArray3[n2 + 6];
                l9 += lArray3[n2 + 7];
                l10 += lArray3[n2 + 8];
                l11 += lArray3[n2 + 9];
                l12 += lArray3[n2 + 10];
                l13 += lArray3[n2 + 11];
                l14 += lArray3[n2 + 12];
                l15 += lArray3[n2 + 13] + lArray4[n3];
                l16 += lArray3[n2 + 14] + lArray4[n3 + 1];
                l17 += lArray3[n2 + 15] + (long)i2;
                l2 += l3;
                l3 = ThreefishEngine.a(l3, 41, l2);
                l4 += l5;
                l5 = ThreefishEngine.a(l5, 9, l4);
                l6 += l7;
                l7 = ThreefishEngine.a(l7, 37, l6);
                l8 += l9;
                l9 = ThreefishEngine.a(l9, 31, l8);
                l10 += l11;
                l11 = ThreefishEngine.a(l11, 12, l10);
                l12 += l13;
                l13 = ThreefishEngine.a(l13, 47, l12);
                l14 += l15;
                l15 = ThreefishEngine.a(l15, 44, l14);
                l16 += l17;
                l17 = ThreefishEngine.a(l17, 30, l16);
                l2 += l11;
                l11 = ThreefishEngine.a(l11, 16, l2);
                l4 += l15;
                l15 = ThreefishEngine.a(l15, 34, l4);
                l8 += l13;
                l13 = ThreefishEngine.a(l13, 56, l8);
                l6 += l17;
                l17 = ThreefishEngine.a(l17, 51, l6);
                l12 += l9;
                l9 = ThreefishEngine.a(l9, 4, l12);
                l14 += l5;
                l5 = ThreefishEngine.a(l5, 53, l14);
                l16 += l7;
                l7 = ThreefishEngine.a(l7, 42, l16);
                l10 += l3;
                l3 = ThreefishEngine.a(l3, 41, l10);
                l2 += l9;
                l9 = ThreefishEngine.a(l9, 31, l2);
                l4 += l7;
                l7 = ThreefishEngine.a(l7, 44, l4);
                l6 += l5;
                l5 = ThreefishEngine.a(l5, 47, l6);
                l8 += l3;
                l3 = ThreefishEngine.a(l3, 46, l8);
                l14 += l17;
                l17 = ThreefishEngine.a(l17, 19, l14);
                l16 += l15;
                l15 = ThreefishEngine.a(l15, 42, l16);
                l10 += l13;
                l13 = ThreefishEngine.a(l13, 44, l10);
                l12 += l11;
                l11 = ThreefishEngine.a(l11, 25, l12);
                l2 += l17;
                l17 = ThreefishEngine.a(l17, 9, l2);
                l4 += l13;
                l13 = ThreefishEngine.a(l13, 48, l4);
                l8 += l15;
                l15 = ThreefishEngine.a(l15, 35, l8);
                l6 += l11;
                l11 = ThreefishEngine.a(l11, 52, l6);
                l16 += l3;
                l3 = ThreefishEngine.a(l3, 23, l16);
                l10 += l7;
                l7 = ThreefishEngine.a(l7, 31, l10);
                l12 += l5;
                l5 = ThreefishEngine.a(l5, 37, l12);
                l14 += l9;
                l9 = ThreefishEngine.a(l9, 20, l14);
                l2 += lArray3[n2 + 1];
                l3 += lArray3[n2 + 2];
                l4 += lArray3[n2 + 3];
                l5 += lArray3[n2 + 4];
                l6 += lArray3[n2 + 5];
                l7 += lArray3[n2 + 6];
                l8 += lArray3[n2 + 7];
                l9 += lArray3[n2 + 8];
                l10 += lArray3[n2 + 9];
                l11 += lArray3[n2 + 10];
                l12 += lArray3[n2 + 11];
                l13 += lArray3[n2 + 12];
                l14 += lArray3[n2 + 13];
                l15 += lArray3[n2 + 14] + lArray4[n3 + 1];
                l16 += lArray3[n2 + 15] + lArray4[n3 + 2];
                l17 += lArray3[n2 + 16] + (long)i2 + 1L;
            }
            lArray2[0] = l2;
            lArray2[1] = l3;
            lArray2[2] = l4;
            lArray2[3] = l5;
            lArray2[4] = l6;
            lArray2[5] = l7;
            lArray2[6] = l8;
            lArray2[7] = l9;
            lArray2[8] = l10;
            lArray2[9] = l11;
            lArray2[10] = l12;
            lArray2[11] = l13;
            lArray2[12] = l14;
            lArray2[13] = l15;
            lArray2[14] = l16;
            lArray2[15] = l17;
        }

        @Override
        void b(long[] lArray, long[] lArray2) {
            long[] lArray3 = this.b;
            long[] lArray4 = this.a;
            int[] nArray = b;
            int[] nArray2 = d;
            if (lArray3.length != 33) {
                throw new IllegalArgumentException();
            }
            if (lArray4.length != 5) {
                throw new IllegalArgumentException();
            }
            long l2 = lArray[0];
            long l3 = lArray[1];
            long l4 = lArray[2];
            long l5 = lArray[3];
            long l6 = lArray[4];
            long l7 = lArray[5];
            long l8 = lArray[6];
            long l9 = lArray[7];
            long l10 = lArray[8];
            long l11 = lArray[9];
            long l12 = lArray[10];
            long l13 = lArray[11];
            long l14 = lArray[12];
            long l15 = lArray[13];
            long l16 = lArray[14];
            long l17 = lArray[15];
            for (int i2 = 19; i2 >= 1; i2 -= 2) {
                int n2 = nArray[i2];
                int n3 = nArray2[i2];
                l2 -= lArray3[n2 + 1];
                l3 -= lArray3[n2 + 2];
                l4 -= lArray3[n2 + 3];
                l5 -= lArray3[n2 + 4];
                l6 -= lArray3[n2 + 5];
                l7 -= lArray3[n2 + 6];
                l8 -= lArray3[n2 + 7];
                l9 -= lArray3[n2 + 8];
                l10 -= lArray3[n2 + 9];
                l11 -= lArray3[n2 + 10];
                l12 -= lArray3[n2 + 11];
                l13 -= lArray3[n2 + 12];
                l14 -= lArray3[n2 + 13];
                l15 -= lArray3[n2 + 14] + lArray4[n3 + 1];
                l16 -= lArray3[n2 + 15] + lArray4[n3 + 2];
                l17 -= lArray3[n2 + 16] + (long)i2 + 1L;
                l17 = ThreefishEngine.b(l17, 9, l2);
                l2 -= l17;
                l13 = ThreefishEngine.b(l13, 48, l4);
                l4 -= l13;
                l15 = ThreefishEngine.b(l15, 35, l8);
                l8 -= l15;
                l11 = ThreefishEngine.b(l11, 52, l6);
                l6 -= l11;
                l3 = ThreefishEngine.b(l3, 23, l16);
                l16 -= l3;
                l7 = ThreefishEngine.b(l7, 31, l10);
                l10 -= l7;
                l5 = ThreefishEngine.b(l5, 37, l12);
                l12 -= l5;
                l9 = ThreefishEngine.b(l9, 20, l14);
                l14 -= l9;
                l9 = ThreefishEngine.b(l9, 31, l2);
                l2 -= l9;
                l7 = ThreefishEngine.b(l7, 44, l4);
                l4 -= l7;
                l5 = ThreefishEngine.b(l5, 47, l6);
                l6 -= l5;
                l3 = ThreefishEngine.b(l3, 46, l8);
                l8 -= l3;
                l17 = ThreefishEngine.b(l17, 19, l14);
                l14 -= l17;
                l15 = ThreefishEngine.b(l15, 42, l16);
                l16 -= l15;
                l13 = ThreefishEngine.b(l13, 44, l10);
                l10 -= l13;
                l11 = ThreefishEngine.b(l11, 25, l12);
                l12 -= l11;
                l11 = ThreefishEngine.b(l11, 16, l2);
                l2 -= l11;
                l15 = ThreefishEngine.b(l15, 34, l4);
                l4 -= l15;
                l13 = ThreefishEngine.b(l13, 56, l8);
                l8 -= l13;
                l17 = ThreefishEngine.b(l17, 51, l6);
                l6 -= l17;
                l9 = ThreefishEngine.b(l9, 4, l12);
                l12 -= l9;
                l5 = ThreefishEngine.b(l5, 53, l14);
                l14 -= l5;
                l7 = ThreefishEngine.b(l7, 42, l16);
                l16 -= l7;
                l3 = ThreefishEngine.b(l3, 41, l10);
                l10 -= l3;
                l3 = ThreefishEngine.b(l3, 41, l2);
                l2 -= l3;
                l5 = ThreefishEngine.b(l5, 9, l4);
                l4 -= l5;
                l7 = ThreefishEngine.b(l7, 37, l6);
                l6 -= l7;
                l9 = ThreefishEngine.b(l9, 31, l8);
                l8 -= l9;
                l11 = ThreefishEngine.b(l11, 12, l10);
                l10 -= l11;
                l13 = ThreefishEngine.b(l13, 47, l12);
                l12 -= l13;
                l15 = ThreefishEngine.b(l15, 44, l14);
                l14 -= l15;
                l17 = ThreefishEngine.b(l17, 30, l16);
                l16 -= l17;
                l2 -= lArray3[n2];
                l3 -= lArray3[n2 + 1];
                l4 -= lArray3[n2 + 2];
                l5 -= lArray3[n2 + 3];
                l6 -= lArray3[n2 + 4];
                l7 -= lArray3[n2 + 5];
                l8 -= lArray3[n2 + 6];
                l9 -= lArray3[n2 + 7];
                l10 -= lArray3[n2 + 8];
                l11 -= lArray3[n2 + 9];
                l12 -= lArray3[n2 + 10];
                l13 -= lArray3[n2 + 11];
                l14 -= lArray3[n2 + 12];
                l15 -= lArray3[n2 + 13] + lArray4[n3];
                l16 -= lArray3[n2 + 14] + lArray4[n3 + 1];
                l17 -= lArray3[n2 + 15] + (long)i2;
                l17 = ThreefishEngine.b(l17, 5, l2);
                l2 -= l17;
                l13 = ThreefishEngine.b(l13, 20, l4);
                l4 -= l13;
                l15 = ThreefishEngine.b(l15, 48, l8);
                l8 -= l15;
                l11 = ThreefishEngine.b(l11, 41, l6);
                l6 -= l11;
                l3 = ThreefishEngine.b(l3, 47, l16);
                l16 -= l3;
                l7 = ThreefishEngine.b(l7, 28, l10);
                l10 -= l7;
                l5 = ThreefishEngine.b(l5, 16, l12);
                l12 -= l5;
                l9 = ThreefishEngine.b(l9, 25, l14);
                l14 -= l9;
                l9 = ThreefishEngine.b(l9, 33, l2);
                l2 -= l9;
                l7 = ThreefishEngine.b(l7, 4, l4);
                l4 -= l7;
                l5 = ThreefishEngine.b(l5, 51, l6);
                l6 -= l5;
                l3 = ThreefishEngine.b(l3, 13, l8);
                l8 -= l3;
                l17 = ThreefishEngine.b(l17, 34, l14);
                l14 -= l17;
                l15 = ThreefishEngine.b(l15, 41, l16);
                l16 -= l15;
                l13 = ThreefishEngine.b(l13, 59, l10);
                l10 -= l13;
                l11 = ThreefishEngine.b(l11, 17, l12);
                l12 -= l11;
                l11 = ThreefishEngine.b(l11, 38, l2);
                l2 -= l11;
                l15 = ThreefishEngine.b(l15, 19, l4);
                l4 -= l15;
                l13 = ThreefishEngine.b(l13, 10, l8);
                l8 -= l13;
                l17 = ThreefishEngine.b(l17, 55, l6);
                l6 -= l17;
                l9 = ThreefishEngine.b(l9, 49, l12);
                l12 -= l9;
                l5 = ThreefishEngine.b(l5, 18, l14);
                l14 -= l5;
                l7 = ThreefishEngine.b(l7, 23, l16);
                l16 -= l7;
                l3 = ThreefishEngine.b(l3, 52, l10);
                l10 -= l3;
                l3 = ThreefishEngine.b(l3, 24, l2);
                l2 -= l3;
                l5 = ThreefishEngine.b(l5, 13, l4);
                l4 -= l5;
                l7 = ThreefishEngine.b(l7, 8, l6);
                l6 -= l7;
                l9 = ThreefishEngine.b(l9, 47, l8);
                l8 -= l9;
                l11 = ThreefishEngine.b(l11, 8, l10);
                l10 -= l11;
                l13 = ThreefishEngine.b(l13, 17, l12);
                l12 -= l13;
                l15 = ThreefishEngine.b(l15, 22, l14);
                l14 -= l15;
                l17 = ThreefishEngine.b(l17, 37, l16);
                l16 -= l17;
            }
            l2 -= lArray3[0];
            l3 -= lArray3[1];
            l4 -= lArray3[2];
            l5 -= lArray3[3];
            l6 -= lArray3[4];
            l7 -= lArray3[5];
            l8 -= lArray3[6];
            l9 -= lArray3[7];
            l10 -= lArray3[8];
            l11 -= lArray3[9];
            l12 -= lArray3[10];
            l13 -= lArray3[11];
            l14 -= lArray3[12];
            l15 -= lArray3[13] + lArray4[0];
            l16 -= lArray3[14] + lArray4[1];
            l17 -= lArray3[15];
            lArray2[0] = l2;
            lArray2[1] = l3;
            lArray2[2] = l4;
            lArray2[3] = l5;
            lArray2[4] = l6;
            lArray2[5] = l7;
            lArray2[6] = l8;
            lArray2[7] = l9;
            lArray2[8] = l10;
            lArray2[9] = l11;
            lArray2[10] = l12;
            lArray2[11] = l13;
            lArray2[12] = l14;
            lArray2[13] = l15;
            lArray2[14] = l16;
            lArray2[15] = l17;
        }
    }

    private static final class c
    extends d {
        protected c(long[] lArray, long[] lArray2) {
            super(lArray, lArray2);
        }

        @Override
        public void a(long[] lArray, long[] lArray2) {
            long[] lArray3 = this.b;
            long[] lArray4 = this.a;
            int[] nArray = a;
            int[] nArray2 = d;
            if (lArray3.length != 17) {
                throw new IllegalArgumentException();
            }
            if (lArray4.length != 5) {
                throw new IllegalArgumentException();
            }
            long l2 = lArray[0];
            long l3 = lArray[1];
            long l4 = lArray[2];
            long l5 = lArray[3];
            long l6 = lArray[4];
            long l7 = lArray[5];
            long l8 = lArray[6];
            long l9 = lArray[7];
            l2 += lArray3[0];
            l3 += lArray3[1];
            l4 += lArray3[2];
            l5 += lArray3[3];
            l6 += lArray3[4];
            l7 += lArray3[5] + lArray4[0];
            l8 += lArray3[6] + lArray4[1];
            l9 += lArray3[7];
            for (int i2 = 1; i2 < 18; i2 += 2) {
                int n2 = nArray[i2];
                int n3 = nArray2[i2];
                l2 += l3;
                l3 = ThreefishEngine.a(l3, 46, l2);
                l4 += l5;
                l5 = ThreefishEngine.a(l5, 36, l4);
                l6 += l7;
                l7 = ThreefishEngine.a(l7, 19, l6);
                l8 += l9;
                l9 = ThreefishEngine.a(l9, 37, l8);
                l4 += l3;
                l3 = ThreefishEngine.a(l3, 33, l4);
                l6 += l9;
                l9 = ThreefishEngine.a(l9, 27, l6);
                l8 += l7;
                l7 = ThreefishEngine.a(l7, 14, l8);
                l2 += l5;
                l5 = ThreefishEngine.a(l5, 42, l2);
                l6 += l3;
                l3 = ThreefishEngine.a(l3, 17, l6);
                l8 += l5;
                l5 = ThreefishEngine.a(l5, 49, l8);
                l2 += l7;
                l7 = ThreefishEngine.a(l7, 36, l2);
                l4 += l9;
                l9 = ThreefishEngine.a(l9, 39, l4);
                l8 += l3;
                l3 = ThreefishEngine.a(l3, 44, l8);
                l2 += l9;
                l9 = ThreefishEngine.a(l9, 9, l2);
                l4 += l7;
                l7 = ThreefishEngine.a(l7, 54, l4);
                l6 += l5;
                l5 = ThreefishEngine.a(l5, 56, l6);
                l2 += lArray3[n2];
                l3 += lArray3[n2 + 1];
                l4 += lArray3[n2 + 2];
                l5 += lArray3[n2 + 3];
                l6 += lArray3[n2 + 4];
                l7 += lArray3[n2 + 5] + lArray4[n3];
                l8 += lArray3[n2 + 6] + lArray4[n3 + 1];
                l9 += lArray3[n2 + 7] + (long)i2;
                l2 += l3;
                l3 = ThreefishEngine.a(l3, 39, l2);
                l4 += l5;
                l5 = ThreefishEngine.a(l5, 30, l4);
                l6 += l7;
                l7 = ThreefishEngine.a(l7, 34, l6);
                l8 += l9;
                l9 = ThreefishEngine.a(l9, 24, l8);
                l4 += l3;
                l3 = ThreefishEngine.a(l3, 13, l4);
                l6 += l9;
                l9 = ThreefishEngine.a(l9, 50, l6);
                l8 += l7;
                l7 = ThreefishEngine.a(l7, 10, l8);
                l2 += l5;
                l5 = ThreefishEngine.a(l5, 17, l2);
                l6 += l3;
                l3 = ThreefishEngine.a(l3, 25, l6);
                l8 += l5;
                l5 = ThreefishEngine.a(l5, 29, l8);
                l2 += l7;
                l7 = ThreefishEngine.a(l7, 39, l2);
                l4 += l9;
                l9 = ThreefishEngine.a(l9, 43, l4);
                l8 += l3;
                l3 = ThreefishEngine.a(l3, 8, l8);
                l2 += l9;
                l9 = ThreefishEngine.a(l9, 35, l2);
                l4 += l7;
                l7 = ThreefishEngine.a(l7, 56, l4);
                l6 += l5;
                l5 = ThreefishEngine.a(l5, 22, l6);
                l2 += lArray3[n2 + 1];
                l3 += lArray3[n2 + 2];
                l4 += lArray3[n2 + 3];
                l5 += lArray3[n2 + 4];
                l6 += lArray3[n2 + 5];
                l7 += lArray3[n2 + 6] + lArray4[n3 + 1];
                l8 += lArray3[n2 + 7] + lArray4[n3 + 2];
                l9 += lArray3[n2 + 8] + (long)i2 + 1L;
            }
            lArray2[0] = l2;
            lArray2[1] = l3;
            lArray2[2] = l4;
            lArray2[3] = l5;
            lArray2[4] = l6;
            lArray2[5] = l7;
            lArray2[6] = l8;
            lArray2[7] = l9;
        }

        @Override
        public void b(long[] lArray, long[] lArray2) {
            long[] lArray3 = this.b;
            long[] lArray4 = this.a;
            int[] nArray = a;
            int[] nArray2 = d;
            if (lArray3.length != 17) {
                throw new IllegalArgumentException();
            }
            if (lArray4.length != 5) {
                throw new IllegalArgumentException();
            }
            long l2 = lArray[0];
            long l3 = lArray[1];
            long l4 = lArray[2];
            long l5 = lArray[3];
            long l6 = lArray[4];
            long l7 = lArray[5];
            long l8 = lArray[6];
            long l9 = lArray[7];
            for (int i2 = 17; i2 >= 1; i2 -= 2) {
                int n2 = nArray[i2];
                int n3 = nArray2[i2];
                l2 -= lArray3[n2 + 1];
                l3 -= lArray3[n2 + 2];
                l4 -= lArray3[n2 + 3];
                l5 -= lArray3[n2 + 4];
                l6 -= lArray3[n2 + 5];
                l7 -= lArray3[n2 + 6] + lArray4[n3 + 1];
                l9 -= lArray3[n2 + 8] + (long)i2 + 1L;
                l3 = ThreefishEngine.b(l3, 8, l8 -= lArray3[n2 + 7] + lArray4[n3 + 2]);
                l8 -= l3;
                l9 = ThreefishEngine.b(l9, 35, l2);
                l2 -= l9;
                l7 = ThreefishEngine.b(l7, 56, l4);
                l4 -= l7;
                l5 = ThreefishEngine.b(l5, 22, l6);
                l3 = ThreefishEngine.b(l3, 25, l6 -= l5);
                l6 -= l3;
                l5 = ThreefishEngine.b(l5, 29, l8);
                l8 -= l5;
                l7 = ThreefishEngine.b(l7, 39, l2);
                l2 -= l7;
                l9 = ThreefishEngine.b(l9, 43, l4);
                l3 = ThreefishEngine.b(l3, 13, l4 -= l9);
                l4 -= l3;
                l9 = ThreefishEngine.b(l9, 50, l6);
                l6 -= l9;
                l7 = ThreefishEngine.b(l7, 10, l8);
                l8 -= l7;
                l5 = ThreefishEngine.b(l5, 17, l2);
                l3 = ThreefishEngine.b(l3, 39, l2 -= l5);
                l2 -= l3;
                l5 = ThreefishEngine.b(l5, 30, l4);
                l4 -= l5;
                l7 = ThreefishEngine.b(l7, 34, l6);
                l6 -= l7;
                l9 = ThreefishEngine.b(l9, 24, l8);
                l8 -= l9;
                l2 -= lArray3[n2];
                l3 -= lArray3[n2 + 1];
                l4 -= lArray3[n2 + 2];
                l5 -= lArray3[n2 + 3];
                l6 -= lArray3[n2 + 4];
                l7 -= lArray3[n2 + 5] + lArray4[n3];
                l9 -= lArray3[n2 + 7] + (long)i2;
                l3 = ThreefishEngine.b(l3, 44, l8 -= lArray3[n2 + 6] + lArray4[n3 + 1]);
                l8 -= l3;
                l9 = ThreefishEngine.b(l9, 9, l2);
                l2 -= l9;
                l7 = ThreefishEngine.b(l7, 54, l4);
                l4 -= l7;
                l5 = ThreefishEngine.b(l5, 56, l6);
                l3 = ThreefishEngine.b(l3, 17, l6 -= l5);
                l6 -= l3;
                l5 = ThreefishEngine.b(l5, 49, l8);
                l8 -= l5;
                l7 = ThreefishEngine.b(l7, 36, l2);
                l2 -= l7;
                l9 = ThreefishEngine.b(l9, 39, l4);
                l3 = ThreefishEngine.b(l3, 33, l4 -= l9);
                l4 -= l3;
                l9 = ThreefishEngine.b(l9, 27, l6);
                l6 -= l9;
                l7 = ThreefishEngine.b(l7, 14, l8);
                l8 -= l7;
                l5 = ThreefishEngine.b(l5, 42, l2);
                l3 = ThreefishEngine.b(l3, 46, l2 -= l5);
                l2 -= l3;
                l5 = ThreefishEngine.b(l5, 36, l4);
                l4 -= l5;
                l7 = ThreefishEngine.b(l7, 19, l6);
                l6 -= l7;
                l9 = ThreefishEngine.b(l9, 37, l8);
                l8 -= l9;
            }
            l2 -= lArray3[0];
            l3 -= lArray3[1];
            l4 -= lArray3[2];
            l5 -= lArray3[3];
            l6 -= lArray3[4];
            l7 -= lArray3[5] + lArray4[0];
            l8 -= lArray3[6] + lArray4[1];
            l9 -= lArray3[7];
            lArray2[0] = l2;
            lArray2[1] = l3;
            lArray2[2] = l4;
            lArray2[3] = l5;
            lArray2[4] = l6;
            lArray2[5] = l7;
            lArray2[6] = l8;
            lArray2[7] = l9;
        }
    }

    private static final class b
    extends d {
        public b(long[] lArray, long[] lArray2) {
            super(lArray, lArray2);
        }

        @Override
        void a(long[] lArray, long[] lArray2) {
            long[] lArray3 = this.b;
            long[] lArray4 = this.a;
            int[] nArray = c;
            int[] nArray2 = d;
            if (lArray3.length != 9) {
                throw new IllegalArgumentException();
            }
            if (lArray4.length != 5) {
                throw new IllegalArgumentException();
            }
            long l2 = lArray[0];
            long l3 = lArray[1];
            long l4 = lArray[2];
            long l5 = lArray[3];
            l2 += lArray3[0];
            l3 += lArray3[1] + lArray4[0];
            l4 += lArray3[2] + lArray4[1];
            l5 += lArray3[3];
            for (int i2 = 1; i2 < 18; i2 += 2) {
                int n2 = nArray[i2];
                int n3 = nArray2[i2];
                l2 += l3;
                l3 = ThreefishEngine.a(l3, 14, l2);
                l4 += l5;
                l5 = ThreefishEngine.a(l5, 16, l4);
                l2 += l5;
                l5 = ThreefishEngine.a(l5, 52, l2);
                l4 += l3;
                l3 = ThreefishEngine.a(l3, 57, l4);
                l2 += l3;
                l3 = ThreefishEngine.a(l3, 23, l2);
                l4 += l5;
                l5 = ThreefishEngine.a(l5, 40, l4);
                l2 += l5;
                l5 = ThreefishEngine.a(l5, 5, l2);
                l4 += l3;
                l3 = ThreefishEngine.a(l3, 37, l4);
                l2 += lArray3[n2];
                l4 += lArray3[n2 + 2] + lArray4[n3 + 1];
                l3 = ThreefishEngine.a(l3, 25, l2 += (l3 += lArray3[n2 + 1] + lArray4[n3]));
                l5 = ThreefishEngine.a(l5, 33, l4 += (l5 += lArray3[n2 + 3] + (long)i2));
                l2 += l5;
                l5 = ThreefishEngine.a(l5, 46, l2);
                l4 += l3;
                l3 = ThreefishEngine.a(l3, 12, l4);
                l2 += l3;
                l3 = ThreefishEngine.a(l3, 58, l2);
                l4 += l5;
                l5 = ThreefishEngine.a(l5, 22, l4);
                l2 += l5;
                l5 = ThreefishEngine.a(l5, 32, l2);
                l4 += l3;
                l3 = ThreefishEngine.a(l3, 32, l4);
                l2 += lArray3[n2 + 1];
                l3 += lArray3[n2 + 2] + lArray4[n3 + 1];
                l4 += lArray3[n2 + 3] + lArray4[n3 + 2];
                l5 += lArray3[n2 + 4] + (long)i2 + 1L;
            }
            lArray2[0] = l2;
            lArray2[1] = l3;
            lArray2[2] = l4;
            lArray2[3] = l5;
        }

        @Override
        void b(long[] lArray, long[] lArray2) {
            long[] lArray3 = this.b;
            long[] lArray4 = this.a;
            int[] nArray = c;
            int[] nArray2 = d;
            if (lArray3.length != 9) {
                throw new IllegalArgumentException();
            }
            if (lArray4.length != 5) {
                throw new IllegalArgumentException();
            }
            long l2 = lArray[0];
            long l3 = lArray[1];
            long l4 = lArray[2];
            long l5 = lArray[3];
            for (int i2 = 17; i2 >= 1; i2 -= 2) {
                int n2 = nArray[i2];
                int n3 = nArray2[i2];
                l3 -= lArray3[n2 + 2] + lArray4[n3 + 1];
                l5 -= lArray3[n2 + 4] + (long)i2 + 1L;
                l5 = ThreefishEngine.b(l5, 32, l2 -= lArray3[n2 + 1]);
                l3 = ThreefishEngine.b(l3, 32, l4 -= lArray3[n2 + 3] + lArray4[n3 + 2]);
                l4 -= l3;
                l3 = ThreefishEngine.b(l3, 58, l2 -= l5);
                l5 = ThreefishEngine.b(l5, 22, l4);
                l4 -= l5;
                l5 = ThreefishEngine.b(l5, 46, l2 -= l3);
                l3 = ThreefishEngine.b(l3, 12, l4);
                l4 -= l3;
                l3 = ThreefishEngine.b(l3, 25, l2 -= l5);
                l2 -= l3;
                l5 = ThreefishEngine.b(l5, 33, l4);
                l4 -= l5;
                l3 -= lArray3[n2 + 1] + lArray4[n3];
                l5 -= lArray3[n2 + 3] + (long)i2;
                l5 = ThreefishEngine.b(l5, 5, l2 -= lArray3[n2]);
                l3 = ThreefishEngine.b(l3, 37, l4 -= lArray3[n2 + 2] + lArray4[n3 + 1]);
                l4 -= l3;
                l3 = ThreefishEngine.b(l3, 23, l2 -= l5);
                l5 = ThreefishEngine.b(l5, 40, l4);
                l4 -= l5;
                l5 = ThreefishEngine.b(l5, 52, l2 -= l3);
                l3 = ThreefishEngine.b(l3, 57, l4);
                l4 -= l3;
                l3 = ThreefishEngine.b(l3, 14, l2 -= l5);
                l2 -= l3;
                l5 = ThreefishEngine.b(l5, 16, l4);
                l4 -= l5;
            }
            lArray2[0] = l2 -= lArray3[0];
            lArray2[1] = l3 -= lArray3[1] + lArray4[0];
            lArray2[2] = l4 -= lArray3[2] + lArray4[1];
            lArray2[3] = l5 -= lArray3[3];
        }
    }

    private static abstract class d {
        protected final long[] a;
        protected final long[] b;

        protected d(long[] lArray, long[] lArray2) {
            this.b = lArray;
            this.a = lArray2;
        }

        abstract void a(long[] var1, long[] var2);

        abstract void b(long[] var1, long[] var2);
    }
}

