/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.engines;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicePurpose;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.StreamCipher;
import com.enterprisedt.bouncycastle.crypto.constraints.DefaultServiceProperties;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;
import com.enterprisedt.bouncycastle.util.Memoable;

public class Zuc128CoreEngine
implements StreamCipher,
Memoable {
    private static final byte[] a = new byte[]{62, 114, 91, 71, -54, -32, 0, 51, 4, -47, 84, -104, 9, -71, 109, -53, 123, 27, -7, 50, -81, -99, 106, -91, -72, 45, -4, 29, 8, 83, 3, -112, 77, 78, -124, -103, -28, -50, -39, -111, -35, -74, -123, 72, -117, 41, 110, -84, -51, -63, -8, 30, 115, 67, 105, -58, -75, -67, -3, 57, 99, 32, -44, 56, 118, 125, -78, -89, -49, -19, 87, -59, -13, 44, -69, 20, 33, 6, 85, -101, -29, -17, 94, 49, 79, 127, 90, -92, 13, -126, 81, 73, 95, -70, 88, 28, 74, 22, -43, 23, -88, -110, 36, 31, -116, -1, -40, -82, 46, 1, -45, -83, 59, 75, -38, 70, -21, -55, -34, -102, -113, -121, -41, 58, -128, 111, 47, -56, -79, -76, 55, -9, 10, 34, 19, 40, 124, -52, 60, -119, -57, -61, -106, 86, 7, -65, 126, -16, 11, 43, -105, 82, 53, 65, 121, 97, -90, 76, 16, -2, -68, 38, -107, -120, -118, -80, -93, -5, -64, 24, -108, -14, -31, -27, -23, 93, -48, -36, 17, 102, 100, 92, -20, 89, 66, 117, 18, -11, 116, -100, -86, 35, 14, -122, -85, -66, 42, 2, -25, 103, -26, 68, -94, 108, -62, -109, -97, -15, -10, -6, 54, -46, 80, 104, -98, 98, 113, 21, 61, -42, 64, -60, -30, 15, -114, -125, 119, 107, 37, 5, 63, 12, 48, -22, 112, -73, -95, -24, -87, 101, -115, 39, 26, -37, -127, -77, -96, -12, 69, 122, 25, -33, -18, 120, 52, 96};
    private static final byte[] b = new byte[]{85, -62, 99, 113, 59, -56, 71, -122, -97, 60, -38, 91, 41, -86, -3, 119, -116, -59, -108, 12, -90, 26, 19, 0, -29, -88, 22, 114, 64, -7, -8, 66, 68, 38, 104, -106, -127, -39, 69, 62, 16, 118, -58, -89, -117, 57, 67, -31, 58, -75, 86, 42, -64, 109, -77, 5, 34, 102, -65, -36, 11, -6, 98, 72, -35, 32, 17, 6, 54, -55, -63, -49, -10, 39, 82, -69, 105, -11, -44, -121, 127, -124, 76, -46, -100, 87, -92, -68, 79, -102, -33, -2, -42, -115, 122, -21, 43, 83, -40, 92, -95, 20, 23, -5, 35, -43, 125, 48, 103, 115, 8, 9, -18, -73, 112, 63, 97, -78, 25, -114, 78, -27, 75, -109, -113, 93, -37, -87, -83, -15, -82, 46, -53, 13, -4, -12, 45, 70, 110, 29, -105, -24, -47, -23, 77, 55, -91, 117, 94, -125, -98, -85, -126, -99, -71, 28, -32, -51, 73, -119, 1, -74, -67, 88, 36, -94, 95, 56, 120, -103, 21, -112, 80, -72, -107, -28, -48, -111, -57, -50, -19, 15, -76, 111, -96, -52, -16, 2, 74, 121, -61, -34, -93, -17, -22, 81, -26, 107, 24, -20, 27, 44, -128, -9, 116, -25, -1, 33, 90, 106, 84, 30, 65, 49, -110, 53, -60, 51, 7, 10, -70, 126, 14, 52, -120, -79, -104, 124, -13, 61, 96, 108, 123, -54, -45, 31, 50, 101, 4, 40, 100, -66, -123, -101, 47, 89, -118, -41, -80, 37, -84, -81, 18, 3, -30, -14};
    private static final short[] c = new short[]{17623, 9916, 25195, 4958, 22409, 13794, 28981, 2479, 19832, 12051, 27588, 6897, 24102, 15437, 30874, 18348};
    private final int[] d = new int[16];
    private final int[] e = new int[2];
    private final int[] f = new int[4];
    private int g;
    private final byte[] h = new byte[4];
    private int i;
    private Zuc128CoreEngine j;

    protected Zuc128CoreEngine() {
    }

    protected Zuc128CoreEngine(Zuc128CoreEngine pSource) {
        this.reset(pSource);
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) {
        CipherParameters cipherParameters;
        CipherParameters cipherParameters2 = params;
        byte[] byArray = null;
        byte[] byArray2 = null;
        if (cipherParameters2 instanceof ParametersWithIV) {
            cipherParameters = (ParametersWithIV)cipherParameters2;
            byArray2 = ((ParametersWithIV)cipherParameters).getIV();
            cipherParameters2 = ((ParametersWithIV)cipherParameters).getParameters();
        }
        if (cipherParameters2 instanceof KeyParameter) {
            cipherParameters = (KeyParameter)cipherParameters2;
            byArray = ((KeyParameter)cipherParameters).getKey();
        }
        this.g = 0;
        this.i = 0;
        this.a(byArray, byArray2);
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties(this.getAlgorithmName(), byArray.length * 8, params, forEncryption ? CryptoServicePurpose.ENCRYPTION : CryptoServicePurpose.DECRYPTION));
        this.j = (Zuc128CoreEngine)this.copy();
    }

    protected int getMaxIterations() {
        return 2047;
    }

    @Override
    public String getAlgorithmName() {
        return "Zuc-128";
    }

    @Override
    public int processBytes(byte[] in, int inOff, int len, byte[] out, int outOff) {
        if (this.j == null) {
            throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
        }
        if (inOff + len > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + len > out.length) {
            throw new OutputLengthException("output buffer too short");
        }
        for (int i2 = 0; i2 < len; ++i2) {
            out[i2 + outOff] = this.returnByte(in[i2 + inOff]);
        }
        return len;
    }

    @Override
    public void reset() {
        if (this.j != null) {
            this.reset(this.j);
        }
    }

    @Override
    public byte returnByte(byte in) {
        if (this.g == 0) {
            this.d();
        }
        byte by = (byte)(this.h[this.g] ^ in);
        this.g = (this.g + 1) % 4;
        return by;
    }

    public static void encode32be(int val, byte[] buf, int off) {
        buf[off] = (byte)(val >> 24);
        buf[off + 1] = (byte)(val >> 16);
        buf[off + 2] = (byte)(val >> 8);
        buf[off + 3] = (byte)val;
    }

    private int b(int n2, int n3) {
        int n4 = n2 + n3;
        return (n4 & Integer.MAX_VALUE) + (n4 >>> 31);
    }

    private static int c(int n2, int n3) {
        return (n2 << n3 | n2 >>> 31 - n3) & Integer.MAX_VALUE;
    }

    private void a(int n2) {
        int n3 = this.d[0];
        int n4 = Zuc128CoreEngine.c(this.d[0], 8);
        n3 = this.b(n3, n4);
        n4 = Zuc128CoreEngine.c(this.d[4], 20);
        n3 = this.b(n3, n4);
        n4 = Zuc128CoreEngine.c(this.d[10], 21);
        n3 = this.b(n3, n4);
        n4 = Zuc128CoreEngine.c(this.d[13], 17);
        n3 = this.b(n3, n4);
        n4 = Zuc128CoreEngine.c(this.d[15], 15);
        n3 = this.b(n3, n4);
        n3 = this.b(n3, n2);
        this.d[0] = this.d[1];
        this.d[1] = this.d[2];
        this.d[2] = this.d[3];
        this.d[3] = this.d[4];
        this.d[4] = this.d[5];
        this.d[5] = this.d[6];
        this.d[6] = this.d[7];
        this.d[7] = this.d[8];
        this.d[8] = this.d[9];
        this.d[9] = this.d[10];
        this.d[10] = this.d[11];
        this.d[11] = this.d[12];
        this.d[12] = this.d[13];
        this.d[13] = this.d[14];
        this.d[14] = this.d[15];
        this.d[15] = n3;
    }

    private void b() {
        int n2 = this.d[0];
        int n3 = Zuc128CoreEngine.c(this.d[0], 8);
        n2 = this.b(n2, n3);
        n3 = Zuc128CoreEngine.c(this.d[4], 20);
        n2 = this.b(n2, n3);
        n3 = Zuc128CoreEngine.c(this.d[10], 21);
        n2 = this.b(n2, n3);
        n3 = Zuc128CoreEngine.c(this.d[13], 17);
        n2 = this.b(n2, n3);
        n3 = Zuc128CoreEngine.c(this.d[15], 15);
        n2 = this.b(n2, n3);
        this.d[0] = this.d[1];
        this.d[1] = this.d[2];
        this.d[2] = this.d[3];
        this.d[3] = this.d[4];
        this.d[4] = this.d[5];
        this.d[5] = this.d[6];
        this.d[6] = this.d[7];
        this.d[7] = this.d[8];
        this.d[8] = this.d[9];
        this.d[9] = this.d[10];
        this.d[10] = this.d[11];
        this.d[11] = this.d[12];
        this.d[12] = this.d[13];
        this.d[13] = this.d[14];
        this.d[14] = this.d[15];
        this.d[15] = n2;
    }

    private void c() {
        this.f[0] = (this.d[15] & 0x7FFF8000) << 1 | this.d[14] & 0xFFFF;
        this.f[1] = (this.d[11] & 0xFFFF) << 16 | this.d[9] >>> 15;
        this.f[2] = (this.d[7] & 0xFFFF) << 16 | this.d[5] >>> 15;
        this.f[3] = (this.d[2] & 0xFFFF) << 16 | this.d[0] >>> 15;
    }

    static int a(int n2, int n3) {
        return n2 << n3 | n2 >>> 32 - n3;
    }

    private static int b(int n2) {
        return n2 ^ Zuc128CoreEngine.a(n2, 2) ^ Zuc128CoreEngine.a(n2, 10) ^ Zuc128CoreEngine.a(n2, 18) ^ Zuc128CoreEngine.a(n2, 24);
    }

    private static int c(int n2) {
        return n2 ^ Zuc128CoreEngine.a(n2, 8) ^ Zuc128CoreEngine.a(n2, 14) ^ Zuc128CoreEngine.a(n2, 22) ^ Zuc128CoreEngine.a(n2, 30);
    }

    private static int a(byte by, byte by2, byte by3, byte by4) {
        return (by & 0xFF) << 24 | (by2 & 0xFF) << 16 | (by3 & 0xFF) << 8 | by4 & 0xFF;
    }

    int a() {
        int n2 = (this.f[0] ^ this.e[0]) + this.e[1];
        int n3 = this.e[0] + this.f[1];
        int n4 = this.e[1] ^ this.f[2];
        int n5 = Zuc128CoreEngine.b(n3 << 16 | n4 >>> 16);
        int n6 = Zuc128CoreEngine.c(n4 << 16 | n3 >>> 16);
        this.e[0] = Zuc128CoreEngine.a(a[n5 >>> 24], b[n5 >>> 16 & 0xFF], a[n5 >>> 8 & 0xFF], b[n5 & 0xFF]);
        this.e[1] = Zuc128CoreEngine.a(a[n6 >>> 24], b[n6 >>> 16 & 0xFF], a[n6 >>> 8 & 0xFF], b[n6 & 0xFF]);
        return n2;
    }

    private static int a(byte by, short s2, byte by2) {
        return (by & 0xFF) << 23 | (s2 & 0xFFFF) << 8 | by2 & 0xFF;
    }

    protected void setKeyAndIV(int[] pLFSR, byte[] k2, byte[] iv) {
        if (k2 == null || k2.length != 16) {
            throw new IllegalArgumentException("A key of 16 bytes is needed");
        }
        if (iv == null || iv.length != 16) {
            throw new IllegalArgumentException("An IV of 16 bytes is needed");
        }
        this.d[0] = Zuc128CoreEngine.a(k2[0], c[0], iv[0]);
        this.d[1] = Zuc128CoreEngine.a(k2[1], c[1], iv[1]);
        this.d[2] = Zuc128CoreEngine.a(k2[2], c[2], iv[2]);
        this.d[3] = Zuc128CoreEngine.a(k2[3], c[3], iv[3]);
        this.d[4] = Zuc128CoreEngine.a(k2[4], c[4], iv[4]);
        this.d[5] = Zuc128CoreEngine.a(k2[5], c[5], iv[5]);
        this.d[6] = Zuc128CoreEngine.a(k2[6], c[6], iv[6]);
        this.d[7] = Zuc128CoreEngine.a(k2[7], c[7], iv[7]);
        this.d[8] = Zuc128CoreEngine.a(k2[8], c[8], iv[8]);
        this.d[9] = Zuc128CoreEngine.a(k2[9], c[9], iv[9]);
        this.d[10] = Zuc128CoreEngine.a(k2[10], c[10], iv[10]);
        this.d[11] = Zuc128CoreEngine.a(k2[11], c[11], iv[11]);
        this.d[12] = Zuc128CoreEngine.a(k2[12], c[12], iv[12]);
        this.d[13] = Zuc128CoreEngine.a(k2[13], c[13], iv[13]);
        this.d[14] = Zuc128CoreEngine.a(k2[14], c[14], iv[14]);
        this.d[15] = Zuc128CoreEngine.a(k2[15], c[15], iv[15]);
    }

    private void a(byte[] byArray, byte[] byArray2) {
        this.setKeyAndIV(this.d, byArray, byArray2);
        this.e[0] = 0;
        this.e[1] = 0;
        for (int i2 = 32; i2 > 0; --i2) {
            this.c();
            int n2 = this.a();
            this.a(n2 >>> 1);
        }
        this.c();
        this.a();
        this.b();
    }

    private void d() {
        Zuc128CoreEngine.encode32be(this.makeKeyStreamWord(), this.h, 0);
    }

    protected int makeKeyStreamWord() {
        if (this.i++ >= this.getMaxIterations()) {
            throw new IllegalStateException("Too much data processed by singleKey/IV");
        }
        this.c();
        int n2 = this.a() ^ this.f[3];
        this.b();
        return n2;
    }

    @Override
    public Memoable copy() {
        return new Zuc128CoreEngine(this);
    }

    @Override
    public void reset(Memoable pState) {
        Zuc128CoreEngine zuc128CoreEngine = (Zuc128CoreEngine)pState;
        System.arraycopy(zuc128CoreEngine.d, 0, this.d, 0, this.d.length);
        System.arraycopy(zuc128CoreEngine.e, 0, this.e, 0, this.e.length);
        System.arraycopy(zuc128CoreEngine.f, 0, this.f, 0, this.f.length);
        System.arraycopy(zuc128CoreEngine.h, 0, this.h, 0, this.h.length);
        this.g = zuc128CoreEngine.g;
        this.i = zuc128CoreEngine.i;
        this.j = zuc128CoreEngine;
    }
}

