/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.fpe;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.params.FPEParameters;
import com.enterprisedt.bouncycastle.util.Pack;

public abstract class FPEEngine {
    protected final BlockCipher baseCipher;
    protected boolean forEncryption;
    protected FPEParameters fpeParameters;

    protected FPEEngine(BlockCipher baseCipher) {
        this.baseCipher = baseCipher;
    }

    public int processBlock(byte[] inBuf, int inOff, int length, byte[] outBuf, int outOff) {
        if (this.fpeParameters == null) {
            throw new IllegalStateException("FPE engine not initialized");
        }
        if (length < 0) {
            throw new IllegalArgumentException("input length cannot be negative");
        }
        if (inBuf == null || outBuf == null) {
            throw new NullPointerException("buffer value is null");
        }
        if (inBuf.length < inOff + length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outBuf.length < outOff + length) {
            throw new OutputLengthException("output buffer too short");
        }
        if (this.forEncryption) {
            return this.encryptBlock(inBuf, inOff, length, outBuf, outOff);
        }
        return this.decryptBlock(inBuf, inOff, length, outBuf, outOff);
    }

    protected static short[] toShortArray(byte[] buf) {
        if ((buf.length & 1) != 0) {
            throw new IllegalArgumentException("data must be an even number of bytes for a wide radix");
        }
        short[] sArray = new short[buf.length / 2];
        for (int i2 = 0; i2 != sArray.length; ++i2) {
            sArray[i2] = Pack.bigEndianToShort(buf, i2 * 2);
        }
        return sArray;
    }

    protected static byte[] toByteArray(short[] buf) {
        byte[] byArray = new byte[buf.length * 2];
        for (int i2 = 0; i2 != buf.length; ++i2) {
            Pack.shortToBigEndian(buf[i2], byArray, i2 * 2);
        }
        return byArray;
    }

    public abstract void init(boolean var1, CipherParameters var2);

    public abstract String getAlgorithmName();

    protected abstract int encryptBlock(byte[] var1, int var2, int var3, byte[] var4, int var5);

    protected abstract int decryptBlock(byte[] var1, int var2, int var3, byte[] var4, int var5);
}

