/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.generators;

import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.digests.Blake2bDigest;
import com.enterprisedt.bouncycastle.crypto.params.Argon2Parameters;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Longs;
import com.enterprisedt.bouncycastle.util.Pack;

public class Argon2BytesGenerator {
    private static final byte[] a = new byte[4];
    private Argon2Parameters b;
    private a[] c;
    private int d;
    private int e;

    public void init(Argon2Parameters parameters) {
        this.b = parameters;
        if (parameters.getLanes() < 1) {
            throw new IllegalStateException("lanes must be greater than 1");
        }
        if (parameters.getLanes() > 0x1000000) {
            throw new IllegalStateException("lanes must be less than 16777216");
        }
        if (parameters.getMemory() < 2 * parameters.getLanes()) {
            throw new IllegalStateException("memory is less than: " + 2 * parameters.getLanes() + " expected " + 2 * parameters.getLanes());
        }
        if (parameters.getIterations() < 1) {
            throw new IllegalStateException("iterations is less than: 1");
        }
        this.a(parameters);
    }

    public int generateBytes(char[] password, byte[] out) {
        return this.generateBytes(this.b.getCharToByteConverter().convert(password), out);
    }

    public int generateBytes(char[] password, byte[] out, int outOff, int outLen) {
        return this.generateBytes(this.b.getCharToByteConverter().convert(password), out, outOff, outLen);
    }

    public int generateBytes(byte[] password, byte[] out) {
        return this.generateBytes(password, out, 0, out.length);
    }

    public int generateBytes(byte[] password, byte[] out, int outOff, int outLen) {
        if (outLen < 4) {
            throw new IllegalStateException("output length less than 4");
        }
        byte[] byArray = new byte[1024];
        this.a(byArray, password, outLen);
        this.b();
        this.a(byArray, out, outOff, outLen);
        this.a();
        return outLen;
    }

    private void a() {
        if (null != this.c) {
            for (int i2 = 0; i2 < this.c.length; ++i2) {
                a a2 = this.c[i2];
                if (null == a2) continue;
                a2.a();
            }
        }
    }

    private void a(Argon2Parameters argon2Parameters) {
        int n2 = argon2Parameters.getMemory();
        if (n2 < 8 * argon2Parameters.getLanes()) {
            n2 = 8 * argon2Parameters.getLanes();
        }
        this.d = n2 / (argon2Parameters.getLanes() * 4);
        this.e = this.d * 4;
        n2 = this.d * (argon2Parameters.getLanes() * 4);
        this.a(n2);
    }

    private void a(int n2) {
        this.c = new a[n2];
        for (int i2 = 0; i2 < this.c.length; ++i2) {
            this.c[i2] = new a();
        }
    }

    private void b() {
        b b2 = new b();
        c c2 = new c();
        for (int i2 = 0; i2 < this.b.getIterations(); ++i2) {
            c2.a = i2;
            for (int i3 = 0; i3 < 4; ++i3) {
                c2.c = i3;
                int n2 = 0;
                while (n2 < this.b.getLanes()) {
                    c2.b = n2++;
                    this.a(b2, c2);
                }
            }
        }
    }

    private void a(b b2, c c2) {
        a a2 = null;
        a a3 = null;
        boolean bl = this.a(c2);
        int n2 = Argon2BytesGenerator.c(c2);
        int n3 = c2.b * this.e + c2.c * this.d + n2;
        int n4 = this.b(n3);
        if (bl) {
            a2 = b2.c.a();
            a3 = b2.d.a();
            this.a(b2, c2, a3, a2);
        }
        boolean bl2 = this.b(c2);
        for (int i2 = n2; i2 < this.d; ++i2) {
            long l2;
            int n5 = this.a(c2, l2 = this.a(b2, i2, a2, a3, n4, bl));
            int n6 = this.a(c2, i2, l2, n5 == c2.b);
            a a4 = this.c[n4];
            a a5 = this.c[this.e * n5 + n6];
            a a6 = this.c[n3];
            if (bl2) {
                b2.b(a4, a5, a6);
            } else {
                b2.a(a4, a5, a6);
            }
            n4 = n3++;
        }
    }

    private boolean a(c c2) {
        return this.b.getType() == 1 || this.b.getType() == 2 && c2.a == 0 && c2.c < 2;
    }

    private void a(b b2, c c2, a a2, a a3) {
        ((a)a2).a[0] = this.c(c2.a);
        ((a)a2).a[1] = this.c(c2.b);
        ((a)a2).a[2] = this.c(c2.c);
        ((a)a2).a[3] = this.c(this.c.length);
        ((a)a2).a[4] = this.c(this.b.getIterations());
        ((a)a2).a[5] = this.c(this.b.getType());
        if (c2.a == 0 && c2.c == 0) {
            this.a(b2, a2, a3);
        }
    }

    private boolean b(c c2) {
        return c2.a != 0 && this.b.getVersion() != 16;
    }

    private int b(int n2) {
        if (n2 % this.e == 0) {
            return n2 + this.e - 1;
        }
        return n2 - 1;
    }

    private static int c(c c2) {
        if (c2.a == 0 && c2.c == 0) {
            return 2;
        }
        return 0;
    }

    private void a(b b2, a a2, a a3) {
        long[] lArray = a2.a;
        lArray[6] = lArray[6] + 1L;
        b2.a(a2, a3);
        b2.a(a3, a3);
    }

    private long a(b b2, int n2, a a2, a a3, int n3, boolean bl) {
        if (bl) {
            int n4 = n2 % 128;
            if (n4 == 0) {
                this.a(b2, a3, a2);
            }
            return a2.a[n4];
        }
        return this.c[n3].a[0];
    }

    private int a(c c2, long l2) {
        int n2 = (int)((l2 >>> 32) % (long)this.b.getLanes());
        if (c2.a == 0 && c2.c == 0) {
            n2 = c2.b;
        }
        return n2;
    }

    private int a(c c2, int n2, long l2, boolean bl) {
        int n3;
        int n4;
        if (c2.a == 0) {
            n4 = 0;
            n3 = bl ? c2.c * this.d + n2 - 1 : c2.c * this.d + (n2 == 0 ? -1 : 0);
        } else {
            n4 = (c2.c + 1) * this.d % this.e;
            n3 = bl ? this.e - this.d + n2 - 1 : this.e - this.d + (n2 == 0 ? -1 : 0);
        }
        long l3 = l2 & 0xFFFFFFFFL;
        l3 = l3 * l3 >>> 32;
        l3 = (long)(n3 - 1) - ((long)n3 * l3 >>> 32);
        return (int)((long)n4 + l3) % this.e;
    }

    private void a(byte[] byArray, byte[] byArray2, int n2, int n3) {
        a a2 = this.c[this.e - 1];
        for (int i2 = 1; i2 < this.b.getLanes(); ++i2) {
            int n4 = i2 * this.e + (this.e - 1);
            a2.c(this.c[n4]);
        }
        a2.b(byArray);
        this.b(byArray, byArray2, n2, n3);
    }

    private void b(byte[] byArray, byte[] byArray2, int n2, int n3) {
        byte[] byArray3 = new byte[4];
        Pack.intToLittleEndian(n3, byArray3, 0);
        int n4 = 64;
        if (n3 <= n4) {
            Blake2bDigest blake2bDigest = new Blake2bDigest(n3 * 8);
            blake2bDigest.update(byArray3, 0, byArray3.length);
            blake2bDigest.update(byArray, 0, byArray.length);
            blake2bDigest.doFinal(byArray2, n2);
        } else {
            Blake2bDigest blake2bDigest = new Blake2bDigest(n4 * 8);
            byte[] byArray4 = new byte[n4];
            blake2bDigest.update(byArray3, 0, byArray3.length);
            blake2bDigest.update(byArray, 0, byArray.length);
            blake2bDigest.doFinal(byArray4, 0);
            int n5 = n4 / 2;
            int n6 = n2;
            System.arraycopy(byArray4, 0, byArray2, n6, n5);
            n6 += n5;
            int n7 = (n3 + 31) / 32 - 2;
            int n8 = 2;
            while (n8 <= n7) {
                blake2bDigest.update(byArray4, 0, byArray4.length);
                blake2bDigest.doFinal(byArray4, 0);
                System.arraycopy(byArray4, 0, byArray2, n6, n5);
                ++n8;
                n6 += n5;
            }
            n8 = n3 - 32 * n7;
            blake2bDigest = new Blake2bDigest(n8 * 8);
            blake2bDigest.update(byArray4, 0, byArray4.length);
            blake2bDigest.doFinal(byArray2, n6);
        }
    }

    private static void b(a a2, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17) {
        long[] lArray = a2.a;
        Argon2BytesGenerator.a(lArray, n2, n6, n10, n14);
        Argon2BytesGenerator.a(lArray, n3, n7, n11, n15);
        Argon2BytesGenerator.a(lArray, n4, n8, n12, n16);
        Argon2BytesGenerator.a(lArray, n5, n9, n13, n17);
        Argon2BytesGenerator.a(lArray, n2, n7, n12, n17);
        Argon2BytesGenerator.a(lArray, n3, n8, n13, n14);
        Argon2BytesGenerator.a(lArray, n4, n9, n10, n15);
        Argon2BytesGenerator.a(lArray, n5, n6, n11, n16);
    }

    private static void a(long[] lArray, int n2, int n3, int n4, int n5) {
        Argon2BytesGenerator.b(lArray, n2, n3, n5, 32);
        Argon2BytesGenerator.b(lArray, n4, n5, n3, 24);
        Argon2BytesGenerator.b(lArray, n2, n3, n5, 16);
        Argon2BytesGenerator.b(lArray, n4, n5, n3, 63);
    }

    private static void b(long[] lArray, int n2, int n3, int n4, int n5) {
        long l2 = lArray[n2];
        long l3 = lArray[n3];
        long l4 = lArray[n4];
        l2 += l3 + 2L * (l2 & 0xFFFFFFFFL) * (l3 & 0xFFFFFFFFL);
        l4 = Longs.rotateRight(l4 ^ l2, n5);
        lArray[n2] = l2;
        lArray[n4] = l4;
    }

    private void a(byte[] byArray, byte[] byArray2, int n2) {
        Blake2bDigest blake2bDigest = new Blake2bDigest(512);
        int[] nArray = new int[]{this.b.getLanes(), n2, this.b.getMemory(), this.b.getIterations(), this.b.getVersion(), this.b.getType()};
        Pack.intToLittleEndian(nArray, byArray, 0);
        blake2bDigest.update(byArray, 0, nArray.length * 4);
        Argon2BytesGenerator.a(byArray, blake2bDigest, byArray2);
        Argon2BytesGenerator.a(byArray, blake2bDigest, this.b.getSalt());
        Argon2BytesGenerator.a(byArray, blake2bDigest, this.b.getSecret());
        Argon2BytesGenerator.a(byArray, blake2bDigest, this.b.getAdditional());
        byte[] byArray3 = new byte[72];
        blake2bDigest.doFinal(byArray3, 0);
        this.a(byArray, byArray3);
    }

    private static void a(byte[] byArray, Digest digest, byte[] byArray2) {
        if (null == byArray2) {
            digest.update(a, 0, 4);
            return;
        }
        Pack.intToLittleEndian(byArray2.length, byArray, 0);
        digest.update(byArray, 0, 4);
        digest.update(byArray2, 0, byArray2.length);
    }

    private void a(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[72];
        System.arraycopy(byArray2, 0, byArray3, 0, 64);
        byArray3[64] = 1;
        for (int i2 = 0; i2 < this.b.getLanes(); ++i2) {
            Pack.intToLittleEndian(i2, byArray2, 68);
            Pack.intToLittleEndian(i2, byArray3, 68);
            this.b(byArray2, byArray, 0, 1024);
            this.c[i2 * this.e + 0].a(byArray);
            this.b(byArray3, byArray, 0, 1024);
            this.c[i2 * this.e + 1].a(byArray);
        }
    }

    private long c(int n2) {
        return (long)n2 & 0xFFFFFFFFL;
    }

    private static class c {
        int a;
        int b;
        int c;

        c() {
        }
    }

    private static class a {
        private final long[] a = new long[128];

        private a() {
        }

        void a(byte[] byArray) {
            if (byArray.length < 1024) {
                throw new IllegalArgumentException("input shorter than blocksize");
            }
            Pack.littleEndianToLong(byArray, 0, this.a);
        }

        void b(byte[] byArray) {
            if (byArray.length < 1024) {
                throw new IllegalArgumentException("output shorter than blocksize");
            }
            Pack.longToLittleEndian(this.a, byArray, 0);
        }

        private void b(a a2) {
            System.arraycopy(a2.a, 0, this.a, 0, 128);
        }

        private void c(a a2, a a3) {
            long[] lArray = this.a;
            long[] lArray2 = a2.a;
            long[] lArray3 = a3.a;
            for (int i2 = 0; i2 < 128; ++i2) {
                lArray[i2] = lArray2[i2] ^ lArray3[i2];
            }
        }

        private void c(a a2) {
            long[] lArray = this.a;
            long[] lArray2 = a2.a;
            for (int i2 = 0; i2 < 128; ++i2) {
                int n2 = i2;
                lArray[n2] = lArray[n2] ^ lArray2[i2];
            }
        }

        private void d(a a2, a a3) {
            long[] lArray = this.a;
            long[] lArray2 = a2.a;
            long[] lArray3 = a3.a;
            for (int i2 = 0; i2 < 128; ++i2) {
                int n2 = i2;
                lArray[n2] = lArray[n2] ^ (lArray2[i2] ^ lArray3[i2]);
            }
        }

        public a a() {
            Arrays.fill(this.a, 0L);
            return this;
        }
    }

    private static class b {
        a a = new a();
        a b = new a();
        a c = new a();
        a d = new a();

        private b() {
        }

        private void a() {
            int n2;
            int n3;
            for (n3 = 0; n3 < 8; ++n3) {
                n2 = 16 * n3;
                Argon2BytesGenerator.b(this.b, n2, n2 + 1, n2 + 2, n2 + 3, n2 + 4, n2 + 5, n2 + 6, n2 + 7, n2 + 8, n2 + 9, n2 + 10, n2 + 11, n2 + 12, n2 + 13, n2 + 14, n2 + 15);
            }
            for (n3 = 0; n3 < 8; ++n3) {
                n2 = 2 * n3;
                Argon2BytesGenerator.b(this.b, n2, n2 + 1, n2 + 16, n2 + 17, n2 + 32, n2 + 33, n2 + 48, n2 + 49, n2 + 64, n2 + 65, n2 + 80, n2 + 81, n2 + 96, n2 + 97, n2 + 112, n2 + 113);
            }
        }

        private void a(a a2, a a3) {
            this.b.b(a2);
            this.a();
            a3.c(a2, this.b);
        }

        private void a(a a2, a a3, a a4) {
            this.a.c(a2, a3);
            this.b.b(this.a);
            this.a();
            a4.c(this.a, this.b);
        }

        private void b(a a2, a a3, a a4) {
            this.a.c(a2, a3);
            this.b.b(this.a);
            this.a();
            a4.d(this.a, this.b);
        }
    }
}

