/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.hpke;

import com.enterprisedt.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.enterprisedt.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.enterprisedt.bouncycastle.crypto.BasicAgreement;
import com.enterprisedt.bouncycastle.crypto.agreement.ECDHCBasicAgreement;
import com.enterprisedt.bouncycastle.crypto.agreement.XDHBasicAgreement;
import com.enterprisedt.bouncycastle.crypto.generators.ECKeyPairGenerator;
import com.enterprisedt.bouncycastle.crypto.generators.X25519KeyPairGenerator;
import com.enterprisedt.bouncycastle.crypto.generators.X448KeyPairGenerator;
import com.enterprisedt.bouncycastle.crypto.hpke.b;
import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ECDomainParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECKeyGenerationParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.X25519KeyGenerationParameters;
import com.enterprisedt.bouncycastle.crypto.params.X25519PrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.X25519PublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.X448KeyGenerationParameters;
import com.enterprisedt.bouncycastle.crypto.params.X448PrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.X448PublicKeyParameters;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.bouncycastle.math.ec.FixedPointCombMultiplier;
import com.enterprisedt.bouncycastle.math.ec.WNafUtil;
import com.enterprisedt.bouncycastle.math.ec.custom.sec.SecP256R1Curve;
import com.enterprisedt.bouncycastle.math.ec.custom.sec.SecP384R1Curve;
import com.enterprisedt.bouncycastle.math.ec.custom.sec.SecP521R1Curve;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Pack;
import com.enterprisedt.bouncycastle.util.Strings;
import com.enterprisedt.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;
import java.security.SecureRandom;

class a {
    private AsymmetricCipherKeyPairGenerator b;
    private BasicAgreement c;
    private final short d;
    private b e;
    private byte f;
    private int g;
    private int h;
    ECDomainParameters a;

    protected a(short s2) {
        this.d = s2;
        switch (s2) {
            case 16: {
                this.e = new b(1);
                SecP256R1Curve secP256R1Curve = new SecP256R1Curve();
                this.a = new ECDomainParameters(secP256R1Curve, secP256R1Curve.createPoint(new BigInteger(1, Hex.decode("6b17d1f2e12c4247f8bce6e563a440f277037d812deb33a0f4a13945d898c296")), new BigInteger(1, Hex.decode("4fe342e2fe1a7f9b8ee7eb4a7c0f9e162bce33576b315ececbb6406837bf51f5"))), secP256R1Curve.getOrder(), secP256R1Curve.getCofactor(), Hex.decode("c49d360886e704936a6678e1139d26b7819f7e90"));
                this.c = new ECDHCBasicAgreement();
                this.f = (byte)-1;
                this.g = 32;
                this.h = 32;
                this.b = new ECKeyPairGenerator();
                this.b.init(new ECKeyGenerationParameters(this.a, new SecureRandom()));
                break;
            }
            case 17: {
                this.e = new b(2);
                SecP384R1Curve secP384R1Curve = new SecP384R1Curve();
                this.a = new ECDomainParameters(secP384R1Curve, secP384R1Curve.createPoint(new BigInteger(1, Hex.decode("aa87ca22be8b05378eb1c71ef320ad746e1d3b628ba79b9859f741e082542a385502f25dbf55296c3a545e3872760ab7")), new BigInteger(1, Hex.decode("3617de4a96262c6f5d9e98bf9292dc29f8f41dbd289a147ce9da3113b5f0b8c00a60b1ce1d7e819d7a431d7c90ea0e5f"))), secP384R1Curve.getOrder(), secP384R1Curve.getCofactor(), Hex.decode("a335926aa319a27a1d00896a6773a4827acdac73"));
                this.c = new ECDHCBasicAgreement();
                this.f = (byte)-1;
                this.g = 48;
                this.h = 48;
                this.b = new ECKeyPairGenerator();
                this.b.init(new ECKeyGenerationParameters(this.a, new SecureRandom()));
                break;
            }
            case 18: {
                this.e = new b(3);
                SecP521R1Curve secP521R1Curve = new SecP521R1Curve();
                this.a = new ECDomainParameters(secP521R1Curve, secP521R1Curve.createPoint(new BigInteger("c6858e06b70404e9cd9e3ecb662395b4429c648139053fb521f828af606b4d3dbaa14b5e77efe75928fe1dc127a2ffa8de3348b3c1856a429bf97e7e31c2e5bd66", 16), new BigInteger("11839296a789a3bc0045c8a5fb42c7d1bd998f54449579b446817afbd17273e662c97ee72995ef42640c550b9013fad0761353c7086a272c24088be94769fd16650", 16)), secP521R1Curve.getOrder(), secP521R1Curve.getCofactor(), Hex.decode("d09e8800291cb85396cc6717393284aaa0da64ba"));
                this.c = new ECDHCBasicAgreement();
                this.f = 1;
                this.g = 66;
                this.h = 64;
                this.b = new ECKeyPairGenerator();
                this.b.init(new ECKeyGenerationParameters(this.a, new SecureRandom()));
                break;
            }
            case 32: {
                this.e = new b(1);
                this.c = new XDHBasicAgreement();
                this.h = 32;
                this.g = 32;
                this.b = new X25519KeyPairGenerator();
                this.b.init(new X25519KeyGenerationParameters(new SecureRandom()));
                break;
            }
            case 33: {
                this.e = new b(3);
                this.c = new XDHBasicAgreement();
                this.h = 64;
                this.g = 56;
                this.b = new X448KeyPairGenerator();
                this.b.init(new X448KeyGenerationParameters(new SecureRandom()));
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid kem id");
            }
        }
    }

    public byte[] a(AsymmetricKeyParameter asymmetricKeyParameter) {
        switch (this.d) {
            case 16: 
            case 17: 
            case 18: {
                return ((ECPublicKeyParameters)asymmetricKeyParameter).getQ().getEncoded(false);
            }
            case 33: {
                return ((X448PublicKeyParameters)asymmetricKeyParameter).getEncoded();
            }
            case 32: {
                return ((X25519PublicKeyParameters)asymmetricKeyParameter).getEncoded();
            }
        }
        throw new IllegalStateException("invalid kem id");
    }

    public byte[] b(AsymmetricKeyParameter asymmetricKeyParameter) {
        switch (this.d) {
            case 16: 
            case 17: 
            case 18: {
                return this.a(((ECPrivateKeyParameters)asymmetricKeyParameter).getD().toByteArray(), this.g);
            }
            case 33: {
                return ((X448PrivateKeyParameters)asymmetricKeyParameter).getEncoded();
            }
            case 32: {
                return ((X25519PrivateKeyParameters)asymmetricKeyParameter).getEncoded();
            }
        }
        throw new IllegalStateException("invalid kem id");
    }

    public AsymmetricKeyParameter a(byte[] byArray) {
        switch (this.d) {
            case 16: 
            case 17: 
            case 18: {
                ECPoint eCPoint = this.a.getCurve().decodePoint(byArray);
                return new ECPublicKeyParameters(eCPoint, this.a);
            }
            case 33: {
                return new X448PublicKeyParameters(byArray);
            }
            case 32: {
                return new X25519PublicKeyParameters(byArray);
            }
        }
        throw new IllegalStateException("invalid kem id");
    }

    public AsymmetricCipherKeyPair a(byte[] byArray, byte[] byArray2) {
        AsymmetricKeyParameter asymmetricKeyParameter = this.a(byArray2);
        switch (this.d) {
            case 16: 
            case 17: 
            case 18: {
                BigInteger bigInteger = new BigInteger(1, byArray);
                return new AsymmetricCipherKeyPair(asymmetricKeyParameter, new ECPrivateKeyParameters(bigInteger, ((ECPublicKeyParameters)asymmetricKeyParameter).getParameters()));
            }
            case 33: {
                return new AsymmetricCipherKeyPair(asymmetricKeyParameter, new X448PrivateKeyParameters(byArray));
            }
            case 32: {
                return new AsymmetricCipherKeyPair(asymmetricKeyParameter, new X25519PrivateKeyParameters(byArray));
            }
        }
        throw new IllegalStateException("invalid kem id");
    }

    private boolean a(BigInteger bigInteger) {
        BigInteger bigInteger2 = this.a.getN();
        int n2 = bigInteger2.bitLength();
        int n3 = n2 >>> 2;
        if (bigInteger.compareTo(BigInteger.valueOf(1L)) < 0 || bigInteger.compareTo(bigInteger2) >= 0) {
            return false;
        }
        return WNafUtil.getNafWeight(bigInteger) >= n3;
    }

    public AsymmetricCipherKeyPair a() {
        return this.b.generateKeyPair();
    }

    public AsymmetricCipherKeyPair b(byte[] byArray) {
        if (byArray.length < this.g) {
            throw new IllegalArgumentException("input keying material should have length at least " + this.g + " bytes");
        }
        byte[] byArray2 = Arrays.concatenate(Strings.toByteArray("KEM"), Pack.shortToBigEndian(this.d));
        switch (this.d) {
            case 16: 
            case 17: 
            case 18: {
                byte[] byArray3 = this.e.a(null, byArray2, "dkp_prk", byArray);
                int n2 = 0;
                byte[] byArray4 = new byte[1];
                while (true) {
                    if (n2 > 255) {
                        throw new IllegalStateException("DeriveKeyPairError");
                    }
                    byArray4[0] = (byte)n2;
                    byte[] byArray5 = this.e.a(byArray3, byArray2, "candidate", byArray4, this.g);
                    byArray5[0] = (byte)(byArray5[0] & this.f);
                    BigInteger bigInteger = new BigInteger(1, byArray5);
                    if (this.a(bigInteger)) {
                        ECPoint eCPoint = new FixedPointCombMultiplier().multiply(this.a.getG(), bigInteger);
                        ECPrivateKeyParameters eCPrivateKeyParameters = new ECPrivateKeyParameters(bigInteger, this.a);
                        ECPublicKeyParameters eCPublicKeyParameters = new ECPublicKeyParameters(eCPoint, this.a);
                        return new AsymmetricCipherKeyPair(eCPublicKeyParameters, eCPrivateKeyParameters);
                    }
                    ++n2;
                }
            }
            case 33: {
                byte[] byArray6 = this.e.a(null, byArray2, "dkp_prk", byArray);
                byte[] byArray7 = this.e.a(byArray6, byArray2, "sk", null, this.g);
                X448PrivateKeyParameters x448PrivateKeyParameters = new X448PrivateKeyParameters(byArray7);
                return new AsymmetricCipherKeyPair(x448PrivateKeyParameters.generatePublicKey(), x448PrivateKeyParameters);
            }
            case 32: {
                byte[] byArray8 = this.e.a(null, byArray2, "dkp_prk", byArray);
                byte[] byArray9 = this.e.a(byArray8, byArray2, "sk", null, this.g);
                X25519PrivateKeyParameters x25519PrivateKeyParameters = new X25519PrivateKeyParameters(byArray9);
                return new AsymmetricCipherKeyPair(x25519PrivateKeyParameters.generatePublicKey(), x25519PrivateKeyParameters);
            }
        }
        throw new IllegalStateException("invalid kem id");
    }

    protected byte[][] c(AsymmetricKeyParameter asymmetricKeyParameter) {
        return this.a(asymmetricKeyParameter, this.b.generateKeyPair());
    }

    protected byte[][] a(AsymmetricKeyParameter asymmetricKeyParameter, AsymmetricCipherKeyPair asymmetricCipherKeyPair) {
        byte[][] byArrayArray = new byte[2][];
        this.c.init(asymmetricCipherKeyPair.getPrivate());
        byte[] byArray = this.c.calculateAgreement(asymmetricKeyParameter).toByteArray();
        byte[] byArray2 = this.a(byArray, this.c.getFieldSize());
        byte[] byArray3 = this.a(asymmetricCipherKeyPair.getPublic());
        byte[] byArray4 = this.a(asymmetricKeyParameter);
        byte[] byArray5 = Arrays.concatenate(byArray3, byArray4);
        byte[] byArray6 = this.b(byArray2, byArray5);
        byArrayArray[0] = byArray6;
        byArrayArray[1] = byArray3;
        return byArrayArray;
    }

    protected byte[] a(byte[] byArray, AsymmetricCipherKeyPair asymmetricCipherKeyPair) {
        AsymmetricKeyParameter asymmetricKeyParameter = this.a(byArray);
        this.c.init(asymmetricCipherKeyPair.getPrivate());
        byte[] byArray2 = this.c.calculateAgreement(asymmetricKeyParameter).toByteArray();
        byte[] byArray3 = this.a(byArray2, this.c.getFieldSize());
        byte[] byArray4 = this.a(asymmetricCipherKeyPair.getPublic());
        byte[] byArray5 = Arrays.concatenate(byArray, byArray4);
        byte[] byArray6 = this.b(byArray3, byArray5);
        return byArray6;
    }

    protected byte[][] b(AsymmetricKeyParameter asymmetricKeyParameter, AsymmetricCipherKeyPair asymmetricCipherKeyPair) {
        byte[][] byArrayArray = new byte[2][];
        AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = this.b.generateKeyPair();
        this.c.init(asymmetricCipherKeyPair2.getPrivate());
        byte[] byArray = this.c.calculateAgreement(asymmetricKeyParameter).toByteArray();
        byte[] byArray2 = this.a(byArray, this.c.getFieldSize());
        this.c.init(asymmetricCipherKeyPair.getPrivate());
        byArray = this.c.calculateAgreement(asymmetricKeyParameter).toByteArray();
        byte[] byArray3 = this.a(byArray, this.c.getFieldSize());
        byte[] byArray4 = Arrays.concatenate(byArray2, byArray3);
        byte[] byArray5 = this.a(asymmetricCipherKeyPair2.getPublic());
        byte[] byArray6 = this.a(asymmetricKeyParameter);
        byte[] byArray7 = this.a(asymmetricCipherKeyPair.getPublic());
        byte[] byArray8 = Arrays.concatenate(byArray5, byArray6, byArray7);
        byte[] byArray9 = this.b(byArray4, byArray8);
        byArrayArray[0] = byArray9;
        byArrayArray[1] = byArray5;
        return byArrayArray;
    }

    protected byte[] a(byte[] byArray, AsymmetricCipherKeyPair asymmetricCipherKeyPair, AsymmetricKeyParameter asymmetricKeyParameter) {
        AsymmetricKeyParameter asymmetricKeyParameter2 = this.a(byArray);
        this.c.init(asymmetricCipherKeyPair.getPrivate());
        byte[] byArray2 = this.c.calculateAgreement(asymmetricKeyParameter2).toByteArray();
        byte[] byArray3 = this.a(byArray2, this.c.getFieldSize());
        this.c.init(asymmetricCipherKeyPair.getPrivate());
        byArray2 = this.c.calculateAgreement(asymmetricKeyParameter).toByteArray();
        byte[] byArray4 = this.a(byArray2, this.c.getFieldSize());
        byte[] byArray5 = Arrays.concatenate(byArray3, byArray4);
        byte[] byArray6 = this.a(asymmetricCipherKeyPair.getPublic());
        byte[] byArray7 = this.a(asymmetricKeyParameter);
        byte[] byArray8 = Arrays.concatenate(byArray, byArray6, byArray7);
        byte[] byArray9 = this.b(byArray5, byArray8);
        return byArray9;
    }

    private byte[] b(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = Arrays.concatenate(Strings.toByteArray("KEM"), Pack.shortToBigEndian(this.d));
        byte[] byArray4 = this.e.a(null, byArray3, "eae_prk", byArray);
        byte[] byArray5 = this.e.a(byArray4, byArray3, "shared_secret", byArray2, this.h);
        return byArray5;
    }

    private byte[] a(byte[] byArray, int n2) {
        byte[] byArray2 = new byte[n2];
        if (byArray.length <= n2) {
            System.arraycopy(byArray, 0, byArray2, n2 - byArray.length, byArray.length);
        } else {
            System.arraycopy(byArray, byArray.length - n2, byArray2, 0, n2);
        }
        return byArray2;
    }
}

