/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.io;

import com.enterprisedt.bouncycastle.crypto.Mac;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MacInputStream
extends FilterInputStream {
    protected Mac mac;

    public MacInputStream(InputStream stream, Mac mac) {
        super(stream);
        this.mac = mac;
    }

    @Override
    public int read() throws IOException {
        int n2 = this.in.read();
        if (n2 >= 0) {
            this.mac.update((byte)n2);
        }
        return n2;
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        int n2 = this.in.read(b2, off, len);
        if (n2 >= 0) {
            this.mac.update(b2, off, n2);
        }
        return n2;
    }

    public Mac getMac() {
        return this.mac;
    }
}

